/*
 * Decompiled with CFR 0.152.
 */
package manifold.collections.api.range;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.NoSuchElementException;
import manifold.collections.api.range.NumberRange;

public final class BigDecimalRange
extends NumberRange<BigDecimal, BigDecimalRange> {
    public BigDecimalRange(BigDecimal left, BigDecimal right) {
        this(left, right, BigDecimal.ONE, true, true, false);
    }

    public BigDecimalRange(BigDecimal left, BigDecimal right, BigDecimal step, boolean leftClosed, boolean rightClosed, boolean reverse) {
        super(left, right, step, leftClosed, rightClosed, reverse);
        if (step.compareTo(BigDecimal.ZERO) <= 0) {
            throw new IllegalArgumentException("The step must be greater than 0: " + step);
        }
    }

    @Override
    public Iterator<BigDecimal> iterateFromLeft() {
        return new ForwardIterator();
    }

    @Override
    public Iterator<BigDecimal> iterateFromRight() {
        return new ReverseIterator();
    }

    @Override
    public BigDecimal getFromLeft(int iStepIndex) {
        if (iStepIndex < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + iStepIndex);
        }
        if (!this.isLeftClosed()) {
            ++iStepIndex;
        }
        BigDecimal value = ((BigDecimal)this.getLeftEndpoint()).add(((BigDecimal)this.getStep()).multiply(BigDecimal.valueOf(iStepIndex)));
        int iComp = value.compareTo((BigDecimal)this.getRightEndpoint());
        if (this.isRightClosed() ? iComp <= 0 : iComp < 0) {
            return value;
        }
        return null;
    }

    @Override
    public BigDecimal getFromRight(int iStepIndex) {
        if (iStepIndex < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + iStepIndex);
        }
        if (!this.isRightClosed()) {
            ++iStepIndex;
        }
        BigDecimal value = ((BigDecimal)this.getRightEndpoint()).subtract(((BigDecimal)this.getStep()).multiply(BigDecimal.valueOf(iStepIndex)));
        int iComp = value.compareTo((BigDecimal)this.getLeftEndpoint());
        if (this.isLeftClosed() ? iComp >= 0 : iComp > 0) {
            return value;
        }
        return null;
    }

    private class ReverseIterator
    implements Iterator<BigDecimal> {
        private BigDecimal _csr;

        public ReverseIterator() {
            this._csr = (BigDecimal)BigDecimalRange.this.getRightEndpoint();
            if (!BigDecimalRange.this.isRightClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            int iComp = this._csr.compareTo((BigDecimal)BigDecimalRange.this.getLeftEndpoint());
            return iComp > 0 || BigDecimalRange.this.isLeftClosed() && iComp == 0;
        }

        @Override
        public BigDecimal next() {
            int iComp = this._csr.compareTo((BigDecimal)BigDecimalRange.this.getLeftEndpoint());
            if (iComp < 0 || !BigDecimalRange.this.isLeftClosed() && iComp == 0) {
                throw new NoSuchElementException();
            }
            BigDecimal ret = this._csr;
            this._csr = this._csr.subtract((BigDecimal)BigDecimalRange.this.getStep());
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ForwardIterator
    implements Iterator<BigDecimal> {
        private BigDecimal _csr;

        public ForwardIterator() {
            this._csr = (BigDecimal)BigDecimalRange.this.getLeftEndpoint();
            if (!BigDecimalRange.this.isLeftClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            int iComp = this._csr.compareTo((BigDecimal)BigDecimalRange.this.getRightEndpoint());
            return iComp < 0 || BigDecimalRange.this.isRightClosed() && iComp == 0;
        }

        @Override
        public BigDecimal next() {
            int iComp = this._csr.compareTo((BigDecimal)BigDecimalRange.this.getRightEndpoint());
            if (iComp > 0 || !BigDecimalRange.this.isRightClosed() && iComp == 0) {
                throw new NoSuchElementException();
            }
            BigDecimal ret = this._csr;
            this._csr = this._csr.add((BigDecimal)BigDecimalRange.this.getStep());
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

