/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Internal;
import graphql.language.Definition;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.Node;
import graphql.validation.AbstractRule;
import graphql.validation.DocumentVisitor;
import graphql.validation.LanguageTraversal;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Internal
public class NoFragmentCycles
extends AbstractRule {
    private final Map<String, List<FragmentSpread>> fragmentSpreads = new LinkedHashMap<String, List<FragmentSpread>>();

    public NoFragmentCycles(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
        this.prepareFragmentMap();
    }

    private void prepareFragmentMap() {
        List<Definition> definitions = this.getValidationContext().getDocument().getDefinitions();
        for (Definition definition : definitions) {
            if (!(definition instanceof FragmentDefinition)) continue;
            FragmentDefinition fragmentDefinition = (FragmentDefinition)definition;
            this.fragmentSpreads.put(fragmentDefinition.getName(), this.gatherSpreads(fragmentDefinition));
        }
    }

    private List<FragmentSpread> gatherSpreads(FragmentDefinition fragmentDefinition) {
        final ArrayList<FragmentSpread> fragmentSpreads = new ArrayList<FragmentSpread>();
        DocumentVisitor visitor = new DocumentVisitor(){

            @Override
            public void enter(Node node, List<Node> path) {
                if (node instanceof FragmentSpread) {
                    fragmentSpreads.add((FragmentSpread)node);
                }
            }

            @Override
            public void leave(Node node, List<Node> path) {
            }
        };
        new LanguageTraversal().traverse(fragmentDefinition, visitor);
        return fragmentSpreads;
    }

    @Override
    public void checkFragmentDefinition(FragmentDefinition fragmentDefinition) {
        ArrayList<FragmentSpread> spreadPath = new ArrayList<FragmentSpread>();
        this.detectCycleRecursive(fragmentDefinition.getName(), fragmentDefinition.getName(), spreadPath);
    }

    private void detectCycleRecursive(String fragmentName, String initialName, List<FragmentSpread> spreadPath) {
        List<FragmentSpread> fragmentSpreads = this.fragmentSpreads.get(fragmentName);
        if (fragmentSpreads == null) {
            return;
        }
        block0: for (FragmentSpread fragmentSpread : fragmentSpreads) {
            if (fragmentSpread.getName().equals(initialName)) {
                String message = "Fragment cycles not allowed";
                this.addError(ValidationErrorType.FragmentCycle, spreadPath, message);
                continue;
            }
            for (FragmentSpread spread : spreadPath) {
                if (!spread.equals(fragmentSpread)) continue;
                continue block0;
            }
            spreadPath.add(fragmentSpread);
            this.detectCycleRecursive(fragmentSpread.getName(), initialName, spreadPath);
            spreadPath.remove(spreadPath.size() - 1);
        }
    }
}

