/*
 * Decompiled with CFR 0.152.
 */
package graphql.parser;

import graphql.Assert;
import graphql.PublicApi;
import java.util.function.Consumer;

@PublicApi
public class ParserOptions {
    public static final int MAX_QUERY_TOKENS = 15000;
    public static final int MAX_WHITESPACE_TOKENS = 200000;
    private static ParserOptions defaultJvmParserOptions = ParserOptions.newParserOptions().captureIgnoredChars(false).captureSourceLocation(true).captureLineComments(true).maxTokens(15000).maxWhitespaceTokens(200000).build();
    private static ParserOptions defaultJvmOperationParserOptions = ParserOptions.newParserOptions().captureIgnoredChars(false).captureSourceLocation(true).captureLineComments(false).maxTokens(15000).maxWhitespaceTokens(200000).build();
    private static ParserOptions defaultJvmSdlParserOptions = ParserOptions.newParserOptions().captureIgnoredChars(false).captureSourceLocation(true).captureLineComments(true).maxTokens(Integer.MAX_VALUE).maxWhitespaceTokens(Integer.MAX_VALUE).build();
    private final boolean captureIgnoredChars;
    private final boolean captureSourceLocation;
    private final boolean captureLineComments;
    private final int maxTokens;
    private final int maxWhitespaceTokens;

    public static ParserOptions getDefaultParserOptions() {
        return defaultJvmParserOptions;
    }

    public static void setDefaultParserOptions(ParserOptions options) {
        defaultJvmParserOptions = Assert.assertNotNull(options);
    }

    public static ParserOptions getDefaultOperationParserOptions() {
        return defaultJvmOperationParserOptions;
    }

    public static void setDefaultOperationParserOptions(ParserOptions options) {
        defaultJvmOperationParserOptions = Assert.assertNotNull(options);
    }

    public static ParserOptions getDefaultSdlParserOptions() {
        return defaultJvmSdlParserOptions;
    }

    public static void setDefaultSdlParserOptions(ParserOptions options) {
        defaultJvmSdlParserOptions = Assert.assertNotNull(options);
    }

    private ParserOptions(Builder builder) {
        this.captureIgnoredChars = builder.captureIgnoredChars;
        this.captureSourceLocation = builder.captureSourceLocation;
        this.captureLineComments = builder.captureLineComments;
        this.maxTokens = builder.maxTokens;
        this.maxWhitespaceTokens = builder.maxWhitespaceTokens;
    }

    public boolean isCaptureIgnoredChars() {
        return this.captureIgnoredChars;
    }

    public boolean isCaptureSourceLocation() {
        return this.captureSourceLocation;
    }

    public boolean isCaptureLineComments() {
        return this.captureLineComments;
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public int getMaxWhitespaceTokens() {
        return this.maxWhitespaceTokens;
    }

    public ParserOptions transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static Builder newParserOptions() {
        return new Builder();
    }

    public static class Builder {
        private boolean captureIgnoredChars = false;
        private boolean captureSourceLocation = true;
        private boolean captureLineComments = true;
        private int maxTokens = 15000;
        private int maxWhitespaceTokens = 200000;

        Builder() {
        }

        Builder(ParserOptions parserOptions) {
            this.captureIgnoredChars = parserOptions.captureIgnoredChars;
            this.captureSourceLocation = parserOptions.captureSourceLocation;
            this.captureLineComments = parserOptions.captureLineComments;
            this.maxTokens = parserOptions.maxTokens;
            this.maxWhitespaceTokens = parserOptions.maxWhitespaceTokens;
        }

        public Builder captureIgnoredChars(boolean captureIgnoredChars) {
            this.captureIgnoredChars = captureIgnoredChars;
            return this;
        }

        public Builder captureSourceLocation(boolean captureSourceLocation) {
            this.captureSourceLocation = captureSourceLocation;
            return this;
        }

        public Builder captureLineComments(boolean captureLineComments) {
            this.captureLineComments = captureLineComments;
            return this;
        }

        public Builder maxTokens(int maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public Builder maxWhitespaceTokens(int maxWhitespaceTokens) {
            this.maxWhitespaceTokens = maxWhitespaceTokens;
            return this;
        }

        public ParserOptions build() {
            return new ParserOptions(this);
        }
    }
}

