/*
 * Decompiled with CFR 0.152.
 */
package graphql.nextgen;

import graphql.Assert;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLContext;
import graphql.Internal;
import graphql.ParseAndValidate;
import graphql.ParseAndValidateResult;
import graphql.execution.AbortExecutionException;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionIdProvider;
import graphql.execution.instrumentation.DocumentAndVariables;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.nextgen.Instrumentation;
import graphql.execution.instrumentation.nextgen.InstrumentationCreateStateParameters;
import graphql.execution.instrumentation.nextgen.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.nextgen.InstrumentationValidationParameters;
import graphql.execution.nextgen.DefaultExecutionStrategy;
import graphql.execution.nextgen.Execution;
import graphql.execution.nextgen.ExecutionStrategy;
import graphql.execution.preparsed.NoOpPreparsedDocumentProvider;
import graphql.execution.preparsed.PreparsedDocumentEntry;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.language.Document;
import graphql.schema.GraphQLSchema;
import graphql.util.LogKit;
import graphql.validation.ValidationError;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import manifold.shade.org.slf4j.Logger;
import manifold.shade.org.slf4j.LoggerFactory;

@Internal
public class GraphQL {
    private static final Logger log = LoggerFactory.getLogger(graphql.GraphQL.class);
    private static final Logger logNotSafe = LogKit.getNotPrivacySafeLogger(ExecutionStrategy.class);
    private final GraphQLSchema graphQLSchema;
    private final ExecutionStrategy executionStrategy;
    private final ExecutionIdProvider idProvider;
    private final Instrumentation instrumentation;
    private final PreparsedDocumentProvider preparsedDocumentProvider;

    public GraphQL(Builder builder) {
        this.graphQLSchema = builder.graphQLSchema;
        this.executionStrategy = builder.executionStrategy;
        this.idProvider = builder.idProvider;
        this.preparsedDocumentProvider = builder.preparsedDocumentProvider;
        this.instrumentation = builder.instrumentation;
    }

    public ExecutionResult execute(ExecutionInput.Builder executionInputBuilder) {
        return this.executeAsync(executionInputBuilder.build()).join();
    }

    public CompletableFuture<ExecutionResult> execute(UnaryOperator<ExecutionInput.Builder> builderFunction) {
        return this.executeAsync(((ExecutionInput.Builder)builderFunction.apply(ExecutionInput.newExecutionInput())).build());
    }

    public ExecutionResult execute(ExecutionInput executionInput) {
        return this.executeAsync(executionInput).join();
    }

    public CompletableFuture<ExecutionResult> executeAsync(ExecutionInput.Builder executionInputBuilder) {
        return this.executeAsync(executionInputBuilder.build());
    }

    public CompletableFuture<ExecutionResult> executeAsync(UnaryOperator<ExecutionInput.Builder> builderFunction) {
        return this.executeAsync(((ExecutionInput.Builder)builderFunction.apply(ExecutionInput.newExecutionInput())).build());
    }

    public CompletableFuture<ExecutionResult> executeAsync(ExecutionInput executionInput) {
        try {
            if (logNotSafe.isDebugEnabled()) {
                logNotSafe.debug("Executing request. operation name: '{}'. query: '{}'. variables '{}'", executionInput.getOperationName(), executionInput.getQuery(), executionInput.getVariables());
            }
            InstrumentationState instrumentationState = this.instrumentation.createState(new InstrumentationCreateStateParameters(this.graphQLSchema, executionInput));
            InstrumentationExecutionParameters inputInstrumentationParameters = new InstrumentationExecutionParameters(executionInput, this.graphQLSchema, instrumentationState);
            executionInput = this.instrumentation.instrumentExecutionInput(executionInput, inputInstrumentationParameters);
            InstrumentationExecutionParameters instrumentationParameters = new InstrumentationExecutionParameters(executionInput, this.graphQLSchema, instrumentationState);
            InstrumentationContext<ExecutionResult> executionInstrumentation = this.instrumentation.beginExecution(instrumentationParameters);
            GraphQLSchema graphQLSchema = this.instrumentation.instrumentSchema(this.graphQLSchema, instrumentationParameters);
            CompletionStage<ExecutionResult> executionResult = this.parseValidateAndExecute(executionInput, graphQLSchema, instrumentationState);
            executionResult = ((CompletableFuture)executionResult).whenComplete(executionInstrumentation::onCompleted);
            executionResult = ((CompletableFuture)executionResult).thenApply(result -> this.instrumentation.instrumentExecutionResult((ExecutionResult)result, instrumentationParameters));
            return executionResult;
        }
        catch (AbortExecutionException abortException) {
            return CompletableFuture.completedFuture(abortException.toExecutionResult());
        }
    }

    private CompletableFuture<ExecutionResult> parseValidateAndExecute(ExecutionInput executionInput, GraphQLSchema graphQLSchema, InstrumentationState instrumentationState) {
        AtomicReference<ExecutionInput> executionInputRef = new AtomicReference<ExecutionInput>(executionInput);
        Function<ExecutionInput, PreparsedDocumentEntry> computeFunction = transformedInput -> {
            executionInputRef.set((ExecutionInput)transformedInput);
            return this.parseAndValidate(executionInputRef, graphQLSchema, instrumentationState);
        };
        PreparsedDocumentEntry preparsedDoc = this.preparsedDocumentProvider.getDocument(executionInput, computeFunction);
        if (preparsedDoc.hasErrors()) {
            return CompletableFuture.completedFuture(new ExecutionResultImpl(preparsedDoc.getErrors()));
        }
        return this.execute(executionInputRef.get(), preparsedDoc.getDocument(), graphQLSchema, instrumentationState);
    }

    private PreparsedDocumentEntry parseAndValidate(AtomicReference<ExecutionInput> executionInputRef, GraphQLSchema graphQLSchema, InstrumentationState instrumentationState) {
        List<ValidationError> errors;
        ParseAndValidateResult parseResult;
        ExecutionInput executionInput = executionInputRef.get();
        String query = executionInput.getQuery();
        if (logNotSafe.isDebugEnabled()) {
            logNotSafe.debug("Parsing query: '{}'...", (Object)query);
        }
        if ((parseResult = this.parse(executionInput, graphQLSchema, instrumentationState)).isFailure()) {
            logNotSafe.warn("Query failed to parse : '{}'", (Object)executionInput.getQuery());
            return new PreparsedDocumentEntry(parseResult.getSyntaxException().toInvalidSyntaxError());
        }
        Document document = parseResult.getDocument();
        executionInput = executionInput.transform((ExecutionInput.Builder builder) -> builder.variables(parseResult.getVariables()));
        executionInputRef.set(executionInput);
        if (logNotSafe.isDebugEnabled()) {
            logNotSafe.debug("Validating query: '{}'", (Object)query);
        }
        if (!(errors = this.validate(executionInput, document, graphQLSchema, instrumentationState)).isEmpty()) {
            logNotSafe.warn("Query failed to validate : '{}'", (Object)query);
            return new PreparsedDocumentEntry(errors);
        }
        return new PreparsedDocumentEntry(document);
    }

    private ParseAndValidateResult parse(ExecutionInput executionInput, GraphQLSchema graphQLSchema, InstrumentationState instrumentationState) {
        InstrumentationExecutionParameters parameters = new InstrumentationExecutionParameters(executionInput, graphQLSchema, instrumentationState);
        InstrumentationContext<Document> parseInstrumentation = this.instrumentation.beginParse(parameters);
        CompletableFuture<Document> documentCF = new CompletableFuture<Document>();
        parseInstrumentation.onDispatched(documentCF);
        ParseAndValidateResult parseResult = ParseAndValidate.parse(executionInput);
        if (parseResult.isFailure()) {
            parseInstrumentation.onCompleted(null, parseResult.getSyntaxException());
            return parseResult;
        }
        documentCF.complete(parseResult.getDocument());
        parseInstrumentation.onCompleted(parseResult.getDocument(), null);
        DocumentAndVariables documentAndVariables = parseResult.getDocumentAndVariables();
        documentAndVariables = this.instrumentation.instrumentDocumentAndVariables(documentAndVariables, parameters);
        return ParseAndValidateResult.newResult().document(documentAndVariables.getDocument()).variables(documentAndVariables.getVariables()).build();
    }

    private List<ValidationError> validate(ExecutionInput executionInput, Document document, GraphQLSchema graphQLSchema, InstrumentationState instrumentationState) {
        InstrumentationContext<List<ValidationError>> validationCtx = this.instrumentation.beginValidation(new InstrumentationValidationParameters(executionInput, document, graphQLSchema, instrumentationState));
        CompletableFuture<List<ValidationError>> cf = new CompletableFuture<List<ValidationError>>();
        validationCtx.onDispatched(cf);
        List<ValidationError> validationErrors = ParseAndValidate.validate(graphQLSchema, document);
        validationCtx.onCompleted(validationErrors, null);
        cf.complete(validationErrors);
        return validationErrors;
    }

    private CompletableFuture<ExecutionResult> execute(ExecutionInput executionInput, Document document, GraphQLSchema graphQLSchema, InstrumentationState instrumentationState) {
        String query = executionInput.getQuery();
        String operationName = executionInput.getOperationName();
        GraphQLContext context = executionInput.getGraphQLContext();
        Execution execution = new Execution();
        ExecutionId executionId = this.idProvider.provide(query, operationName, context);
        if (logNotSafe.isDebugEnabled()) {
            logNotSafe.debug("Executing '{}'. operation name: '{}'. query: '{}'. variables '{}'", executionId, executionInput.getOperationName(), executionInput.getQuery(), executionInput.getVariables());
        }
        CompletionStage<ExecutionResult> future = execution.execute(this.executionStrategy, document, graphQLSchema, executionId, executionInput, instrumentationState);
        future = future.whenComplete((result, throwable) -> {
            if (throwable != null) {
                log.error(String.format("Execution '%s' threw exception when executing : query : '%s'. variables '%s'", executionId, executionInput.getQuery(), executionInput.getVariables()), (Throwable)throwable);
            } else if (log.isDebugEnabled()) {
                int errorCount = result.getErrors().size();
                if (errorCount > 0) {
                    log.debug("Execution '{}' completed with '{}' errors", (Object)executionId, (Object)errorCount);
                } else {
                    log.debug("Execution '{}' completed with zero errors", (Object)executionId);
                }
            }
        });
        return future;
    }

    public static Builder newGraphQL(GraphQLSchema graphQLSchema) {
        return new Builder(graphQLSchema);
    }

    public GraphQL transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static class Builder {
        private GraphQLSchema graphQLSchema;
        private ExecutionStrategy executionStrategy = new DefaultExecutionStrategy();
        private ExecutionIdProvider idProvider = ExecutionIdProvider.DEFAULT_EXECUTION_ID_PROVIDER;
        private Instrumentation instrumentation = new Instrumentation(this){
            final /* synthetic */ Builder this$0;
            {
                this.this$0 = this$0;
            }
        };
        private PreparsedDocumentProvider preparsedDocumentProvider = NoOpPreparsedDocumentProvider.INSTANCE;

        public Builder(GraphQLSchema graphQLSchema) {
            this.graphQLSchema = graphQLSchema;
        }

        public Builder(GraphQL graphQL) {
            this.graphQLSchema = graphQL.graphQLSchema;
            this.executionStrategy = graphQL.executionStrategy;
            this.idProvider = graphQL.idProvider;
            this.instrumentation = graphQL.instrumentation;
        }

        public Builder schema(GraphQLSchema graphQLSchema) {
            this.graphQLSchema = Assert.assertNotNull(graphQLSchema, () -> "GraphQLSchema must be non null");
            return this;
        }

        public Builder executionStrategy(ExecutionStrategy executionStrategy) {
            this.executionStrategy = Assert.assertNotNull(executionStrategy, () -> "ExecutionStrategy must be non null");
            return this;
        }

        public Builder instrumentation(Instrumentation instrumentation) {
            this.instrumentation = Assert.assertNotNull(instrumentation, () -> "Instrumentation must be non null");
            return this;
        }

        public Builder preparsedDocumentProvider(PreparsedDocumentProvider preparsedDocumentProvider) {
            this.preparsedDocumentProvider = Assert.assertNotNull(preparsedDocumentProvider, () -> "PreparsedDocumentProvider must be non null");
            return this;
        }

        public Builder executionIdProvider(ExecutionIdProvider executionIdProvider) {
            this.idProvider = Assert.assertNotNull(executionIdProvider, () -> "ExecutionIdProvider must be non null");
            return this;
        }

        public GraphQL build() {
            Assert.assertNotNull(this.graphQLSchema, () -> "graphQLSchema must be non null");
            return new GraphQL(this);
        }
    }
}

