/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.PublicApi;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.ExecutionStrategy;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.FetchedValue;
import graphql.execution.FieldValueInfo;
import graphql.execution.MergedField;
import graphql.execution.MergedSelectionSet;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.ResultPath;
import graphql.execution.instrumentation.ExecutionStrategyInstrumentationContext;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionStrategyParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldParameters;
import graphql.execution.reactive.SubscriptionPublisher;
import graphql.language.Field;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import manifold.shade.org.reactivestreams.Publisher;

@PublicApi
public class SubscriptionExecutionStrategy
extends ExecutionStrategy {
    public SubscriptionExecutionStrategy() {
    }

    public SubscriptionExecutionStrategy(DataFetcherExceptionHandler dataFetcherExceptionHandler) {
        super(dataFetcherExceptionHandler);
    }

    @Override
    public CompletableFuture<ExecutionResult> execute(ExecutionContext executionContext, ExecutionStrategyParameters parameters) throws NonNullableFieldWasNullException {
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationExecutionStrategyParameters instrumentationParameters = new InstrumentationExecutionStrategyParameters(executionContext, parameters);
        ExecutionStrategyInstrumentationContext executionStrategyCtx = instrumentation.beginExecutionStrategy(instrumentationParameters);
        CompletableFuture<Publisher<Object>> sourceEventStream = this.createSourceEventStream(executionContext, parameters);
        CompletionStage overallResult = sourceEventStream.thenApply(publisher -> {
            if (publisher == null) {
                return new ExecutionResultImpl(null, executionContext.getErrors());
            }
            Function<Object, CompletionStage<ExecutionResult>> mapperFunction = eventPayload -> this.executeSubscriptionEvent(executionContext, parameters, eventPayload);
            SubscriptionPublisher mapSourceToResponse = new SubscriptionPublisher((Publisher<Object>)publisher, mapperFunction);
            return new ExecutionResultImpl(mapSourceToResponse, executionContext.getErrors());
        });
        executionStrategyCtx.onDispatched(overallResult);
        ((CompletableFuture)overallResult).whenComplete(executionStrategyCtx::onCompleted);
        return overallResult;
    }

    private CompletableFuture<Publisher<Object>> createSourceEventStream(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        ExecutionStrategyParameters newParameters = this.firstFieldOfSubscriptionSelection(parameters);
        CompletableFuture<FetchedValue> fieldFetched = this.fetchField(executionContext, newParameters);
        return fieldFetched.thenApply(fetchedValue -> {
            Object publisher = fetchedValue.getFetchedValue();
            if (publisher != null) {
                Assert.assertTrue(publisher instanceof Publisher, () -> "Your data fetcher must return a Publisher of events when using graphql subscriptions");
            }
            return (Publisher)publisher;
        });
    }

    private CompletableFuture<ExecutionResult> executeSubscriptionEvent(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Object eventPayload) {
        Instrumentation instrumentation = executionContext.getInstrumentation();
        ExecutionContext newExecutionContext = executionContext.transform(builder -> builder.root(eventPayload).resetErrors());
        ExecutionStrategyParameters newParameters = this.firstFieldOfSubscriptionSelection(parameters);
        ExecutionStepInfo subscribedFieldStepInfo = this.createSubscribedFieldStepInfo(executionContext, newParameters);
        InstrumentationFieldParameters i13nFieldParameters = new InstrumentationFieldParameters(executionContext, () -> subscribedFieldStepInfo);
        InstrumentationContext<ExecutionResult> subscribedFieldCtx = instrumentation.beginSubscribedFieldEvent(i13nFieldParameters);
        FetchedValue fetchedValue = this.unboxPossibleDataFetcherResult(newExecutionContext, parameters, eventPayload);
        FieldValueInfo fieldValueInfo = this.completeField(newExecutionContext, newParameters, fetchedValue);
        CompletionStage overallResult = fieldValueInfo.getFieldValue().thenApply(executionResult -> this.wrapWithRootFieldName(newParameters, (ExecutionResult)executionResult));
        subscribedFieldCtx.onDispatched((CompletableFuture<ExecutionResult>)overallResult);
        ((CompletableFuture)overallResult).whenComplete(subscribedFieldCtx::onCompleted);
        InstrumentationExecutionParameters i13nExecutionParameters = new InstrumentationExecutionParameters(executionContext.getExecutionInput(), executionContext.getGraphQLSchema(), executionContext.getInstrumentationState());
        overallResult = ((CompletableFuture)overallResult).thenCompose(executionResult -> instrumentation.instrumentExecutionResult((ExecutionResult)executionResult, i13nExecutionParameters));
        return overallResult;
    }

    private ExecutionResult wrapWithRootFieldName(ExecutionStrategyParameters parameters, ExecutionResult executionResult) {
        String rootFieldName = this.getRootFieldName(parameters);
        return new ExecutionResultImpl(Collections.singletonMap(rootFieldName, executionResult.getData()), executionResult.getErrors());
    }

    private String getRootFieldName(ExecutionStrategyParameters parameters) {
        Field rootField = parameters.getField().getSingleField();
        return rootField.getResultKey();
    }

    private ExecutionStrategyParameters firstFieldOfSubscriptionSelection(ExecutionStrategyParameters parameters) {
        MergedSelectionSet fields = parameters.getFields();
        MergedField firstField = fields.getSubField(fields.getKeys().get(0));
        ResultPath fieldPath = parameters.getPath().segment(SubscriptionExecutionStrategy.mkNameForPath(firstField.getSingleField()));
        return parameters.transform(builder -> builder.field(firstField).path(fieldPath));
    }

    private ExecutionStepInfo createSubscribedFieldStepInfo(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        Field field = parameters.getField().getSingleField();
        GraphQLObjectType parentType = (GraphQLObjectType)parameters.getExecutionStepInfo().getUnwrappedNonNullType();
        GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext.getGraphQLSchema(), parentType, field);
        return this.createExecutionStepInfo(executionContext, parameters, fieldDef, parentType);
    }
}

