/*
 * Decompiled with CFR 0.152.
 */
package graphql.analysis;

import graphql.Assert;
import graphql.PublicApi;
import graphql.analysis.FieldComplexityCalculator;
import graphql.analysis.FieldComplexityEnvironment;
import graphql.analysis.QueryComplexityInfo;
import graphql.analysis.QueryTraverser;
import graphql.analysis.QueryVisitorFieldEnvironment;
import graphql.analysis.QueryVisitorStub;
import graphql.execution.AbortExecutionException;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationValidationParameters;
import graphql.validation.ValidationError;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import manifold.shade.org.slf4j.Logger;
import manifold.shade.org.slf4j.LoggerFactory;

@PublicApi
public class MaxQueryComplexityInstrumentation
extends SimpleInstrumentation {
    private static final Logger log = LoggerFactory.getLogger(MaxQueryComplexityInstrumentation.class);
    private final int maxComplexity;
    private final FieldComplexityCalculator fieldComplexityCalculator;
    private final Function<QueryComplexityInfo, Boolean> maxQueryComplexityExceededFunction;

    public MaxQueryComplexityInstrumentation(int maxComplexity) {
        this(maxComplexity, (QueryComplexityInfo queryComplexityInfo) -> true);
    }

    public MaxQueryComplexityInstrumentation(int maxComplexity, Function<QueryComplexityInfo, Boolean> maxQueryComplexityExceededFunction) {
        this(maxComplexity, (env, childComplexity) -> 1 + childComplexity, maxQueryComplexityExceededFunction);
    }

    public MaxQueryComplexityInstrumentation(int maxComplexity, FieldComplexityCalculator fieldComplexityCalculator) {
        this(maxComplexity, fieldComplexityCalculator, queryComplexityInfo -> true);
    }

    public MaxQueryComplexityInstrumentation(int maxComplexity, FieldComplexityCalculator fieldComplexityCalculator, Function<QueryComplexityInfo, Boolean> maxQueryComplexityExceededFunction) {
        this.maxComplexity = maxComplexity;
        this.fieldComplexityCalculator = Assert.assertNotNull(fieldComplexityCalculator, () -> "calculator can't be null");
        this.maxQueryComplexityExceededFunction = maxQueryComplexityExceededFunction;
    }

    @Override
    public InstrumentationContext<List<ValidationError>> beginValidation(InstrumentationValidationParameters parameters) {
        return SimpleInstrumentationContext.whenCompleted((errors, throwable) -> {
            QueryComplexityInfo queryComplexityInfo;
            boolean throwAbortException;
            if (errors != null && errors.size() > 0 || throwable != null) {
                return;
            }
            QueryTraverser queryTraverser = this.newQueryTraverser(parameters);
            final LinkedHashMap valuesByParent = new LinkedHashMap();
            queryTraverser.visitPostOrder(new QueryVisitorStub(){

                @Override
                public void visitField(QueryVisitorFieldEnvironment env) {
                    int childsComplexity = valuesByParent.getOrDefault(env, 0);
                    int value = MaxQueryComplexityInstrumentation.this.calculateComplexity(env, childsComplexity);
                    valuesByParent.compute(env.getParentEnvironment(), (key, oldValue) -> Optional.ofNullable(oldValue).orElse(0) + value);
                }
            });
            int totalComplexity = valuesByParent.getOrDefault(null, 0);
            if (log.isDebugEnabled()) {
                log.debug("Query complexity: {}", (Object)totalComplexity);
            }
            if (totalComplexity > this.maxComplexity && (throwAbortException = this.maxQueryComplexityExceededFunction.apply(queryComplexityInfo = QueryComplexityInfo.newQueryComplexityInfo().complexity(totalComplexity).build()).booleanValue())) {
                throw this.mkAbortException(totalComplexity, this.maxComplexity);
            }
        });
    }

    protected AbortExecutionException mkAbortException(int totalComplexity, int maxComplexity) {
        return new AbortExecutionException("maximum query complexity exceeded " + totalComplexity + " > " + maxComplexity);
    }

    QueryTraverser newQueryTraverser(InstrumentationValidationParameters parameters) {
        return QueryTraverser.newQueryTraverser().schema(parameters.getSchema()).document(parameters.getDocument()).operationName(parameters.getOperation()).variables(parameters.getVariables()).build();
    }

    private int calculateComplexity(QueryVisitorFieldEnvironment queryVisitorFieldEnvironment, int childsComplexity) {
        if (queryVisitorFieldEnvironment.isTypeNameIntrospectionField()) {
            return 0;
        }
        FieldComplexityEnvironment fieldComplexityEnvironment = this.convertEnv(queryVisitorFieldEnvironment);
        return this.fieldComplexityCalculator.calculate(fieldComplexityEnvironment, childsComplexity);
    }

    private FieldComplexityEnvironment convertEnv(QueryVisitorFieldEnvironment queryVisitorFieldEnvironment) {
        FieldComplexityEnvironment parentEnv = null;
        if (queryVisitorFieldEnvironment.getParentEnvironment() != null) {
            parentEnv = this.convertEnv(queryVisitorFieldEnvironment.getParentEnvironment());
        }
        return new FieldComplexityEnvironment(queryVisitorFieldEnvironment.getField(), queryVisitorFieldEnvironment.getFieldDefinition(), queryVisitorFieldEnvironment.getFieldsContainer(), queryVisitorFieldEnvironment.getArguments(), parentEnv);
    }
}

