/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import java.util.function.Predicate;
import javax.tools.Diagnostic;
import manifold.api.util.PerfLogUtil;
import manifold.util.JreUtil;
import manifold.util.concurrent.LocklessLazyVar;

public interface IDynamicJdk {
    public <T> void report(Log var1, Diagnostic<? extends T> var2);

    default public Iterable<Symbol> getMembers(Symbol.ClassSymbol classSym) {
        return this.getMembers(classSym, true);
    }

    public Iterable<Symbol> getMembers(Symbol.ClassSymbol var1, boolean var2);

    default public Iterable<Symbol> getMembers(Symbol.ClassSymbol classSym, Predicate<Symbol> predicate) {
        return this.getMembers(classSym, predicate, true);
    }

    public Iterable<Symbol> getMembers(Symbol.ClassSymbol var1, Predicate<Symbol> var2, boolean var3);

    default public Iterable<Symbol> getMembersByName(Symbol.ClassSymbol classSym, Name name) {
        return this.getMembersByName(classSym, name, true);
    }

    public Iterable<Symbol> getMembersByName(Symbol.ClassSymbol var1, Name var2, boolean var3);

    public Symbol.ClassSymbol getTypeElement(Context var1, Object var2, String var3);

    public Symbol.ClassSymbol getLoadedClass(Context var1, String var2);

    public void setOperatorSymbol(Context var1, JCTree.JCBinary var2, JCTree.Tag var3, String var4, Symbol var5);

    public List<Type> getTargets(JCTree.JCLambda var1);

    public void setTargets(JCTree.JCLambda var1, List<Type> var2);

    public Symbol getOperator(JCTree.JCExpression var1);

    public void setOperator(JCTree.JCExpression var1, Symbol.OperatorSymbol var2);

    public void logError(Log var1, JCDiagnostic.DiagnosticPosition var2, String var3, Object ... var4);

    public static IDynamicJdk instance() {
        return (IDynamicJdk)Instance.INSTANCE.get();
    }

    public static boolean isInitializing() {
        return Instance.INITIALIZING;
    }

    public static class Instance {
        private static boolean INITIALIZING = false;
        private static LocklessLazyVar<IDynamicJdk> INSTANCE = LocklessLazyVar.make(() -> {
            INITIALIZING = true;
            try {
                IDynamicJdk iDynamicJdk;
                long before = System.nanoTime();
                try {
                    String fqnIssueReporter;
                    if (JreUtil.isJava8()) {
                        fqnIssueReporter = "manifold.internal.javac.JavaDynamicJdk_8";
                    } else if (JreUtil.isJava11()) {
                        fqnIssueReporter = "manifold.internal.javac.JavaDynamicJdk_11";
                    } else if (JreUtil.isJava17orLater()) {
                        fqnIssueReporter = "manifold.internal.javac.JavaDynamicJdk_17";
                    } else {
                        throw new RuntimeException("Unsupported JDK version " + JreUtil.JAVA_VERSION + ". Only LTS versions starting with Java 8 and the latest release are supported.");
                    }
                    iDynamicJdk = (IDynamicJdk)Class.forName(fqnIssueReporter).newInstance();
                }
                catch (Throwable throwable) {
                    try {
                        PerfLogUtil.log("Dynamic JDK Time", before);
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                PerfLogUtil.log("Dynamic JDK Time", before);
                return iDynamicJdk;
            }
            finally {
                INITIALIZING = false;
            }
        });
    }
}

