/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.util.fingerprint;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class Fingerprint {
    private long _fp;
    private static final String LEADING_ZEROS = "0000000000000000";
    private static final long Zero = 0L;
    private static final long One = Long.MIN_VALUE;
    private static final long IrredPoly = -7992595565342442794L;
    private static final long X63 = 1L;
    private static long[] ByteModTable;

    public Fingerprint() {
        this._fp = -7992595565342442794L;
    }

    public Fingerprint(Fingerprint fp) {
        this._fp = fp._fp;
    }

    public Fingerprint(String s) {
        this();
        this.extend(s);
    }

    public Fingerprint(char[] chars) {
        this();
        this.extend(chars, 0, chars.length);
    }

    public Fingerprint(char[] chars, int start, int length) {
        this();
        this.extend(chars, start, length);
    }

    public Fingerprint(byte[] bytes) {
        this();
        this.extend(bytes, 0, bytes.length);
    }

    public Fingerprint(byte[] bytes, int start, int length) {
        this();
        this.extend(bytes, start, length);
    }

    public Fingerprint(InputStream stream) throws IOException {
        this();
        this.extend(stream);
    }

    public Fingerprint(ByteBuffer buffer) throws IOException {
        this();
        this.extend(buffer);
    }

    public byte[] toBytes() {
        return this.toBytes(new byte[8]);
    }

    public byte[] toBytes(byte[] buff) {
        assert (buff != null);
        assert (buff.length == 8) : "buff argument not an array of length 8";
        long val2 = this._fp;
        for (int i = 0; i < buff.length; ++i) {
            buff[i] = (byte)(val2 & 0xFFL);
            val2 >>>= 8;
        }
        return buff;
    }

    public String toHexString() {
        String res = Long.toHexString(this._fp);
        int len = res.length();
        if (len < 16) {
            res = LEADING_ZEROS.substring(len) + res;
            assert (res.length() == 16);
        }
        return res;
    }

    public Fingerprint extend(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.extend(s.charAt(i));
        }
        return this;
    }

    public Fingerprint extend(char[] chars) {
        this.extend(chars, 0, chars.length);
        return this;
    }

    public Fingerprint extend(char[] chars, int start, int len) {
        int end = start + len;
        for (int i = start; i < end; ++i) {
            this.extend(chars[i]);
        }
        return this;
    }

    public Fingerprint extend(byte[] bytes, int start, int len) {
        int end = start + len;
        for (int i = start; i < end; ++i) {
            this.extend(bytes[i]);
        }
        return this;
    }

    public Fingerprint extend(byte[] bytes) {
        for (byte aByte : bytes) {
            this.extend(aByte);
        }
        return this;
    }

    public Fingerprint extend(int i) {
        this.extend((byte)(i >>> 24 & 0xFF));
        this.extend((byte)(i >>> 16 & 0xFF));
        this.extend((byte)(i >>> 8 & 0xFF));
        this.extend((byte)(i & 0xFF));
        return this;
    }

    public Fingerprint extend(long i) {
        this.extend((byte)(i >>> 52 & 0xFFL));
        this.extend((byte)(i >>> 48 & 0xFFL));
        this.extend((byte)(i >>> 40 & 0xFFL));
        this.extend((byte)(i >>> 32 & 0xFFL));
        this.extend((byte)(i >>> 24 & 0xFFL));
        this.extend((byte)(i >>> 16 & 0xFFL));
        this.extend((byte)(i >>> 8 & 0xFFL));
        this.extend((byte)(i & 0xFFL));
        return this;
    }

    public Fingerprint extend(char c) {
        byte b1 = (byte)(c & 0xFF);
        this.extend(b1);
        byte b2 = (byte)(c >>> 8);
        if (b2 != 0) {
            this.extend(b2);
        }
        return this;
    }

    public Fingerprint extend(byte b) {
        this._fp = this._fp >>> 8 ^ ByteModTable[(b ^ (int)this._fp) & 0xFF];
        return this;
    }

    public Fingerprint extend(InputStream stream) throws IOException {
        int b;
        while ((b = stream.read()) != -1) {
            this.extend((byte)b);
        }
        return this;
    }

    public Fingerprint extend(ByteBuffer buffer) throws IOException {
        if (buffer.hasArray()) {
            byte[] bytes = buffer.array();
            return this.extend(bytes, 0, bytes.length);
        }
        while (buffer.hasRemaining()) {
            this.extend(buffer.get());
        }
        return this;
    }

    public int hashCode() {
        return (int)this._fp ^ (int)(this._fp >>> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Fingerprint)) {
            return false;
        }
        return this._fp == ((Fingerprint)obj)._fp;
    }

    public long getRawFingerprint() {
        return this._fp;
    }

    public String toString() {
        return "" + this._fp;
    }

    static {
        int plength = 72;
        long[] powerTable = new long[plength];
        long t = Long.MIN_VALUE;
        for (int i = 0; i < plength; ++i) {
            powerTable[i] = t;
            long mask = (t & 1L) != 0L ? -7992595565342442794L : 0L;
            t = t >>> 1 ^ mask;
        }
        ByteModTable = new long[256];
        for (int j = 0; j < ByteModTable.length; ++j) {
            long v = 0L;
            for (int k = 0; k < 9; ++k) {
                if (((long)j & 1L << k) == 0L) continue;
                v ^= powerTable[plength - 1 - k];
            }
            Fingerprint.ByteModTable[j] = v;
        }
    }
}

