/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.gen;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileFragment;
import manifold.api.gen.AbstractSrcClass;
import manifold.api.gen.SrcAnnotated;
import manifold.api.gen.SrcAnnotationExpression;
import manifold.api.gen.SrcArgument;
import manifold.api.gen.SrcField;
import manifold.api.gen.SrcMemberAccessExpression;
import manifold.api.gen.SrcRawExpression;
import manifold.api.host.IModule;
import manifold.rt.api.ActualName;
import manifold.rt.api.SourcePosition;
import manifold.rt.api.util.ManIdentifierUtil;
import manifold.rt.api.util.ManStringUtil;
import manifold.rt.api.util.StreamUtil;
import manifold.util.ManExceptionUtil;

public class SrcLinkedClass
extends AbstractSrcClass<SrcLinkedClass> {
    protected static final String FIELD_FILE_URL = "__FILE_URL";
    private IFile _linkedFile;
    private Map<IFile, int[]> _resFileToContent;
    private String _fileContent;

    public SrcLinkedClass(String fqn, AbstractSrcClass.Kind kind, IFile linkedFile) {
        this(fqn, kind, linkedFile, null, null, null);
    }

    public SrcLinkedClass(String fqn, AbstractSrcClass enclosingClass, AbstractSrcClass.Kind kind) {
        this(fqn, enclosingClass, kind, null, null, null, null);
    }

    public SrcLinkedClass(String fqn, AbstractSrcClass.Kind kind, IFile linkedFile, JavaFileManager.Location location, IModule module, DiagnosticListener<JavaFileObject> errorHandler) {
        this(fqn, null, kind, linkedFile, location, module, errorHandler);
    }

    public SrcLinkedClass(String fqn, AbstractSrcClass enclosingClass, AbstractSrcClass.Kind kind, IFile linkedFile, JavaFileManager.Location location, IModule module, DiagnosticListener<JavaFileObject> errorHandler) {
        super(fqn, enclosingClass, kind, location, module, errorHandler);
        if (enclosingClass == null) {
            this._linkedFile = linkedFile;
            this.addFileField();
        }
    }

    protected void addFileField() {
        IFile linkedFile = this.getLinkedFile();
        if (linkedFile == null) {
            throw new IllegalStateException("Expecting non-null linkedFile");
        }
        this.addField(((SrcField)new SrcField(FIELD_FILE_URL, String.class).modifiers(this.isInterface() ? 0L : 24L)).initializer(new SrcRawExpression("\"" + linkedFile.toURI().toString() + "\"")));
    }

    public void addSourcePositionAnnotation(SrcAnnotated srcAnno, String name, int line, int column) {
        SrcAnnotationExpression annotation = new SrcAnnotationExpression(SourcePosition.class.getSimpleName()).addArgument((SrcArgument)new SrcArgument(new SrcMemberAccessExpression(FIELD_FILE_URL)).name("url")).addArgument("feature", String.class, (Object)name).addArgument("offset", Integer.TYPE, (Object)this.findOffset(this.getLinkedFile(), line, column)).addArgument("length", Integer.TYPE, (Object)name.length());
        srcAnno.addAnnotation(annotation);
    }

    private Map<IFile, int[]> getResFileToContent() {
        Map<IFile, int[]> resFileToContent;
        if (this._resFileToContent != null) {
            return this._resFileToContent;
        }
        AbstractSrcClass<?> enclosingClass = this.getEnclosingClass();
        if (enclosingClass instanceof SrcLinkedClass && (resFileToContent = ((SrcLinkedClass)enclosingClass).getResFileToContent()) != null) {
            return resFileToContent;
        }
        this._resFileToContent = new HashMap<IFile, int[]>();
        return this._resFileToContent;
    }

    private IFile getLinkedFile() {
        if (this._linkedFile == null) {
            AbstractSrcClass<?> enclosingClass = this.getEnclosingClass();
            if (enclosingClass instanceof SrcLinkedClass) {
                return ((SrcLinkedClass)enclosingClass).getLinkedFile();
            }
            throw new IllegalStateException("Expecting non-null _linkedFile");
        }
        return this._linkedFile;
    }

    public static void addActualNameAnnotation(SrcAnnotated srcAnno, String name, boolean capitalize) {
        String identifier = SrcLinkedClass.makeIdentifier(name, capitalize);
        if (!identifier.equals(name) || !Character.isAlphabetic(name.charAt(0))) {
            srcAnno.addAnnotation(new SrcAnnotationExpression(ActualName.class.getSimpleName()).addArgument(new SrcArgument(new SrcRawExpression('\"' + name + '\"'))));
        }
    }

    public static String makeIdentifier(String name, boolean capitalize) {
        String identifier = capitalize ? ManStringUtil.capitalize(ManIdentifierUtil.makeIdentifier(name)) : ManIdentifierUtil.makeIdentifier(name);
        return SrcLinkedClass.handleSpecialCases(identifier);
    }

    private static String handleSpecialCases(String identifier) {
        if (identifier.equals(Class.class.getSimpleName())) {
            return "Clazz";
        }
        return identifier;
    }

    public void processContent(int line, int column, BiConsumer<String, Integer> contentHandler) {
        IFile file = this.getLinkedFile();
        int offset = this.findOffset(file, line, column);
        try {
            contentHandler.accept(this.getFileContent(), offset);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private int findOffset(IFile file, int line, int column) {
        int offset;
        int[] lineOffsets = this.getResFileToContent().computeIfAbsent(file, f -> {
            try {
                String content = this.getFileContent();
                ArrayList<Integer> lineOffsetList = new ArrayList<Integer>();
                lineOffsetList.add(0);
                int index = content.indexOf(10) + 1;
                while (index > 0) {
                    lineOffsetList.add(index);
                    index = content.indexOf(10, index) + 1;
                }
                int[] array = new int[lineOffsetList.size()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = (Integer)lineOffsetList.get(i);
                }
                return array;
            }
            catch (IOException ioe) {
                throw ManExceptionUtil.unchecked(ioe);
            }
        });
        try {
            offset = lineOffsets[line - 1] + column - 1;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            System.err.print("WARNING: ");
            ex.printStackTrace();
            offset = 0;
        }
        if (file instanceof IFileFragment) {
            offset += ((IFileFragment)file).getOffset();
        }
        return offset;
    }

    private String getFileContent() throws IOException {
        if (this._fileContent != null) {
            return this._fileContent;
        }
        AbstractSrcClass<?> enclosingClass = this.getEnclosingClass();
        if (enclosingClass instanceof SrcLinkedClass) {
            return ((SrcLinkedClass)enclosingClass).getFileContent();
        }
        if (enclosingClass == null) {
            return this._fileContent == null ? (this._fileContent = StreamUtil.getContent(new InputStreamReader(this.getLinkedFile().openInputStream(), StandardCharsets.UTF_8))) : this._fileContent;
        }
        throw new IllegalStateException();
    }
}

