/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.language.Definition;
import graphql.language.Document;
import graphql.language.FragmentDefinition;
import graphql.language.OperationDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.TypeDefinition;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;

public class ExecutableDefinitions
extends AbstractRule {
    public ExecutableDefinitions(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkDocument(Document document) {
        document.getDefinitions().forEach(definition -> {
            if (!(definition instanceof OperationDefinition) && !(definition instanceof FragmentDefinition)) {
                String message = this.nonExecutableDefinitionMessage((Definition)definition);
                this.addError(ValidationErrorType.NonExecutableDefinition, definition.getSourceLocation(), message);
            }
        });
    }

    private String nonExecutableDefinitionMessage(Definition definition) {
        String definitionName = definition instanceof TypeDefinition ? ((TypeDefinition)definition).getName() : (definition instanceof SchemaDefinition ? "schema" : "provided");
        return ExecutableDefinitions.nonExecutableDefinitionMessage(definitionName);
    }

    static String nonExecutableDefinitionMessage(String definitionName) {
        return String.format("The %s definition is not executable.", definitionName);
    }
}

