/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.PublicApi;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLModifiedType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLTypeVisitor;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.Collections;
import java.util.List;

@PublicApi
public class GraphQLNonNull
implements GraphQLType,
GraphQLInputType,
GraphQLOutputType,
GraphQLModifiedType {
    private GraphQLType wrappedType;

    public static GraphQLNonNull nonNull(GraphQLType wrappedType) {
        return new GraphQLNonNull(wrappedType);
    }

    public GraphQLNonNull(GraphQLType wrappedType) {
        Assert.assertNotNull(wrappedType, "wrappedType can't be null", new Object[0]);
        this.assertNonNullWrapping(wrappedType);
        this.wrappedType = wrappedType;
    }

    private void assertNonNullWrapping(GraphQLType wrappedType) {
        Assert.assertTrue(!GraphQLTypeUtil.isNonNull(wrappedType), String.format("A non null type cannot wrap an existing non null type '%s'", GraphQLTypeUtil.simplePrint(wrappedType)), new Object[0]);
    }

    @Override
    public GraphQLType getWrappedType() {
        return this.wrappedType;
    }

    void replaceType(GraphQLType type) {
        this.assertNonNullWrapping(type);
        this.wrappedType = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphQLNonNull that = (GraphQLNonNull)o;
        return !(this.wrappedType == null ? that.wrappedType != null : !this.wrappedType.equals(that.wrappedType));
    }

    public int hashCode() {
        return this.wrappedType != null ? this.wrappedType.hashCode() : 0;
    }

    public String toString() {
        return GraphQLTypeUtil.simplePrint(this);
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public TraversalControl accept(TraverserContext<GraphQLType> context, GraphQLTypeVisitor visitor) {
        return visitor.visitGraphQLNonNull(this, context);
    }

    @Override
    public List<GraphQLType> getChildren() {
        return Collections.singletonList(this.wrappedType);
    }
}

