/*
 * Decompiled with CFR 0.152.
 */
package manifold.shade.org.snakeyaml.engine.v1.events;

import java.util.Optional;
import manifold.shade.org.snakeyaml.engine.v1.exceptions.Mark;

public abstract class Event {
    private final Optional<Mark> startMark;
    private final Optional<Mark> endMark;

    public Event(Optional<Mark> startMark, Optional<Mark> endMark) {
        if (startMark.isPresent() && !endMark.isPresent() || !startMark.isPresent() && endMark.isPresent()) {
            throw new NullPointerException("Both marks must be either present or absent.");
        }
        this.startMark = startMark;
        this.endMark = endMark;
    }

    public Event() {
        this(Optional.empty(), Optional.empty());
    }

    public Optional<Mark> getStartMark() {
        return this.startMark;
    }

    public Optional<Mark> getEndMark() {
        return this.endMark;
    }

    public final boolean isEvent(ID id) {
        return this.getEventId() == id;
    }

    public abstract ID getEventId();

    public boolean equals(Object obj) {
        if (obj instanceof Event) {
            return this.toString().equals(obj.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static enum ID {
        Alias,
        DocumentEnd,
        DocumentStart,
        MappingEnd,
        MappingStart,
        Scalar,
        SequenceEnd,
        SequenceStart,
        StreamEnd,
        StreamStart;

    }
}

