/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import java.util.Objects;
import java.util.function.Function;
import manifold.science.api.Unit;
import manifold.science.api.UnitCache;
import manifold.science.measures.EnergyUnit;
import manifold.science.measures.HeatCapacityUnit;
import manifold.science.measures.Temperature;
import manifold.science.util.CoercionConstants;
import manifold.science.util.Rational;

public final class TemperatureUnit
implements Unit<Temperature, TemperatureUnit> {
    private static final UnitCache<TemperatureUnit> CACHE = new UnitCache();
    public static final TemperatureUnit Kelvin = TemperatureUnit.get(degK -> degK, degK -> degK, "Kelvin", "K");
    public static final TemperatureUnit Celsius = TemperatureUnit.get(degC -> degC.plus(CoercionConstants.r.postfixBind("273.15")), degK -> degK.minus(CoercionConstants.r.postfixBind("273.15")), "Celsius", "\u00b0C");
    public static final TemperatureUnit Fahrenheit = TemperatureUnit.get(degF -> degF.plus(CoercionConstants.r.postfixBind("459.67")).times(CoercionConstants.r.postfixBind("5/9")), degK -> degK.times(CoercionConstants.r.postfixBind("9/5")).minus(CoercionConstants.r.postfixBind("459.67")), "Fahrenheit", "\u00b0F");
    public static final TemperatureUnit Rankine = TemperatureUnit.get(degR -> degR.times(CoercionConstants.r.postfixBind("5/9")), degK -> degK.times(CoercionConstants.r.postfixBind("9/5")), "Rankine", "\u00b0R");
    public static final TemperatureUnit Delisle = TemperatureUnit.get(De -> CoercionConstants.r.postfixBind("373.15").minus(De.times(CoercionConstants.r.postfixBind("2/3"))), degK -> CoercionConstants.r.postfixBind("373.15").minus((Rational)degK).times(CoercionConstants.r.postfixBind("3/2")), "Delisle", "\u00b0De");
    public static final TemperatureUnit Newton = TemperatureUnit.get(degN -> degN.times(CoercionConstants.r.postfixBind("100/33")).plus(CoercionConstants.r.postfixBind("273.15")), degK -> degK.minus(CoercionConstants.r.postfixBind("273.15")).times(CoercionConstants.r.postfixBind("33/100")), "Newton", "\u00b0N");
    private final Function<Rational, Rational> _toK;
    private final Function<Rational, Rational> _fromK;
    private final String _name;
    private final String _symbol;
    public static final TemperatureUnit BASE = Kelvin;

    public static TemperatureUnit get(Function<Rational, Rational> toK, Function<Rational, Rational> fromK, String name, String symbol) {
        return (TemperatureUnit)CACHE.get(new TemperatureUnit(toK, fromK, name, symbol));
    }

    public TemperatureUnit(Function<Rational, Rational> toK, Function<Rational, Rational> fromK, String name, String symbol) {
        this._toK = toK;
        this._fromK = fromK;
        this._name = name;
        this._symbol = symbol;
    }

    @Override
    public Temperature makeDimension(Number amount) {
        return new Temperature(Rational.get(amount), this);
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getSymbol() {
        return this._symbol;
    }

    @Override
    public Rational toBaseUnits(Rational myUnits) {
        return this._toK.apply(myUnits);
    }

    @Override
    public Rational toNumber() {
        return this._toK.apply(Rational.ONE);
    }

    @Override
    public Rational from(Temperature t) {
        return this._fromK.apply(t.toBaseNumber());
    }

    public EnergyUnit times(HeatCapacityUnit c) {
        return c.getEnergyUnit();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TemperatureUnit)) {
            return false;
        }
        TemperatureUnit that = (TemperatureUnit)o;
        return this._name.equalsIgnoreCase(that._name) && this._symbol.equalsIgnoreCase(that._symbol);
    }

    public int hashCode() {
        return Objects.hash(this._name, this._symbol);
    }
}

