/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractMeasure;
import manifold.science.measures.Current;
import manifold.science.measures.CurrentUnit;
import manifold.science.measures.Energy;
import manifold.science.measures.EnergyUnit;
import manifold.science.measures.Force;
import manifold.science.measures.ForceUnit;
import manifold.science.measures.Potential;
import manifold.science.measures.PotentialUnit;
import manifold.science.measures.PowerUnit;
import manifold.science.measures.Time;
import manifold.science.measures.Velocity;
import manifold.science.measures.VelocityUnit;
import manifold.science.util.Rational;

public final class Power
extends AbstractMeasure<PowerUnit, Power> {
    public Power(Rational value, PowerUnit unit, PowerUnit displayUnit) {
        super(value, unit, displayUnit);
    }

    public Power(Rational value, PowerUnit unit) {
        this(value, unit, unit);
    }

    @Override
    public PowerUnit getBaseUnit() {
        return PowerUnit.BASE;
    }

    @Override
    public Power make(Rational value, PowerUnit unit, PowerUnit displayUnit) {
        return new Power(value, unit, displayUnit);
    }

    @Override
    public Power make(Rational value, PowerUnit unit) {
        return new Power(value, unit);
    }

    public Energy times(Time time) {
        return new Energy(this.toBaseNumber().times(time.toBaseNumber()), EnergyUnit.BASE, ((PowerUnit)this.getDisplayUnit()).getEnergyUnit());
    }

    public Force div(Velocity v) {
        return new Force(this.toBaseNumber().div(v.toBaseNumber()), ForceUnit.BASE, ((PowerUnit)this.getDisplayUnit()).getEnergyUnit().getForceUnit());
    }

    public Velocity div(Force force) {
        return new Velocity(this.toBaseNumber().div(force.toBaseNumber()), VelocityUnit.BASE, ((PowerUnit)this.getDisplayUnit()).getEnergyUnit().getForceUnit().getAccUnit().getVelocityUnit());
    }

    public Current div(Potential potential) {
        return new Current(this.toBaseNumber().div(potential.toBaseNumber()), CurrentUnit.BASE, ((PotentialUnit)potential.getDisplayUnit()).getCurrentUnit());
    }

    public Potential div(Current current) {
        return new Potential(this.toBaseNumber().div(current.toBaseNumber()), PotentialUnit.BASE, PotentialUnit.get((PowerUnit)this.getDisplayUnit(), (CurrentUnit)current.getDisplayUnit()));
    }
}

