/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractMeasure;
import manifold.science.measures.Current;
import manifold.science.measures.CurrentUnit;
import manifold.science.measures.EnergyUnit;
import manifold.science.measures.Force;
import manifold.science.measures.ForceUnit;
import manifold.science.measures.HeatCapacity;
import manifold.science.measures.HeatCapacityUnit;
import manifold.science.measures.Length;
import manifold.science.measures.LengthUnit;
import manifold.science.measures.MagneticFlux;
import manifold.science.measures.MagneticFluxUnit;
import manifold.science.measures.Power;
import manifold.science.measures.PowerUnit;
import manifold.science.measures.Temperature;
import manifold.science.measures.TemperatureUnit;
import manifold.science.measures.Time;
import manifold.science.measures.TimeUnit;
import manifold.science.util.Rational;

public final class Energy
extends AbstractMeasure<EnergyUnit, Energy> {
    public Energy(Rational value, EnergyUnit unit, EnergyUnit displayUnit) {
        super(value, unit, displayUnit);
    }

    public Energy(Rational value, EnergyUnit unit) {
        this(value, unit, unit);
    }

    @Override
    public EnergyUnit getBaseUnit() {
        return EnergyUnit.BASE;
    }

    @Override
    public Energy make(Rational value, EnergyUnit unit, EnergyUnit displayUnit) {
        return new Energy(value, unit, displayUnit);
    }

    @Override
    public Energy make(Rational value, EnergyUnit unit) {
        return new Energy(value, unit);
    }

    public Length div(Force f) {
        return new Length(this.toBaseNumber().div(f.toBaseNumber()), LengthUnit.Meter, ((EnergyUnit)this.getDisplayUnit()).getLengthUnit());
    }

    public Force div(Length len) {
        return new Force(this.toBaseNumber().div(len.toBaseNumber()), ForceUnit.BASE, ((EnergyUnit)this.getDisplayUnit()).getForceUnit());
    }

    public Power div(Time t) {
        return new Power(this.toBaseNumber().div(t.toBaseNumber()), PowerUnit.BASE, PowerUnit.get((EnergyUnit)this.getDisplayUnit(), (TimeUnit)t.getDisplayUnit()));
    }

    public Time div(Power power) {
        return new Time(this.toBaseNumber().div(power.toBaseNumber()), TimeUnit.BASE, ((PowerUnit)power.getDisplayUnit()).getTimeUnit());
    }

    public HeatCapacity div(Temperature temperature) {
        return new HeatCapacity(this.toBaseNumber().div(temperature.toBaseNumber()), HeatCapacityUnit.BASE, ((EnergyUnit)this.getDisplayUnit()).div((TemperatureUnit)temperature.getDisplayUnit()));
    }

    public Temperature div(HeatCapacity c) {
        return new Temperature(this.toBaseNumber().div(c.toBaseNumber()), TemperatureUnit.BASE, ((HeatCapacityUnit)c.getDisplayUnit()).getTemperatureUnit());
    }

    public MagneticFlux div(Current i) {
        return new MagneticFlux(this.toBaseNumber().div(i.toBaseNumber()), MagneticFluxUnit.BASE, MagneticFluxUnit.get((EnergyUnit)this.getDisplayUnit(), (CurrentUnit)i.getDisplayUnit()));
    }

    public Current div(MagneticFlux mf) {
        return new Current(this.toBaseNumber().div(mf.toBaseNumber()), CurrentUnit.BASE, ((MagneticFluxUnit)mf.getDisplayUnit()).getCurrentUnit());
    }
}

