/*
 * Decompiled with CFR 0.152.
 */
package manifold.json.rt.parser;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import manifold.json.rt.parser.TokenType;

public final class Token {
    static final Map<String, TokenType> Constants = Token.initializeConstants();
    private final TokenType _type;
    private final String _string;
    private final int _offset;
    private final int _line;
    private final int _column;

    public Token(TokenType type, String string, int offset, int line, int column) {
        this._type = type;
        this._string = string;
        this._offset = offset;
        this._line = line;
        this._column = column;
    }

    private static Map<String, TokenType> initializeConstants() {
        HashMap<String, TokenType> map = new HashMap<String, TokenType>();
        map.put("true", TokenType.TRUE);
        map.put("false", TokenType.FALSE);
        map.put("null", TokenType.NULL);
        return Collections.unmodifiableMap(map);
    }

    public String getString() {
        return this._string;
    }

    public TokenType getType() {
        return this._type;
    }

    public int getOffset() {
        return this._offset;
    }

    public int getLineNumber() {
        return this._line;
    }

    public int getColumn() {
        return this._column;
    }

    public String toString() {
        return this._string + " : " + (Object)((Object)this._type);
    }

    boolean isValueType() {
        return this._type == TokenType.LCURLY || this._type == TokenType.LSQUARE || this._type == TokenType.INTEGER || this._type == TokenType.DOUBLE || this._type == TokenType.STRING || this._type == TokenType.TRUE || this._type == TokenType.FALSE || this._type == TokenType.NULL;
    }
}

