/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.CompileStates;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Todo;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileSystem;
import manifold.api.host.IModule;
import manifold.api.type.ContributorKind;
import manifold.api.type.ITypeManifold;
import manifold.internal.host.JavacManifoldHost;
import manifold.internal.javac.ClassSymbols;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.javac.JavacPlugin;
import manifold.internal.javac.ManifoldJavaFileManager;
import manifold.util.JreUtil;
import manifold.util.ReflectUtil;

public class StaticCompiler {
    private static final StaticCompiler INSTANCE = new StaticCompiler();
    private boolean _enterGuard;
    private Map<String, Boolean> _ifaceToProxies = new ConcurrentHashMap<String, Boolean>();

    private StaticCompiler() {
    }

    public static StaticCompiler instance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compileRemainingTypes_ByFile() {
        if (this._enterGuard) {
            return;
        }
        this._enterGuard = true;
        try {
            this.createIProxyFactoryServicesForExtensions();
            List<String> others = JavacPlugin.instance().getOtherInputFiles();
            if (others.isEmpty()) {
                return;
            }
            JavacManifoldHost host = JavacPlugin.instance().getHost();
            IFileSystem fs = host.getFileSystem();
            Context ctx = JavacPlugin.instance().getContext();
            for (String path : others) {
                ITypeManifold tm2;
                String[] types;
                IFile file = fs.getIFile(new File(path));
                if (!file.exists()) continue;
                IModule module = host.getSingleModule();
                Set<ITypeManifold> tms = module.findTypeManifoldsFor(file, tm -> tm.getContributorKind() != ContributorKind.Supplemental);
                if (tms.isEmpty() || (types = (tm2 = tms.iterator().next()).getTypesForFile(file)) == null || types.length == 0) continue;
                tm2.enterPostJavaCompilation();
                if (this.enterClassSymbols(module, ctx, Arrays.asList(types))) continue;
                return;
            }
            JavaCompiler javaCompiler = JavaCompiler.instance(JavacPlugin.instance().getContext());
            if (!javaCompiler.todo.isEmpty()) {
                this.compileTodo(javaCompiler);
            }
        }
        finally {
            this._enterGuard = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compileRemainingTypes_ByTypeNameRegexes() {
        if (this._enterGuard) {
            return;
        }
        this._enterGuard = true;
        try {
            Map<String, String> others = JavacPlugin.instance().getOtherSourceMappings();
            if (others.isEmpty()) {
                return;
            }
            HashMap<ITypeManifold, Set<String>> classToRegex = new HashMap<ITypeManifold, Set<String>>();
            for (Map.Entry<String, String> entry : others.entrySet()) {
                this.mapTypeManifoldToTypeNameRegexes(classToRegex, entry.getKey(), entry.getValue());
            }
            IModule module = JavacPlugin.instance().getHost().getSingleModule();
            Context ctx = JavacPlugin.instance().getContext();
            for (Map.Entry mapping : classToRegex.entrySet()) {
                ITypeManifold tm = (ITypeManifold)mapping.getKey();
                Collection<String> types = this.computeNamesToPrecompile(tm.getAllTypeNames(), (Set)mapping.getValue());
                if (types.isEmpty()) continue;
                tm.enterPostJavaCompilation();
                if (this.enterClassSymbols(module, ctx, types)) continue;
                return;
            }
            JavaCompiler javaCompiler = JavaCompiler.instance(ctx);
            if (!javaCompiler.todo.isEmpty()) {
                this.compileTodo(javaCompiler);
            }
        }
        finally {
            this._enterGuard = false;
        }
    }

    private void createIProxyFactoryServicesForExtensions() {
        if (this._ifaceToProxies.isEmpty()) {
            return;
        }
        String filename = "META-INF/services/manifold.ext.rt.api.IProxyFactory_gen";
        try {
            JavacProcessingEnvironment processingEnv = JavacProcessingEnvironment.instance(JavacPlugin.instance().getContext());
            FileObject file = processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", filename, new Element[0]);
            PrintWriter writer = new PrintWriter(new OutputStreamWriter(file.openOutputStream(), StandardCharsets.UTF_8));
            for (String proxyFactory : this._ifaceToProxies.keySet()) {
                writer.println(proxyFactory);
            }
            writer.close();
            this._ifaceToProxies.clear();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void addIProxyFactory(String iface, String fqn) {
        this._ifaceToProxies.put(fqn, false);
    }

    public void surfaceGeneratedProxyFactoryClasses(Context context, CompilationUnitTree compilationUnit) {
        for (Map.Entry<String, Boolean> proxy : new HashMap<String, Boolean>(this._ifaceToProxies).entrySet()) {
            Symbol.ClassSymbol sym;
            if (proxy.getValue().booleanValue()) continue;
            Tree tree = compilationUnit.getTypeDecls().get(0);
            String proxyName = proxy.getKey();
            if (!proxyName.contains(((JCTree.JCClassDecl)tree).getSimpleName().toString()) || (sym = IDynamicJdk.instance().getTypeElement(context, compilationUnit, proxyName)) == null) continue;
            this._ifaceToProxies.put(proxyName, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean enterClassSymbols(IModule module, Context ctx, Collection<String> types) {
        Object moduleSym = null;
        if (JreUtil.isJava9orLater() && (moduleSym = this.pushModuleSymbol(ctx)) == null) {
            return false;
        }
        Object top = null;
        try {
            for (String fqn : types) {
                ClassSymbols.instance(module).getClassSymbol(JavacPlugin.instance().getJavacTask(), fqn);
            }
        }
        finally {
            if (moduleSym != null) {
                top = ctx.get(ManifoldJavaFileManager.MODULE_CTX).pop();
            }
        }
        if (top != moduleSym) {
            throw new IllegalStateException("unbalanced stack");
        }
        return true;
    }

    private Object pushModuleSymbol(Context ctx) {
        Object modules = ReflectUtil.method("com.sun.tools.javac.comp.Modules", "instance", Context.class).invokeStatic(ctx);
        Set rootModules = (Set)ReflectUtil.method(modules, "getRootModules", new Class[0]).invoke(new Object[0]);
        Object moduleSym = null;
        if (rootModules.size() == 1) {
            moduleSym = rootModules.iterator().next();
        } else {
            if (rootModules.size() > 1) {
                // empty if block
            }
            moduleSym = ReflectUtil.field(Symtab.instance(ctx), "unnamedModule").get();
        }
        ctx.get(ManifoldJavaFileManager.MODULE_CTX).push(moduleSym);
        return moduleSym;
    }

    private void compileTodo(JavaCompiler javac) {
        String compilePolicy;
        Todo todo = javac.todo;
        switch (compilePolicy = ((Enum)ReflectUtil.field(javac, "compilePolicy").get()).name()) {
            case "ATTR_ONLY": {
                javac.attribute(todo);
                break;
            }
            case "CHECK_ONLY": {
                javac.flow(javac.attribute(todo));
                break;
            }
            case "SIMPLE": {
                javac.generate(javac.desugar(javac.flow(javac.attribute(todo))));
                break;
            }
            case "BY_FILE": {
                Queue<Queue<Env<AttrContext>>> q = todo.groupByFile();
                while (!q.isEmpty() && !((Boolean)ReflectUtil.method(javac, "shouldStop", CompileStates.CompileState.class).invoke(new Object[]{CompileStates.CompileState.ATTR})).booleanValue()) {
                    javac.generate(javac.desugar(javac.flow(javac.attribute(q.remove()))));
                }
                break;
            }
            case "BY_TODO": {
                while (!todo.isEmpty()) {
                    javac.generate(javac.desugar(javac.flow(javac.attribute((Env)todo.remove()))));
                }
                break;
            }
            default: {
                Assert.error((String)"unknown compile policy");
            }
        }
    }

    private Collection<String> computeNamesToPrecompile(Collection<String> allTypeNames, Set<String> regexes) {
        HashSet<String> matchingTypes = new HashSet<String>();
        for (String fqn : allTypeNames) {
            if (!regexes.stream().anyMatch(fqn::matches)) continue;
            matchingTypes.add(fqn);
        }
        return matchingTypes;
    }

    public void mapTypeManifoldToTypeNameRegexes(Map<ITypeManifold, Set<String>> typeNames, String fqnOrExt, String regex) {
        int iClass = fqnOrExt.indexOf("class:");
        Set<ITypeManifold> typeManifolds = JavacPlugin.instance().getHost().getSingleModule().getTypeManifolds();
        if (iClass > 0) {
            String typeManifoldClassName = fqnOrExt.substring("class:".length());
            ITypeManifold typeManifold = typeManifolds.stream().filter(tm -> tm.getClass().getTypeName().equals(typeManifoldClassName)).findFirst().orElseThrow(() -> new RuntimeException("Expecting type manifold class: " + typeManifoldClassName));
            Set regexes = typeNames.computeIfAbsent(typeManifold, tm -> new HashSet());
            regexes.add(regex);
        } else {
            String ext = fqnOrExt;
            boolean all = "*".equals(ext);
            typeManifolds.stream().filter(tm -> tm.getContributorKind() != ContributorKind.Supplemental).forEach(tm -> {
                if (all || tm.handlesFileExtension(ext)) {
                    Set regexes = typeNames.computeIfAbsent((ITypeManifold)tm, e -> new HashSet());
                    regexes.add(regex);
                }
            });
        }
    }
}

