/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Modules;
import com.sun.tools.javac.comp.Operators;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import java.util.function.Predicate;
import javax.tools.Diagnostic;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.javac.IssueReporter;
import manifold.internal.javac.JavacPlugin;
import manifold.internal.javac.ManifoldJavaFileManager;
import manifold.util.ReflectUtil;

public class JavaDynamicJdk_9
implements IDynamicJdk {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> void report(Log issueLogger, Diagnostic<? extends T> diagnostic) {
        JavaFileObject oldSource = issueLogger.useSource((JavaFileObject)diagnostic.getSource());
        try {
            switch (diagnostic.getKind()) {
                case ERROR: {
                    issueLogger.error(JCDiagnostic.DiagnosticFlag.MULTIPLE, new IssueReporter.Position(diagnostic), CompilerProperties.Errors.ProcMessager(diagnostic.getMessage(Locale.getDefault())));
                    return;
                }
                case WARNING: {
                    issueLogger.warning(new IssueReporter.Position(diagnostic), "proc.messager", new Object[]{diagnostic.getMessage(Locale.getDefault())});
                    return;
                }
                case MANDATORY_WARNING: {
                    issueLogger.mandatoryWarning(new IssueReporter.Position(diagnostic), "proc.messager", new Object[]{diagnostic.getMessage(Locale.getDefault())});
                    return;
                }
                case NOTE: 
                case OTHER: {
                    issueLogger.note(new IssueReporter.Position(diagnostic), "proc.messager", new Object[]{diagnostic.getMessage(Locale.getDefault())});
                    return;
                }
            }
            return;
        }
        finally {
            issueLogger.useSource(oldSource);
        }
    }

    @Override
    public Iterable<Symbol> getMembers(Symbol.ClassSymbol classSym, boolean completeFirst) {
        Scope.WriteableScope members = completeFirst ? classSym.members() : classSym.members_field;
        return members == null ? Collections.emptyList() : members.getSymbols();
    }

    @Override
    public Iterable<Symbol> getMembers(Symbol.ClassSymbol classSym, Predicate<Symbol> filter, boolean completeFirst) {
        Scope.WriteableScope members = completeFirst ? classSym.members() : classSym.members_field;
        return members == null ? Collections.emptyList() : members.getSymbols(t -> filter.test((Symbol)t));
    }

    @Override
    public Iterable<Symbol> getMembersByName(Symbol.ClassSymbol classSym, Name call, boolean completeFirst) {
        Scope.WriteableScope members = completeFirst ? classSym.members() : classSym.members_field;
        return members == null ? Collections.emptyList() : members.getSymbolsByName(call);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Symbol.ClassSymbol getTypeElement(Context ctx, Object moduleCtx, String fqn) {
        classSym = null;
        if (moduleCtx instanceof JCTree.JCCompilationUnit) {
            moduleSym = ((JCTree.JCCompilationUnit)moduleCtx).modle;
            classSym = JavacElements.instance(ctx).getTypeElement(moduleSym, fqn);
        } else if (moduleCtx instanceof JavaFileManager.Location) {
            try {
                moduleName = JavacPlugin.instance().getJavaFileManager().inferModuleName((JavaFileManager.Location)moduleCtx);
                if (moduleName == null) ** GOTO lbl21
                name = Names.instance(ctx).fromString(moduleName);
                moduleSym = Modules.instance(ctx).getObservableModule(name);
                classSym = JavacElements.instance(ctx).getTypeElement(moduleSym, fqn);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        } else if (moduleCtx instanceof Symbol.ModuleSymbol) {
            classSym = JavacElements.instance(ctx).getTypeElement((Symbol.ModuleSymbol)moduleCtx, fqn);
        } else if (moduleCtx != null) {
            throw new IllegalArgumentException("Unexpected moduleCtx type: " + moduleCtx.getClass().getTypeName());
        }
lbl21:
        // 6 sources

        if (classSym == null) {
            stack = ctx.get(ManifoldJavaFileManager.MODULE_CTX);
            if (stack == null) {
                moduleSym = Symtab.instance((Context)ctx).noModule;
            } else {
                v0 = moduleSym = stack.isEmpty() != false ? null : (Symbol.ModuleSymbol)stack.peek();
            }
            if (moduleSym != null) {
                classSym = JavacElements.instance(ctx).getTypeElement(moduleSym, fqn);
            }
            if (classSym == null) {
                return null;
            }
        }
        return classSym;
    }

    @Override
    public Symbol.ClassSymbol getLoadedClass(Context ctx, String fqn) {
        Symtab symtab = Symtab.instance(ctx);
        Name flatName = Names.instance(ctx).fromString(fqn);
        for (Symbol.ModuleSymbol msym : Modules.instance(ctx).allModules()) {
            Symbol.ClassSymbol classSym = symtab.getClass(msym, flatName);
            if (classSym == null) continue;
            return classSym;
        }
        return null;
    }

    @Override
    public void setOperatorSymbol(Context ctx, JCTree.JCBinary cond, JCTree.Tag tag, String op, Symbol operandType) {
        Operators operators = Operators.instance(ctx);
        Symbol.OperatorSymbol operatorSym = (Symbol.OperatorSymbol)ReflectUtil.method(operators, "resolveBinary", JCDiagnostic.DiagnosticPosition.class, JCTree.Tag.class, Type.class, Type.class).invoke(new Object[]{null, tag, operandType.type, operandType.type});
        this.setOperator(cond, operatorSym);
    }

    @Override
    public List<Type> getTargets(JCTree.JCLambda tree) {
        return tree.targets;
    }

    @Override
    public void setTargets(JCTree.JCLambda tree, List<Type> targets) {
        tree.targets = targets;
    }

    @Override
    public Symbol.OperatorSymbol getOperator(JCTree.JCExpression tree) {
        return ((JCTree.JCOperatorExpression)tree).operator;
    }

    @Override
    public void setOperator(JCTree.JCExpression tree, Symbol.OperatorSymbol operator) {
        ((JCTree.JCOperatorExpression)tree).operator = operator;
    }

    @Override
    public void logError(Log logger, JCDiagnostic.DiagnosticPosition pos, String key, Object ... args) {
        logger.error(pos, new JCDiagnostic.Error("compiler", key, args));
    }
}

