/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.host;

import java.util.List;
import manifold.api.fs.IDirectory;
import manifold.api.fs.IFileFragment;
import manifold.api.fs.IFileSystem;
import manifold.api.fs.def.FileSystemImpl;
import manifold.api.host.IModule;
import manifold.api.host.ITypeSystemListener;
import manifold.api.util.BytecodeOptions;
import manifold.internal.host.AbstractManifoldHost;
import manifold.internal.host.DefaultSingleModule;
import manifold.internal.host.TypeRefreshListener;
import manifold.internal.javac.JavaParser;
import manifold.util.concurrent.LocklessLazyVar;

public abstract class SingleModuleManifoldHost
extends AbstractManifoldHost {
    private DefaultSingleModule _module;
    private TypeRefreshListener _typeRefreshHandler = new TypeRefreshListener(this);
    private ThreadLocal<JavaParser> _javaParser = new ThreadLocal();
    private LocklessLazyVar<IFileSystem> _fileSystem = LocklessLazyVar.make(() -> {
        if (BytecodeOptions.JDWP_ENABLED.get().booleanValue()) {
            return new FileSystemImpl(this, IFileSystem.CachingMode.NO_CACHING);
        }
        return new FileSystemImpl(this, IFileSystem.CachingMode.FULL_CACHING);
    });

    @Override
    public IFileSystem getFileSystem() {
        return this._fileSystem.get();
    }

    @Override
    public JavaParser getJavaParser() {
        if (this._javaParser.get() == null) {
            this._javaParser.set(new JavaParser(this));
        }
        return this._javaParser.get();
    }

    @Override
    public IModule getSingleModule() {
        return this._module;
    }

    void createSingleModule(List<IDirectory> classpath, List<IDirectory> sourcePath, List<IDirectory> outputPath) {
        if (this._module != null) {
            throw new IllegalStateException();
        }
        this._module = new DefaultSingleModule(this, classpath, sourcePath, outputPath);
        this._module.initializeTypeManifolds();
    }

    @Override
    public void addTypeSystemListenerAsWeakRef(Object ctx, ITypeSystemListener listener) {
        this._typeRefreshHandler.addTypeSystemListenerAsWeakRef(listener);
    }

    @Override
    public void createdType(IFileFragment file, String[] types) {
        this._typeRefreshHandler.created(file, types);
    }
}

