/*
 * Decompiled with CFR 0.152.
 */
package manifold.graphql.type;

import graphql.language.ScalarTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.TypeDefinition;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileFragment;
import manifold.graphql.type.GqlIssue;
import manifold.graphql.type.GqlManifold;
import manifold.graphql.type.GqlModel;
import manifold.internal.javac.IIssue;
import manifold.shade.org.jetbrains.annotations.NotNull;
import manifold.shade.org.jetbrains.annotations.Nullable;

class GqlScope {
    private static final String DEFAULT = "_default_scope";
    private static final String ERRANT = "_errant_scope";
    private static final Map<GqlManifold, GqlScope> DEFAULT_SCOPE_BY_MODULE = new WeakHashMap<GqlManifold, GqlScope>();
    private final GqlManifold _gqlManifold;
    private final IFile _configFile;
    private String _name;
    private final Set<File> _schemaFiles;
    private final List<String> _includes;
    private final List<String> _excludes;
    private SchemaDefinition _schemaDefinition;
    private final List<IIssue> _issues;

    static GqlScope getDefaultScope(GqlManifold gqlManifold) {
        return DEFAULT_SCOPE_BY_MODULE.computeIfAbsent(gqlManifold, key -> new GqlScope((GqlManifold)key));
    }

    GqlScope(GqlManifold gqlManifold, IFile configFile, String name, Set<String> schemaFiles, List<String> includes, List<String> excludes, List<IIssue> issues) {
        this._gqlManifold = gqlManifold;
        this._configFile = configFile;
        this._name = name;
        this._schemaFiles = schemaFiles.stream().map(s -> new File((String)s)).collect(Collectors.toSet());
        this._includes = includes;
        this._excludes = excludes;
        this._issues = issues;
    }

    private GqlScope(GqlManifold gqlManifold) {
        this._gqlManifold = gqlManifold;
        this._configFile = null;
        this._name = DEFAULT;
        this._schemaFiles = Collections.emptySet();
        this._includes = Collections.emptyList();
        this._excludes = Collections.emptyList();
        this._issues = new ArrayList<IIssue>();
    }

    private GqlScope(GqlManifold gqlManifold, IFile configFile) {
        this._gqlManifold = gqlManifold;
        this._configFile = configFile;
        this._name = ERRANT;
        this._schemaFiles = Collections.emptySet();
        this._includes = Collections.emptyList();
        this._excludes = Collections.emptyList();
        this._issues = new ArrayList<IIssue>();
    }

    public static GqlScope makeErrantScope(GqlManifold gqlManifold, String fqn, IFile file) {
        GqlScope errantScope = new GqlScope(gqlManifold, file);
        errantScope._issues.add(new GqlIssue(IIssue.Kind.Error, 0, 0, 0, "GraphQL type '" + fqn + "' from file '" + file.getName() + "' is not covered in any .graphqlconfig files"));
        return errantScope;
    }

    boolean isDefault() {
        return DEFAULT.equals(this._name);
    }

    boolean hasConfigErrors() {
        return this._issues.stream().anyMatch(issue -> issue.getKind() == IIssue.Kind.Error);
    }

    IFile getConfigFile() {
        return this._configFile;
    }

    String getName() {
        return this._name;
    }

    void setName(String name) {
        this._name = name;
    }

    SchemaDefinition getSchemaDefinition() {
        this.ensureSchemaDefinitionAssigned();
        return this._schemaDefinition;
    }

    @Nullable
    private void ensureSchemaDefinitionAssigned() {
        if (this._schemaDefinition == null) {
            if (!this.isDefault()) {
                for (File file : this._schemaFiles) {
                    IFile schemaFile = this._gqlManifold.getModule().getHost().getFileSystem().getIFile(file);
                    Set<String> fqnForFile = this._gqlManifold.getModule().getPathCache().getFqnForFile(schemaFile);
                    if (fqnForFile == null || fqnForFile.isEmpty()) continue;
                    this._gqlManifold.getModel(fqnForFile.iterator().next());
                    if (this._schemaDefinition == null) continue;
                    return;
                }
            }
            this._gqlManifold.findByModel(model -> null);
        }
    }

    void setSchemaDefinition(SchemaDefinition schemaDefinition) {
        this._schemaDefinition = schemaDefinition;
    }

    List<IIssue> getIssues() {
        return this._issues;
    }

    TypeDefinition findTypeDefinition(String simpleName) {
        return this._gqlManifold.findByModel(model -> this.contains(model.getFile()) ? model.getTypeDefinition(simpleName) : null);
    }

    ScalarTypeDefinition findScalarTypeDefinition(String simpleName) {
        return this._gqlManifold.findByModel(model -> this.contains(model.getFile()) ? model.getScalarTypeDefinition(simpleName) : null);
    }

    Set<GqlModel> getAllModels() {
        return this._gqlManifold.findAllByModel(model -> this.contains(model.getFile()) ? model : null).collect(Collectors.toSet());
    }

    boolean contains(IFile file) {
        if (this.hasConfigErrors()) {
            return false;
        }
        if (this.isDefault()) {
            return true;
        }
        if (file instanceof IFileFragment) {
            return this.getName() != null && this.getName().equals(((IFileFragment)file).getScope());
        }
        if (this._schemaFiles.stream().anyMatch(f -> this.configFileRelativePath(f.getPath()).equals(file.getPath().getFileSystemPathString()))) {
            return true;
        }
        try {
            URI uri = new URI(file.toURI().getScheme() + ":/");
            FileSystem fs = FileSystems.getFileSystem(uri);
            Path path = file.toJavaFile().toPath();
            if (!this._includes.isEmpty()) {
                return this._includes.stream().anyMatch(glob -> fs.getPathMatcher(this.configFileRelativePath((String)glob)).matches(path));
            }
            if (!this._excludes.isEmpty()) {
                return this._excludes.stream().noneMatch(glob -> fs.getPathMatcher(this.configFileRelativePath((String)glob)).matches(path));
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return this._schemaFiles.stream().anyMatch(f -> file.isDescendantOf(this._gqlManifold.getModule().getHost().getFileSystem().getIDirectory(new File(this.configFileRelativePath(f.getPath())).getParentFile())));
    }

    @NotNull
    private String configFileRelativePath(String path) {
        return this._configFile.getParent().file(path).toJavaFile().getAbsolutePath();
    }
}

