/*
 * Decompiled with CFR 0.152.
 */
package manifold.graphql.rt.api.request;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import manifold.ext.rt.RuntimeMethods;
import manifold.graphql.rt.api.request.GqlRequestBody;
import manifold.graphql.rt.api.request.GqlRequestException;
import manifold.json.rt.api.Endpoint;
import manifold.json.rt.api.Requester;
import manifold.rt.api.Bindings;

public class Executor<T> {
    private final GqlRequestBody _reqArgs;
    private final Requester<Bindings> _requester;

    public Executor(String url, String operation, String query, Bindings variables, Class<T> resultType) {
        this._requester = new Requester(url, result -> this.coerce(resultType, result));
        this._requester.withHeader("Content-Type", "application/json");
        this._reqArgs = GqlRequestBody.create(query, variables);
    }

    public Executor(Endpoint endpoint, String operation, String query, Bindings variables, Class<T> resultType) {
        this._requester = new Requester(endpoint, result -> this.coerce(resultType, result));
        this._requester.withHeader("Content-Type", "application/json");
        this._reqArgs = GqlRequestBody.create(query, variables);
    }

    public Executor(Supplier<Requester<Bindings>> requester, String operation, String query, Bindings variables, Class<T> resultType) {
        this._requester = requester.get();
        this._requester.withCoercer(result -> this.coerce(resultType, result));
        this._requester.withHeader("Content-Type", "application/json");
        this._reqArgs = GqlRequestBody.create(query, variables);
    }

    private Object coerce(Class<T> resultType, Object result) {
        Bindings response = (Bindings)result;
        Object customResult = this.handleRawResponse(response);
        if (customResult != null) {
            return customResult;
        }
        this.handleErrors(response);
        return RuntimeMethods.coerce(response.get("data"), resultType);
    }

    public GqlRequestBody getRequestBody() {
        return this._reqArgs;
    }

    public Map<String, String> getHeaders() {
        return this._requester.getHeaders();
    }

    public Endpoint getEndpoint() {
        return this._requester.getEndpoint();
    }

    public Requester.Format getFormat() {
        return this._requester.getFormat();
    }

    public int getTimeout() {
        return this._requester.getTimeout();
    }

    public Executor<T> withHeader(String name, String value) {
        this._requester.withHeader(name, value);
        return this;
    }

    public Executor<T> withParam(String name, String value) {
        this._requester.withParam(name, value);
        return this;
    }

    public Executor<T> withBasicAuthorization(String username, String password) {
        this._requester.withBasicAuthorization(username, password);
        return this;
    }

    public Executor<T> withBearerAuthorization(String accessToken) {
        return this.withAuthorization("Bearer", accessToken);
    }

    public Executor<T> withAuthorization(String tokenType, String accessToken) {
        return this.withHeader("Authorization", tokenType + " " + accessToken);
    }

    public Executor<T> withTimeout(int timeout) {
        this._requester.withTimeout(timeout);
        return this;
    }

    public Executor<T> withRawResponseHandler(Function<Bindings, Object> handler) {
        this._requester.withRawResponseHandler(handler);
        return this;
    }

    public Function<Bindings, Object> getRawResponseHandler() {
        return this._requester.getRawResponseHandler();
    }

    public T post() throws GqlRequestException {
        return (T)this._requester.postOne(((GqlRequestBody)RuntimeMethods.constructProxy(this._reqArgs, GqlRequestBody.class)).getBindings());
    }

    public T post(Requester.Format format) throws GqlRequestException {
        return (T)this._requester.postOne("", ((GqlRequestBody)RuntimeMethods.constructProxy(this._reqArgs, GqlRequestBody.class)).getBindings(), format);
    }

    public T get() throws GqlRequestException {
        return (T)this._requester.getOne(((GqlRequestBody)RuntimeMethods.constructProxy(this._reqArgs, GqlRequestBody.class)).getBindings());
    }

    public T get(Requester.Format format) throws GqlRequestException {
        return (T)this._requester.getOne("", ((GqlRequestBody)RuntimeMethods.constructProxy(this._reqArgs, GqlRequestBody.class)).getBindings(), format);
    }

    private Object handleRawResponse(Bindings response) {
        Function<Bindings, Object> handler = this._requester.getRawResponseHandler();
        if (handler != null) {
            return handler.apply(response);
        }
        return null;
    }

    private void handleErrors(Bindings response) {
        List errors = (List)response.get("errors");
        if (errors != null && !errors.isEmpty()) {
            throw new GqlRequestException(response);
        }
    }
}

