/*
 * Decompiled with CFR 0.152.
 */
package manifold.collections.api.range;

import java.math.BigDecimal;
import java.math.BigInteger;
import manifold.collections.api.range.AbstractIterableRange;
import manifold.collections.api.range.AbstractRange;
import manifold.collections.api.range.BigDecimalRange;
import manifold.collections.api.range.BigIntegerRange;
import manifold.collections.api.range.ComparableRange;
import manifold.collections.api.range.DoubleRange;
import manifold.collections.api.range.IntegerRange;
import manifold.collections.api.range.LongRange;
import manifold.collections.api.range.Sequential;
import manifold.collections.api.range.SequentialRange;

public final class RangeFun {
    public static final Closed to = Closed.instance();
    public static final LeftOpen _to = LeftOpen.instance();
    public static final RightOpen to_ = RightOpen.instance();
    public static final Open _to_ = Open.instance();
    public static final Step step = Step.instance();
    public static final Unit unit = Unit.instance();
    public static final Inside inside = Inside.instance();
    public static final Outside outside = Outside.instance();

    public static class Outside {
        private static final Outside INSTANCE = new Outside();

        public static Outside instance() {
            return INSTANCE;
        }

        public <E extends Comparable<E>, RANGE extends AbstractRange<E, RANGE>> OutsideRange<E, RANGE> prefixBind(RANGE range) {
            return new OutsideRange(range);
        }

        public static class OutsideRange<E extends Comparable<E>, RANGE extends AbstractRange<E, RANGE>> {
            private final RANGE _range;

            OutsideRange(RANGE range) {
                this._range = range;
            }

            public boolean postfixBind(E element) {
                return !((AbstractRange)this._range).contains(element);
            }
        }
    }

    public static class Inside {
        private static final Inside INSTANCE = new Inside();

        public static Inside instance() {
            return INSTANCE;
        }

        public <E extends Comparable<E>, RANGE extends AbstractRange<E, RANGE>> InsideRange<E, RANGE> prefixBind(RANGE range) {
            return new InsideRange(range);
        }

        public static class InsideRange<E extends Comparable<E>, RANGE extends AbstractRange<E, RANGE>> {
            private final RANGE _range;

            InsideRange(RANGE range) {
                this._range = range;
            }

            public boolean postfixBind(E element) {
                return ((AbstractRange)this._range).contains(element);
            }
        }
    }

    public static class Unit {
        private static final Unit INSTANCE = new Unit();

        public static Unit instance() {
            return INSTANCE;
        }

        public <E extends Comparable<E>, S, U, RANGE extends AbstractIterableRange<E, S, U, RANGE>> UnitRange<E, S, U, RANGE> postfixBind(RANGE range) {
            return new UnitRange(range);
        }

        public static class UnitRange<E extends Comparable<E>, S, U, RANGE extends AbstractIterableRange<E, S, U, RANGE>> {
            private final RANGE _range;

            UnitRange(RANGE range) {
                this._range = range;
            }

            public RANGE prefixBind(U unit) {
                return (RANGE)((AbstractIterableRange)this._range).unit((Object)unit);
            }
        }
    }

    public static class Step {
        private static final Step INSTANCE = new Step();

        public static Step instance() {
            return INSTANCE;
        }

        public <E extends Comparable<E>, S, U, RANGE extends AbstractIterableRange<E, S, U, RANGE>> StepRange<E, S, U, RANGE> postfixBind(RANGE range) {
            return new StepRange(range);
        }

        public static class StepRange<E extends Comparable<E>, S, U, RANGE extends AbstractIterableRange<E, S, U, RANGE>> {
            private final RANGE _range;

            StepRange(RANGE range) {
                this._range = range;
            }

            public RANGE prefixBind(S step) {
                return (RANGE)((AbstractIterableRange)this._range).step((Object)step);
            }
        }
    }

    public static class Open
    extends Closed {
        private static final Open INSTANCE = new Open();

        public static Open instance() {
            return INSTANCE;
        }

        private Open() {
            this._leftClosed = false;
            this._rightClosed = false;
        }
    }

    public static class RightOpen
    extends Closed {
        private static final RightOpen INSTANCE = new RightOpen();

        public static RightOpen instance() {
            return INSTANCE;
        }

        private RightOpen() {
            this._rightClosed = false;
        }
    }

    public static class LeftOpen
    extends Closed {
        private static final LeftOpen INSTANCE = new LeftOpen();

        public static LeftOpen instance() {
            return INSTANCE;
        }

        private LeftOpen() {
            this._leftClosed = false;
        }
    }

    public static class Closed {
        private static final Closed INSTANCE = new Closed();
        boolean _leftClosed = true;
        boolean _rightClosed = true;

        public static Closed instance() {
            return INSTANCE;
        }

        private Closed() {
        }

        public <E extends Comparable<E>> From_Comp<E> postfixBind(E comparable) {
            return new From_Comp(this, comparable);
        }

        public <E extends Sequential<E, S, U>, S, U> From_Seq<E, S, U> postfixBind(E sequential) {
            return new From_Seq(this, sequential);
        }

        public From_BigDecimal postfixBind(BigDecimal bd) {
            return new From_BigDecimal(bd);
        }

        public From_BigInteger postfixBind(BigInteger bd) {
            return new From_BigInteger(bd);
        }

        public From_Double postfixBind(Double bd) {
            return new From_Double(bd);
        }

        public From_Long postfixBind(Long bd) {
            return new From_Long(bd);
        }

        public From_Integer postfixBind(Integer bd) {
            return new From_Integer(bd);
        }

        public class From_Integer {
            private Integer _start;

            From_Integer(Integer sequential) {
                this._start = sequential;
            }

            public IntegerRange prefixBind(Integer end) {
                return new IntegerRange(this._start, end, 1, Closed.this._leftClosed, Closed.this._rightClosed, this._start.compareTo(end) > 0);
            }
        }

        public class From_Long {
            private Long _start;

            From_Long(Long sequential) {
                this._start = sequential;
            }

            public LongRange prefixBind(Long end) {
                return new LongRange(this._start, end, 1L, Closed.this._leftClosed, Closed.this._rightClosed, this._start.compareTo(end) > 0);
            }
        }

        public class From_Double {
            private Double _start;

            From_Double(Double sequential) {
                this._start = sequential;
            }

            public DoubleRange prefixBind(Double end) {
                return new DoubleRange(this._start, end, 1.0, Closed.this._leftClosed, Closed.this._rightClosed, this._start.compareTo(end) > 0);
            }
        }

        public class From_BigInteger {
            private BigInteger _start;

            From_BigInteger(BigInteger sequential) {
                this._start = sequential;
            }

            public BigIntegerRange prefixBind(BigInteger end) {
                return new BigIntegerRange(this._start, end, BigInteger.ONE, Closed.this._leftClosed, Closed.this._rightClosed, this._start.compareTo(end) > 0);
            }
        }

        public class From_BigDecimal {
            private BigDecimal _start;

            From_BigDecimal(BigDecimal sequential) {
                this._start = sequential;
            }

            public BigDecimalRange prefixBind(BigDecimal end) {
                return new BigDecimalRange(this._start, end, BigDecimal.ONE, Closed.this._leftClosed, Closed.this._rightClosed, this._start.compareTo(end) > 0);
            }
        }

        public static class From_Seq<E extends Sequential<E, S, U>, S, U> {
            private E _start;
            final /* synthetic */ Closed this$0;

            From_Seq(E sequential) {
                this.this$0 = this$0;
                this._start = sequential;
            }

            public SequentialRange<E, S, U> prefixBind(E end) {
                return new SequentialRange<E, Object, Object>(this._start, end, null, null, this.this$0._leftClosed, this.this$0._rightClosed, this._start.compareTo(end) > 0);
            }
        }

        public static class From_Comp<E extends Comparable<E>> {
            private E _start;
            final /* synthetic */ Closed this$0;

            From_Comp(E sequential) {
                this.this$0 = this$0;
                this._start = sequential;
            }

            public ComparableRange<E> prefixBind(E end) {
                return new ComparableRange<E>(this._start, end, this.this$0._leftClosed, this.this$0._rightClosed, this._start.compareTo(end) > 0);
            }
        }
    }
}

