/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.type;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import manifold.api.type.IIncrementalCompileDriver;

public class BasicIncrementalCompileDriver
implements IIncrementalCompileDriver {
    private final boolean _incremental;

    public BasicIncrementalCompileDriver(boolean incremental) {
        this._incremental = incremental;
    }

    @Override
    public boolean isIncremental() {
        return this._incremental;
    }

    @Override
    public Collection<File> getChangedFiles() {
        String manFilesProp = System.getProperty("manifold.source.files");
        if (manFilesProp == null) {
            return Collections.emptySet();
        }
        ArrayList<String> paths = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(manFilesProp, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            paths.add(tokenizer.nextToken());
        }
        return paths.stream().map(File::new).collect(Collectors.toList());
    }
}

