/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.codegen.schema;

import java.util.Map;
import manifold.api.json.codegen.IJsonParentType;
import manifold.api.json.codegen.IJsonType;
import manifold.api.json.codegen.JsonBasicType;
import manifold.api.json.codegen.schema.TypeAttributes;
import manifold.rt.api.util.Pair;
import manifold.util.concurrent.ConcurrentWeakValueHashMap;

public class JsonFormatType
implements IJsonType {
    private static final Map<Pair<String, Class<?>>, JsonFormatType> PROTOTYPES = new ConcurrentWeakValueHashMap();
    private final String _format;
    private final Class<?> _javaType;
    private final TypeAttributes _typeAttributes;

    public static JsonFormatType getPrototype(String format, Class<?> javaType) {
        return PROTOTYPES.computeIfAbsent(new Pair(format, javaType), key -> new JsonFormatType((String)key.getFirst(), (Class)key.getSecond()));
    }

    JsonFormatType(String format, Class<?> javaType) {
        this(format, javaType, new TypeAttributes());
    }

    private JsonFormatType(String format, Class<?> javaType, TypeAttributes typeAttributes) {
        this._format = format;
        this._javaType = javaType;
        this._typeAttributes = typeAttributes;
    }

    public Class<?> getJavaType() {
        return this._javaType;
    }

    public String getFormat() {
        return this._format;
    }

    @Override
    public String getName() {
        return this._format;
    }

    @Override
    public IJsonParentType getParent() {
        return null;
    }

    @Override
    public TypeAttributes getTypeAttributes() {
        return this._typeAttributes;
    }

    @Override
    public IJsonType copyWithAttributes(TypeAttributes attributes) {
        if (this.getTypeAttributes().equals(attributes)) {
            return this;
        }
        return new JsonFormatType(this._format, this._javaType, this.getTypeAttributes().overrideWith(attributes));
    }

    @Override
    public JsonFormatType merge(IJsonType type) {
        if (type instanceof JsonBasicType || type instanceof JsonFormatType) {
            return this;
        }
        return null;
    }

    @Override
    public String getIdentifier() {
        return this.getJavaType().getTypeName();
    }
}

