/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.gen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class TypeNameParser {
    private static final String TOKENS = "<>,[]?& ";
    private final StringTokenizer _tokenizer;
    private String _token;

    public TypeNameParser(String typeName) {
        this._tokenizer = new StringTokenizer(typeName, TOKENS, true);
    }

    public Type parse() {
        this.nextToken();
        return this.parseType();
    }

    public List<Type> parseCommaSeparated() {
        this.nextToken();
        Type param = this.parseType();
        if (param == null) {
            return Collections.emptyList();
        }
        ArrayList<Type> types = new ArrayList<Type>();
        types.add(param);
        while (this.match(',')) {
            types.add(this.parseType());
        }
        return types;
    }

    private Type parseType() {
        Type type;
        if (this.match('?')) {
            String superOrExtends = this._token;
            if (this.matchName()) {
                this.verifySuperOrExtends(superOrExtends);
                List<Type> bounds = this.parseCompoundType();
                type = new Type("?", superOrExtends, bounds);
            } else {
                type = new Type("?");
            }
        } else {
            String name = this._token;
            if (this.matchName()) {
                type = new Type(name);
                String superOrExtends = this._token;
                if (this.matchName()) {
                    this.verifySuperOrExtends(superOrExtends);
                    List<Type> bounds = this.parseCompoundType();
                    type = new Type(name, superOrExtends, bounds);
                }
            } else if (this.match('<')) {
                type = null;
                String any2 = this._token;
                if (this.matchName()) {
                    if (!this.match('>')) {
                        throw new RuntimeException("expecting '>");
                    }
                    if (any2.equals("any")) {
                        type = new Type("Err");
                    }
                }
            } else {
                return null;
            }
        }
        if (this.match('<')) {
            this.parseParamList(type);
            if (!this.match('>')) {
                throw new RuntimeException("expecting '>");
            }
            Type innerType = this.parseType();
            if (innerType != null) {
                innerType._fqn = type._fqn + innerType._fqn;
                type = innerType;
            }
        }
        while (this.match('[')) {
            if (!this.match(']')) {
                throw new RuntimeException("expecting ']");
            }
            ++type._arrayDim;
        }
        return type;
    }

    private List<Type> parseCompoundType() {
        ArrayList<Type> bounds = new ArrayList<Type>();
        do {
            bounds.add(this.parseType());
        } while (this.match('&'));
        return bounds;
    }

    private void verifySuperOrExtends(String superOrExtends) {
        if (!superOrExtends.equals("super") && !superOrExtends.equals("extends")) {
            throw new RuntimeException("expecting 'extends' or 'super'");
        }
    }

    private void parseParamList(Type type) {
        Type param = this.parseType();
        if (param == null) {
            type._diamond = true;
            return;
        }
        type.addParam(param);
        while (this.match(',')) {
            type.addParam(this.parseType());
        }
    }

    private boolean match(char c) {
        if (this._token.equals(String.valueOf(c))) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean matchName() {
        if (this._token.length() > 0 && !TOKENS.contains(this._token)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private void nextToken() {
        do {
            this._token = this._tokenizer.hasMoreTokens() ? this._tokenizer.nextToken() : "";
        } while (this._token.equals(" "));
    }

    public static class Type {
        String _fqn;
        List<Type> _params;
        String _superOrExtends;
        List<Type> _bound;
        boolean _diamond;
        int _arrayDim;

        public Type() {
        }

        public Type(String fqn) {
            this._fqn = fqn;
            this._params = new ArrayList<Type>();
        }

        public Type(String fqn, String superOrExtends, List<Type> bound) {
            this._fqn = fqn;
            this._superOrExtends = superOrExtends;
            this._bound = bound;
            this._params = Collections.emptyList();
        }

        public String getPlainName() {
            return this._fqn;
        }

        void addParam(Type param) {
            this._params.add(param);
        }

        Type getComponentType() {
            if (this._arrayDim == 0) {
                return null;
            }
            Type copy = new Type(this._fqn);
            copy._params = this._params;
            copy._superOrExtends = this._superOrExtends;
            copy._bound = this._bound;
            copy._diamond = this._diamond;
            copy._arrayDim = this._arrayDim - 1;
            return copy;
        }

        public String getFullName() {
            int i;
            StringBuilder sb = new StringBuilder(this._fqn);
            if (this._diamond) {
                sb.append("<>");
            } else if (this._superOrExtends != null) {
                sb.append(' ').append(this._superOrExtends).append(' ');
                for (i = 0; i < this._bound.size(); ++i) {
                    if (i > 0) {
                        sb.append(" & ");
                    }
                    sb.append(this._bound.get(i).getFullName());
                }
            } else if (this._params.size() > 0) {
                sb.append('<');
                for (i = 0; i < this._params.size(); ++i) {
                    Type param = this._params.get(i);
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(param.getFullName());
                }
                sb.append('>');
            }
            for (i = 0; i < this._arrayDim; ++i) {
                sb.append("[]");
            }
            return sb.toString();
        }

        public String toString() {
            return this.getFullName();
        }
    }
}

