/*
 * Decompiled with CFR 0.152.
 */
package graphql.util;

import graphql.Assert;
import graphql.Internal;
import graphql.util.DefaultTraverserContext;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.util.TraverserResult;
import graphql.util.TraverserState;
import graphql.util.TraverserVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

@Internal
public class Traverser<T> {
    private final TraverserState<T> traverserState;
    private final Function<? super T, Map<String, ? extends List<T>>> getChildren;
    private final Object initialAccumulate;
    private final Map<Class<?>, Object> rootVars = new ConcurrentHashMap();
    private static final List<TraversalControl> CONTINUE_OR_QUIT = Arrays.asList(TraversalControl.CONTINUE, TraversalControl.QUIT);

    private Traverser(TraverserState<T> traverserState, Function<? super T, Map<String, ? extends List<T>>> getChildren, Object initialAccumulate) {
        this.traverserState = Assert.assertNotNull(traverserState);
        this.getChildren = Assert.assertNotNull(getChildren);
        this.initialAccumulate = initialAccumulate;
    }

    private static <T> Function<? super T, Map<String, ? extends List<T>>> wrapListFunction(Function<? super T, ? extends List<T>> listFn) {
        return node -> {
            List childs = (List)listFn.apply(node);
            LinkedHashMap<Object, List> result = new LinkedHashMap<Object, List>();
            result.put(null, childs);
            return result;
        };
    }

    public Traverser<T> rootVars(Map<Class<?>, Object> rootVars) {
        this.rootVars.putAll(Assert.assertNotNull(rootVars));
        return this;
    }

    public Traverser<T> rootVar(Class<?> key, Object value) {
        this.rootVars.put(key, value);
        return this;
    }

    public static <T> Traverser<T> depthFirst(Function<? super T, ? extends List<T>> getChildren) {
        return Traverser.depthFirst(getChildren, null, null);
    }

    public static <T> Traverser<T> depthFirst(Function<? super T, ? extends List<T>> getChildren, Object sharedContextData) {
        return Traverser.depthFirst(getChildren, sharedContextData, null);
    }

    public static <T> Traverser<T> depthFirst(Function<? super T, ? extends List<T>> getChildren, Object sharedContextData, Object initialAccumulate) {
        Function<? super T, Map<String, ? extends List<T>>> mapFunction = Traverser.wrapListFunction(getChildren);
        return new Traverser<T>(TraverserState.newStackState(sharedContextData), mapFunction, initialAccumulate);
    }

    public static <T> Traverser<T> depthFirstWithNamedChildren(Function<? super T, Map<String, ? extends List<T>>> getNamedChildren, Object sharedContextData, Object initialAccumulate) {
        return new Traverser<T>(TraverserState.newStackState(sharedContextData), getNamedChildren, initialAccumulate);
    }

    public static <T> Traverser<T> breadthFirst(Function<? super T, ? extends List<T>> getChildren) {
        return Traverser.breadthFirst(getChildren, null, null);
    }

    public static <T> Traverser<T> breadthFirst(Function<? super T, ? extends List<T>> getChildren, Object sharedContextData) {
        return Traverser.breadthFirst(getChildren, sharedContextData, null);
    }

    public static <T> Traverser<T> breadthFirst(Function<? super T, ? extends List<T>> getChildren, Object sharedContextData, Object initialAccumulate) {
        Function<? super T, Map<String, ? extends List<T>>> mapFunction = Traverser.wrapListFunction(getChildren);
        return new Traverser<T>(TraverserState.newQueueState(sharedContextData), mapFunction, initialAccumulate);
    }

    public static <T> Traverser<T> breadthFirstWithNamedChildren(Function<? super T, Map<String, ? extends List<T>>> getNamedChildren, Object sharedContextData, Object initialAccumulate) {
        return new Traverser<T>(TraverserState.newQueueState(sharedContextData), getNamedChildren, initialAccumulate);
    }

    public TraverserResult traverse(T root, TraverserVisitor<? super T> visitor) {
        return this.traverse((Collection<? extends T>)Collections.singleton(root), visitor);
    }

    public TraverserResult traverse(Collection<? extends T> roots, TraverserVisitor<? super T> visitor) {
        Assert.assertNotNull(roots);
        Assert.assertNotNull(visitor);
        DefaultTraverserContext<T> rootContext = this.traverserState.newRootContext(this.rootVars);
        this.traverserState.addNewContexts(roots, rootContext);
        Object currentAccValue = this.initialAccumulate;
        block9: while (!this.traverserState.isEmpty()) {
            TraversalControl traversalControl;
            DefaultTraverserContext currentContext;
            Object top = this.traverserState.pop();
            if (top instanceof TraverserState.EndList) {
                Map childrenContextMap = ((TraverserState.EndList)top).childrenContextMap;
                currentContext = (DefaultTraverserContext)this.traverserState.pop();
                currentContext.setCurAccValue(currentAccValue);
                currentContext.setChildrenContexts(childrenContextMap);
                currentContext.setPhase(TraverserContext.Phase.LEAVE);
                traversalControl = visitor.leave(currentContext);
                currentAccValue = currentContext.getNewAccumulate();
                Assert.assertNotNull(traversalControl, "result of leave must not be null", new Object[0]);
                Assert.assertTrue(CONTINUE_OR_QUIT.contains((Object)traversalControl), "result can only return CONTINUE or QUIT", new Object[0]);
                switch (traversalControl) {
                    case QUIT: {
                        break block9;
                    }
                    case CONTINUE: {
                        continue block9;
                    }
                    default: {
                        Assert.assertShouldNeverHappen();
                    }
                }
            }
            if ((currentContext = (DefaultTraverserContext)top).isVisited()) {
                currentContext.setCurAccValue(currentAccValue);
                currentContext.setPhase(TraverserContext.Phase.BACKREF);
                TraversalControl traversalControl2 = visitor.backRef(currentContext);
                currentAccValue = currentContext.getNewAccumulate();
                Assert.assertNotNull(traversalControl2, "result of backRef must not be null", new Object[0]);
                Assert.assertTrue(CONTINUE_OR_QUIT.contains((Object)traversalControl2), "backRef can only return CONTINUE or QUIT", new Object[0]);
                if (traversalControl2 != TraversalControl.QUIT) continue;
                break;
            }
            currentContext.setCurAccValue(currentAccValue);
            Object nodeBeforeEnter = currentContext.thisNode();
            currentContext.setPhase(TraverserContext.Phase.ENTER);
            traversalControl = visitor.enter(currentContext);
            currentAccValue = currentContext.getNewAccumulate();
            Assert.assertNotNull(traversalControl, "result of enter must not be null", new Object[0]);
            this.traverserState.addVisited(nodeBeforeEnter);
            switch (traversalControl) {
                case QUIT: {
                    break block9;
                }
                case ABORT: {
                    continue block9;
                }
                case CONTINUE: {
                    this.traverserState.pushAll(currentContext, this.getChildren);
                    continue block9;
                }
                default: {
                    Assert.assertShouldNeverHappen();
                }
            }
        }
        TraverserResult traverserResult = new TraverserResult(currentAccValue);
        return traverserResult;
    }
}

