/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Internal;
import graphql.Scalars;
import graphql.schema.Coercing;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.PropertyDataFetcher;
import graphql.schema.TypeResolver;
import graphql.schema.idl.FieldWiringEnvironment;
import graphql.schema.idl.InterfaceWiringEnvironment;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.UnionWiringEnvironment;
import graphql.schema.idl.WiringFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.function.Consumer;

@Internal
public class EchoingWiringFactory
implements WiringFactory {
    public static RuntimeWiring newEchoingWiring() {
        return EchoingWiringFactory.newEchoingWiring(x -> {});
    }

    public static RuntimeWiring newEchoingWiring(Consumer<RuntimeWiring.Builder> builderConsumer) {
        RuntimeWiring.Builder builder = RuntimeWiring.newRuntimeWiring();
        builderConsumer.accept(builder);
        return builder.wiringFactory(new EchoingWiringFactory()).build();
    }

    @Override
    public boolean providesTypeResolver(InterfaceWiringEnvironment environment) {
        return true;
    }

    @Override
    public TypeResolver getTypeResolver(InterfaceWiringEnvironment environment) {
        return env -> env.getSchema().getQueryType();
    }

    @Override
    public boolean providesTypeResolver(UnionWiringEnvironment environment) {
        return true;
    }

    @Override
    public TypeResolver getTypeResolver(UnionWiringEnvironment environment) {
        return env -> env.getSchema().getQueryType();
    }

    @Override
    public DataFetcher getDefaultDataFetcher(FieldWiringEnvironment environment) {
        return env -> {
            GraphQLOutputType fieldType = env.getFieldType();
            if (fieldType instanceof GraphQLObjectType) {
                return EchoingWiringFactory.fakeObjectValue((GraphQLObjectType)fieldType);
            }
            PropertyDataFetcher df = new PropertyDataFetcher(env.getFieldDefinition().getName());
            return df.get(env);
        };
    }

    private static Object fakeObjectValue(GraphQLObjectType fieldType) {
        LinkedHashMap map = new LinkedHashMap();
        fieldType.getFieldDefinitions().forEach(fldDef -> {
            GraphQLOutputType innerFieldType = fldDef.getType();
            Object obj = null;
            if (innerFieldType instanceof GraphQLObjectType) {
                obj = EchoingWiringFactory.fakeObjectValue((GraphQLObjectType)innerFieldType);
            } else if (innerFieldType instanceof GraphQLScalarType) {
                obj = EchoingWiringFactory.fakeScalarValue(fldDef.getName(), (GraphQLScalarType)innerFieldType);
            }
            map.put(fldDef.getName(), obj);
        });
        return map;
    }

    private static Object fakeScalarValue(String fieldName, GraphQLScalarType scalarType) {
        if (scalarType.equals(Scalars.GraphQLString)) {
            return fieldName;
        }
        if (scalarType.equals(Scalars.GraphQLBoolean)) {
            return true;
        }
        if (scalarType.equals(Scalars.GraphQLInt)) {
            return 1;
        }
        if (scalarType.equals(Scalars.GraphQLFloat)) {
            return 1.0;
        }
        if (scalarType.equals(Scalars.GraphQLID)) {
            return "id_" + fieldName;
        }
        if (scalarType.equals(Scalars.GraphQLBigDecimal)) {
            return new BigDecimal(1.0);
        }
        if (scalarType.equals(Scalars.GraphQLBigInteger)) {
            return new BigInteger("1");
        }
        if (scalarType.equals(Scalars.GraphQLByte)) {
            return Byte.valueOf("1");
        }
        if (scalarType.equals(Scalars.GraphQLShort)) {
            return Short.valueOf("1");
        }
        return null;
    }

    public static GraphQLScalarType fakeScalar(String name) {
        return new GraphQLScalarType(name, name, new Coercing(){

            public Object serialize(Object dataFetcherResult) {
                return dataFetcherResult;
            }

            public Object parseValue(Object input) {
                return input;
            }

            public Object parseLiteral(Object input) {
                return input;
            }
        });
    }
}

