/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.language.ScalarTypeDefinition;
import graphql.schema.Coercing;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNullableType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.GraphqlTypeBuilder;
import graphql.schema.GraphqlTypeComparatorRegistry;
import graphql.util.FpKit;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class GraphQLScalarType
implements GraphQLType,
GraphQLInputType,
GraphQLOutputType,
GraphQLUnmodifiedType,
GraphQLNullableType,
GraphQLDirectiveContainer {
    private final String name;
    private final String description;
    private final Coercing coercing;
    private final ScalarTypeDefinition definition;
    private final List<GraphQLDirective> directives;

    @Internal
    @Deprecated
    public GraphQLScalarType(String name, String description, Coercing coercing) {
        this(name, description, coercing, Collections.emptyList(), null);
    }

    @Internal
    @Deprecated
    public GraphQLScalarType(String name, String description, Coercing coercing, List<GraphQLDirective> directives, ScalarTypeDefinition definition) {
        Assert.assertValidName(name);
        Assert.assertNotNull(coercing, "coercing can't be null", new Object[0]);
        Assert.assertNotNull(directives, "directives can't be null", new Object[0]);
        this.name = name;
        this.description = description;
        this.coercing = coercing;
        this.definition = definition;
        this.directives = directives;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Coercing getCoercing() {
        return this.coercing;
    }

    public ScalarTypeDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public List<GraphQLDirective> getDirectives() {
        return new ArrayList<GraphQLDirective>(this.directives);
    }

    public String toString() {
        return "GraphQLScalarType{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", coercing=" + this.coercing + '}';
    }

    public GraphQLScalarType transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLScalarType.newScalar(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    @Override
    public TraversalControl accept(TraverserContext<GraphQLType> context, GraphQLTypeVisitor visitor) {
        return visitor.visitGraphQLScalarType(this, context);
    }

    @Override
    public List<GraphQLType> getChildren() {
        return new ArrayList<GraphQLType>(this.directives);
    }

    public static Builder newScalar() {
        return new Builder();
    }

    public static Builder newScalar(GraphQLScalarType existing) {
        return new Builder(existing);
    }

    @PublicApi
    public static class Builder
    extends GraphqlTypeBuilder {
        private Coercing coercing;
        private ScalarTypeDefinition definition;
        private final Map<String, GraphQLDirective> directives = new LinkedHashMap<String, GraphQLDirective>();

        public Builder() {
        }

        public Builder(GraphQLScalarType existing) {
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.coercing = existing.getCoercing();
            this.definition = existing.getDefinition();
            this.directives.putAll(FpKit.getByName(existing.getDirectives(), GraphQLDirective::getName));
        }

        @Override
        public Builder name(String name) {
            super.name(name);
            return this;
        }

        @Override
        public Builder description(String description) {
            super.description(description);
            return this;
        }

        @Override
        public Builder comparatorRegistry(GraphqlTypeComparatorRegistry comparatorRegistry) {
            super.comparatorRegistry(comparatorRegistry);
            return this;
        }

        public Builder definition(ScalarTypeDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder coercing(Coercing coercing) {
            this.coercing = coercing;
            return this;
        }

        public Builder withDirectives(GraphQLDirective ... directives) {
            for (GraphQLDirective directive : directives) {
                this.withDirective(directive);
            }
            return this;
        }

        public Builder withDirective(GraphQLDirective directive) {
            Assert.assertNotNull(directive, "directive can't be null", new Object[0]);
            this.directives.put(directive.getName(), directive);
            return this;
        }

        public Builder withDirective(GraphQLDirective.Builder builder) {
            return this.withDirective(builder.build());
        }

        public Builder clearDirectives() {
            this.directives.clear();
            return this;
        }

        public GraphQLScalarType build() {
            return new GraphQLScalarType(this.name, this.description, this.coercing, this.sort(this.directives, GraphQLScalarType.class, GraphQLDirective.class), this.definition);
        }
    }
}

