/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.AssertException;
import graphql.Internal;
import graphql.PublicApi;
import graphql.language.ObjectTypeDefinition;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNullableType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.GraphqlTypeBuilder;
import graphql.schema.GraphqlTypeComparatorRegistry;
import graphql.schema.GraphqlTypeComparators;
import graphql.util.FpKit;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

@PublicApi
public class GraphQLObjectType
implements GraphQLType,
GraphQLOutputType,
GraphQLFieldsContainer,
GraphQLCompositeType,
GraphQLUnmodifiedType,
GraphQLNullableType,
GraphQLDirectiveContainer {
    private final String name;
    private final String description;
    private final Comparator<? super GraphQLType> interfaceComparator;
    private final Map<String, GraphQLFieldDefinition> fieldDefinitionsByName = new LinkedHashMap<String, GraphQLFieldDefinition>();
    private List<GraphQLOutputType> interfaces;
    private final List<GraphQLDirective> directives;
    private final ObjectTypeDefinition definition;

    @Internal
    @Deprecated
    public GraphQLObjectType(String name, String description, List<GraphQLFieldDefinition> fieldDefinitions, List<GraphQLOutputType> interfaces) {
        this(name, description, fieldDefinitions, interfaces, Collections.emptyList(), null);
    }

    @Internal
    @Deprecated
    public GraphQLObjectType(String name, String description, List<GraphQLFieldDefinition> fieldDefinitions, List<GraphQLOutputType> interfaces, List<GraphQLDirective> directives, ObjectTypeDefinition definition) {
        this(name, description, fieldDefinitions, interfaces, directives, definition, GraphqlTypeComparators.asIsOrder());
    }

    private GraphQLObjectType(String name, String description, List<GraphQLFieldDefinition> fieldDefinitions, List<GraphQLOutputType> interfaces, List<GraphQLDirective> directives, ObjectTypeDefinition definition, Comparator<? super GraphQLType> interfaceComparator) {
        Assert.assertValidName(name);
        Assert.assertNotNull(fieldDefinitions, "fieldDefinitions can't be null", new Object[0]);
        Assert.assertNotNull(interfaces, "interfaces can't be null", new Object[0]);
        this.name = name;
        this.description = description;
        this.interfaces = GraphqlTypeComparators.sortTypes(interfaceComparator, interfaces);
        this.definition = definition;
        this.directives = Assert.assertNotNull(directives);
        this.interfaceComparator = interfaceComparator;
        this.buildDefinitionMap(fieldDefinitions);
    }

    void replaceInterfaces(List<GraphQLOutputType> interfaces) {
        this.interfaces = GraphqlTypeComparators.sortTypes(this.interfaceComparator, interfaces);
    }

    private void buildDefinitionMap(List<GraphQLFieldDefinition> fieldDefinitions) {
        for (GraphQLFieldDefinition fieldDefinition : fieldDefinitions) {
            String name = fieldDefinition.getName();
            if (this.fieldDefinitionsByName.containsKey(name)) {
                throw new AssertException(String.format("Duplicated definition for field '%s' in type '%s'", name, this.name));
            }
            this.fieldDefinitionsByName.put(name, fieldDefinition);
        }
    }

    @Override
    public List<GraphQLDirective> getDirectives() {
        return new ArrayList<GraphQLDirective>(this.directives);
    }

    @Override
    public GraphQLFieldDefinition getFieldDefinition(String name) {
        return this.fieldDefinitionsByName.get(name);
    }

    @Override
    public List<GraphQLFieldDefinition> getFieldDefinitions() {
        return new ArrayList<GraphQLFieldDefinition>(this.fieldDefinitionsByName.values());
    }

    public List<GraphQLOutputType> getInterfaces() {
        return new ArrayList<GraphQLOutputType>(this.interfaces);
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ObjectTypeDefinition getDefinition() {
        return this.definition;
    }

    public String toString() {
        return "GraphQLObjectType{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", fieldDefinitionsByName=" + this.fieldDefinitionsByName.keySet() + ", interfaces=" + this.interfaces + '}';
    }

    public GraphQLObjectType transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLObjectType.newObject(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    @Override
    public TraversalControl accept(TraverserContext<GraphQLType> context, GraphQLTypeVisitor visitor) {
        return visitor.visitGraphQLObjectType(this, context);
    }

    @Override
    public List<GraphQLType> getChildren() {
        ArrayList<GraphQLType> children = new ArrayList<GraphQLType>(this.fieldDefinitionsByName.values());
        children.addAll(this.interfaces);
        children.addAll(this.directives);
        return children;
    }

    public static Builder newObject() {
        return new Builder();
    }

    public static Builder newObject(GraphQLObjectType existing) {
        return new Builder(existing);
    }

    @PublicApi
    public static class Builder
    extends GraphqlTypeBuilder {
        private ObjectTypeDefinition definition;
        private final Map<String, GraphQLFieldDefinition> fields = new LinkedHashMap<String, GraphQLFieldDefinition>();
        private final Map<String, GraphQLOutputType> interfaces = new LinkedHashMap<String, GraphQLOutputType>();
        private final Map<String, GraphQLDirective> directives = new LinkedHashMap<String, GraphQLDirective>();

        public Builder() {
        }

        public Builder(GraphQLObjectType existing) {
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.definition = existing.getDefinition();
            this.fields.putAll(FpKit.getByName(existing.getFieldDefinitions(), GraphQLFieldDefinition::getName));
            this.interfaces.putAll(FpKit.getByName(existing.getInterfaces(), GraphQLType::getName));
            this.directives.putAll(FpKit.getByName(existing.getDirectives(), GraphQLDirective::getName));
        }

        @Override
        public Builder name(String name) {
            super.name(name);
            return this;
        }

        @Override
        public Builder description(String description) {
            super.description(description);
            return this;
        }

        @Override
        public Builder comparatorRegistry(GraphqlTypeComparatorRegistry comparatorRegistry) {
            super.comparatorRegistry(comparatorRegistry);
            return this;
        }

        public Builder definition(ObjectTypeDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder field(GraphQLFieldDefinition fieldDefinition) {
            Assert.assertNotNull(fieldDefinition, "fieldDefinition can't be null", new Object[0]);
            this.fields.put(fieldDefinition.getName(), fieldDefinition);
            return this;
        }

        public Builder field(UnaryOperator<GraphQLFieldDefinition.Builder> builderFunction) {
            Assert.assertNotNull(builderFunction, "builderFunction can't be null", new Object[0]);
            GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
            builder = (GraphQLFieldDefinition.Builder)builderFunction.apply(builder);
            return this.field(builder.build());
        }

        public Builder field(GraphQLFieldDefinition.Builder builder) {
            return this.field(builder.build());
        }

        public Builder fields(List<GraphQLFieldDefinition> fieldDefinitions) {
            Assert.assertNotNull(fieldDefinitions, "fieldDefinitions can't be null", new Object[0]);
            fieldDefinitions.forEach(this::field);
            return this;
        }

        public Builder clearFields() {
            this.fields.clear();
            return this;
        }

        public boolean hasField(String fieldName) {
            return this.fields.containsKey(fieldName);
        }

        public Builder withInterface(GraphQLInterfaceType interfaceType) {
            Assert.assertNotNull(interfaceType, "interfaceType can't be null", new Object[0]);
            this.interfaces.put(interfaceType.getName(), interfaceType);
            return this;
        }

        public Builder withInterface(GraphQLTypeReference reference) {
            Assert.assertNotNull(reference, "reference can't be null", new Object[0]);
            this.interfaces.put(reference.getName(), reference);
            return this;
        }

        public Builder withInterfaces(GraphQLInterfaceType ... interfaceType) {
            for (GraphQLInterfaceType type : interfaceType) {
                this.withInterface(type);
            }
            return this;
        }

        public Builder withInterfaces(GraphQLTypeReference ... references) {
            for (GraphQLTypeReference reference : references) {
                this.withInterface(reference);
            }
            return this;
        }

        public Builder clearInterfaces() {
            this.interfaces.clear();
            return this;
        }

        public Builder withDirectives(GraphQLDirective ... directives) {
            for (GraphQLDirective directive : directives) {
                this.withDirective(directive);
            }
            return this;
        }

        public Builder withDirective(GraphQLDirective directive) {
            Assert.assertNotNull(directive, "directive can't be null", new Object[0]);
            this.directives.put(directive.getName(), directive);
            return this;
        }

        public Builder withDirective(GraphQLDirective.Builder builder) {
            return this.withDirective(builder.build());
        }

        public Builder clearDirectives() {
            this.directives.clear();
            return this;
        }

        public GraphQLObjectType build() {
            return new GraphQLObjectType(this.name, this.description, this.sort(this.fields, GraphQLObjectType.class, GraphQLFieldDefinition.class), FpKit.valuesToList(this.interfaces), this.sort(this.directives, GraphQLObjectType.class, GraphQLDirective.class), this.definition, this.getComparator(GraphQLObjectType.class, GraphQLInterfaceType.class));
        }
    }
}

