/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.nextgen;

import graphql.Internal;
import graphql.execution.Async;
import graphql.execution.ExecutionContext;
import graphql.execution.nextgen.ExecutionStrategy;
import graphql.execution.nextgen.ExecutionStrategyUtil;
import graphql.execution.nextgen.FetchedValueAnalysis;
import graphql.execution.nextgen.FieldSubSelection;
import graphql.execution.nextgen.result.ExecutionResultNode;
import graphql.execution.nextgen.result.ObjectExecutionResultNode;
import graphql.execution.nextgen.result.ResultNodesUtil;
import graphql.execution.nextgen.result.RootExecutionResultNode;
import graphql.util.FpKit;
import graphql.util.NodeMultiZipper;
import graphql.util.NodeZipper;
import java.util.List;
import java.util.concurrent.CompletableFuture;

@Internal
public class DefaultExecutionStrategy
implements ExecutionStrategy {
    ExecutionStrategyUtil util = new ExecutionStrategyUtil();

    @Override
    public CompletableFuture<RootExecutionResultNode> execute(ExecutionContext context, FieldSubSelection fieldSubSelection) {
        return this.resolveSubSelection(context, fieldSubSelection).thenApply(RootExecutionResultNode::new);
    }

    private CompletableFuture<List<ExecutionResultNode>> resolveSubSelection(ExecutionContext executionContext, FieldSubSelection fieldSubSelection) {
        List namedNodesCFList = Async.mapCompose(this.util.fetchSubSelection(executionContext, fieldSubSelection), node -> this.resolveAllChildNodes(executionContext, (ExecutionResultNode)node));
        return Async.each(namedNodesCFList);
    }

    private CompletableFuture<ExecutionResultNode> resolveAllChildNodes(ExecutionContext context, ExecutionResultNode node) {
        NodeMultiZipper<ExecutionResultNode> unresolvedNodes = ResultNodesUtil.getUnresolvedNodes(node);
        List<CompletableFuture<NodeZipper<ExecutionResultNode>>> resolvedNodes = FpKit.map(unresolvedNodes.getZippers(), unresolvedNode -> this.resolveNode(context, (NodeZipper<ExecutionResultNode>)unresolvedNode));
        return this.resolvedNodesToResultNode(unresolvedNodes, resolvedNodes);
    }

    private CompletableFuture<NodeZipper<ExecutionResultNode>> resolveNode(ExecutionContext executionContext, NodeZipper<ExecutionResultNode> unresolvedNode) {
        FetchedValueAnalysis fetchedValueAnalysis = unresolvedNode.getCurNode().getFetchedValueAnalysis();
        FieldSubSelection fieldSubSelection = this.util.createFieldSubSelection(executionContext, fetchedValueAnalysis);
        return this.resolveSubSelection(executionContext, fieldSubSelection).thenApply(resolvedChildMap -> unresolvedNode.withNewNode(new ObjectExecutionResultNode(fetchedValueAnalysis, (List<ExecutionResultNode>)resolvedChildMap)));
    }

    private CompletableFuture<ExecutionResultNode> resolvedNodesToResultNode(NodeMultiZipper<ExecutionResultNode> unresolvedNodes, List<CompletableFuture<NodeZipper<ExecutionResultNode>>> resolvedNodes) {
        return ((CompletableFuture)Async.each(resolvedNodes).thenApply(unresolvedNodes::withReplacedZippers)).thenApply(NodeMultiZipper::toRootNode);
    }
}

