/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.directives;

import graphql.Internal;
import graphql.execution.MergedField;
import graphql.execution.directives.DirectivesResolver;
import graphql.execution.directives.QueryDirectives;
import graphql.language.Directive;
import graphql.language.Field;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLSchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Internal
public class QueryDirectivesImpl
implements QueryDirectives {
    private final DirectivesResolver directivesResolver = new DirectivesResolver();
    private final MergedField mergedField;
    private final GraphQLSchema schema;
    private final Map<String, Object> variables;
    private volatile Map<Field, List<GraphQLDirective>> fieldDirectivesByField;
    private volatile Map<String, List<GraphQLDirective>> fieldDirectivesByName;

    public QueryDirectivesImpl(MergedField mergedField, GraphQLSchema schema, Map<String, Object> variables) {
        this.mergedField = mergedField;
        this.schema = schema;
        this.variables = variables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeValuesLazily() {
        QueryDirectivesImpl queryDirectivesImpl = this;
        synchronized (queryDirectivesImpl) {
            if (this.fieldDirectivesByField != null) {
                return;
            }
            LinkedHashMap<Field, List> byField = new LinkedHashMap<Field, List>();
            this.mergedField.getFields().forEach(field -> {
                List<Directive> directives = field.getDirectives();
                ArrayList<GraphQLDirective> resolvedDirectives = new ArrayList<GraphQLDirective>(this.directivesResolver.resolveDirectives(directives, this.schema, this.variables).values());
                byField.put((Field)field, Collections.unmodifiableList(resolvedDirectives));
            });
            LinkedHashMap byName = new LinkedHashMap();
            byField.forEach((field, directiveList) -> directiveList.forEach(directive -> {
                String name = directive.getName();
                byName.computeIfAbsent(name, k -> new ArrayList());
                ((List)byName.get(name)).add(directive);
            }));
            this.fieldDirectivesByName = Collections.unmodifiableMap(byName);
            this.fieldDirectivesByField = Collections.unmodifiableMap(byField);
        }
    }

    @Override
    public Map<Field, List<GraphQLDirective>> getImmediateDirectivesByField() {
        this.computeValuesLazily();
        return this.fieldDirectivesByField;
    }

    @Override
    public Map<String, List<GraphQLDirective>> getImmediateDirectivesByName() {
        this.computeValuesLazily();
        return this.fieldDirectivesByName;
    }

    @Override
    public List<GraphQLDirective> getImmediateDirective(String directiveName) {
        this.computeValuesLazily();
        return this.getImmediateDirectivesByName().getOrDefault(directiveName, Collections.emptyList());
    }
}

