/*
 * Decompiled with CFR 0.152.
 */
package graphql.analysis;

import graphql.Assert;
import graphql.PublicApi;
import graphql.analysis.NodeVisitorWithTypeTracking;
import graphql.analysis.QueryTraversalContext;
import graphql.analysis.QueryVisitor;
import graphql.analysis.QueryVisitorStub;
import graphql.language.AstNodeAdapter;
import graphql.language.FragmentDefinition;
import graphql.language.Node;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLSchema;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.util.TraverserVisitor;
import graphql.util.TreeTransformer;
import java.util.LinkedHashMap;
import java.util.Map;

@PublicApi
public class QueryTransformer {
    private final Node root;
    private final GraphQLSchema schema;
    private final Map<String, FragmentDefinition> fragmentsByName;
    private final Map<String, Object> variables;
    private final GraphQLCompositeType rootParentType;

    private QueryTransformer(GraphQLSchema schema, Node root, GraphQLCompositeType rootParentType, Map<String, FragmentDefinition> fragmentsByName, Map<String, Object> variables) {
        this.schema = Assert.assertNotNull(schema, "schema can't be null", new Object[0]);
        this.variables = Assert.assertNotNull(variables, "variables can't be null", new Object[0]);
        this.root = Assert.assertNotNull(root, "root can't be null", new Object[0]);
        this.rootParentType = Assert.assertNotNull(rootParentType);
        this.fragmentsByName = Assert.assertNotNull(fragmentsByName, "fragmentsByName can't be null", new Object[0]);
    }

    public Node transform(QueryVisitor queryVisitor) {
        QueryVisitorStub noOp = new QueryVisitorStub();
        final NodeVisitorWithTypeTracking nodeVisitor = new NodeVisitorWithTypeTracking(queryVisitor, noOp, this.variables, this.schema, this.fragmentsByName);
        LinkedHashMap rootVars = new LinkedHashMap();
        rootVars.put(QueryTraversalContext.class, new QueryTraversalContext(this.rootParentType, null, null));
        TraverserVisitor<Node> nodeTraverserVisitor = new TraverserVisitor<Node>(){

            @Override
            public TraversalControl enter(TraverserContext<Node> context) {
                return context.thisNode().accept(context, nodeVisitor);
            }

            @Override
            public TraversalControl leave(TraverserContext<Node> context) {
                return TraversalControl.CONTINUE;
            }
        };
        return new TreeTransformer<Node>(AstNodeAdapter.AST_NODE_ADAPTER).transform(this.root, nodeTraverserVisitor, rootVars);
    }

    public static Builder newQueryTransformer() {
        return new Builder();
    }

    @PublicApi
    public static class Builder {
        private GraphQLSchema schema;
        private Map<String, Object> variables;
        private Node root;
        private GraphQLCompositeType rootParentType;
        private Map<String, FragmentDefinition> fragmentsByName;

        public Builder schema(GraphQLSchema schema) {
            this.schema = schema;
            return this;
        }

        public Builder variables(Map<String, Object> variables) {
            this.variables = variables;
            return this;
        }

        public Builder root(Node root) {
            this.root = root;
            return this;
        }

        public Builder rootParentType(GraphQLCompositeType rootParentType) {
            this.rootParentType = rootParentType;
            return this;
        }

        public Builder fragmentsByName(Map<String, FragmentDefinition> fragmentsByName) {
            this.fragmentsByName = fragmentsByName;
            return this;
        }

        public QueryTransformer build() {
            return new QueryTransformer(this.schema, this.root, this.rootParentType, this.fragmentsByName, this.variables);
        }
    }
}

