/*
 * Decompiled with CFR 0.152.
 */
package manifold.templates.rt.sparkjava;

import manifold.rt.api.util.ManEscapeUtil;
import manifold.templates.rt.runtime.BaseTemplate;
import spark.Filter;
import spark.Request;
import spark.Response;
import spark.Spark;

public abstract class SparkTemplate
extends BaseTemplate {
    private static ThreadLocal<Request> REQUEST = new ThreadLocal();
    private static ThreadLocal<Response> RESPONSE = new ThreadLocal();

    public static void init() {
        Spark.before((Filter[])new Filter[]{(request, response) -> {
            REQUEST.set(request);
            RESPONSE.set(response);
        }});
        Spark.afterAfter((request, response) -> {
            REQUEST.set(null);
            RESPONSE.set(null);
        });
    }

    public Response getResponse() {
        return RESPONSE.get();
    }

    public Request getRequest() {
        return REQUEST.get();
    }

    @Override
    public String toS(Object o) {
        if (o instanceof RawObject) {
            return super.toS(o.toString());
        }
        if (o == null) {
            return "";
        }
        return this.escapeHTML(o.toString());
    }

    private String escapeHTML(String str) {
        return ManEscapeUtil.escapeForHTML(str, false);
    }

    public Object raw(Object o) {
        return new RawObject(o);
    }

    private static class RawObject {
        private final Object in;

        RawObject(Object in) {
            this.in = in;
        }

        public String toString() {
            return this.in.toString();
        }
    }
}

