/*
 * Decompiled with CFR 0.152.
 */
package graphql.util;

import graphql.Assert;
import graphql.PublicApi;
import graphql.util.Breadcrumb;
import graphql.util.FpKit;
import graphql.util.NodeAdapter;
import graphql.util.NodeLocation;
import graphql.util.NodeZipper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@PublicApi
public class NodeMultiZipper<T> {
    private final T commonRoot;
    private final List<NodeZipper<T>> zippers;
    private final NodeAdapter<T> nodeAdapter;

    public NodeMultiZipper(T commonRoot, List<NodeZipper<T>> zippers, NodeAdapter<T> nodeAdapter) {
        this.commonRoot = Assert.assertNotNull(commonRoot);
        this.zippers = new ArrayList<NodeZipper<T>>(zippers);
        this.nodeAdapter = nodeAdapter;
    }

    public T toRootNode() {
        if (this.zippers.size() == 0) {
            return this.commonRoot;
        }
        ArrayList<NodeZipper<T>> curZippers = new ArrayList<NodeZipper<T>>(this.zippers);
        while (curZippers.size() > 1) {
            List<NodeZipper<T>> deepestZippers = this.getDeepestZippers(curZippers);
            Map<T, List<NodeZipper<T>>> sameParent = this.zipperWithSameParent(deepestZippers);
            ArrayList<NodeZipper<T>> newZippers = new ArrayList<NodeZipper<T>>();
            for (Map.Entry entry : sameParent.entrySet()) {
                NodeZipper<T> newZipper = this.moveUp(entry.getKey(), entry.getValue());
                Optional<NodeZipper> zipperToBeReplaced = curZippers.stream().filter(zipper -> zipper.getCurNode() == entry.getKey()).findFirst();
                zipperToBeReplaced.ifPresent(curZippers::remove);
                newZippers.add(newZipper);
            }
            curZippers.removeAll(deepestZippers);
            curZippers.addAll(newZippers);
        }
        Assert.assertTrue(curZippers.size() == 1, "unexpected state: all zippers must share the same root node", new Object[0]);
        return ((NodeZipper)curZippers.get(0)).toRoot();
    }

    public T getCommonRoot() {
        return this.commonRoot;
    }

    public List<NodeZipper<T>> getZippers() {
        return new ArrayList<NodeZipper<T>>(this.zippers);
    }

    public NodeZipper<T> getZipperForNode(T node) {
        return FpKit.findOneOrNull(this.zippers, zipper -> zipper.getCurNode() == node);
    }

    public NodeMultiZipper<T> withReplacedZippers(List<NodeZipper<T>> zippers) {
        return new NodeMultiZipper<T>(this.commonRoot, zippers, this.nodeAdapter);
    }

    public NodeMultiZipper<T> withNewZipper(NodeZipper<T> newZipper) {
        List<NodeZipper<T>> newZippers = this.getZippers();
        newZippers.add(newZipper);
        return new NodeMultiZipper<T>(this.commonRoot, newZippers, this.nodeAdapter);
    }

    public NodeMultiZipper<T> withReplacedZipper(NodeZipper<T> oldZipper, NodeZipper<T> newZipper) {
        int index = this.zippers.indexOf(oldZipper);
        Assert.assertTrue(index >= 0, "oldZipper not found", new Object[0]);
        ArrayList<NodeZipper<T>> newZippers = new ArrayList<NodeZipper<T>>(this.zippers);
        newZippers.set(index, newZipper);
        return new NodeMultiZipper<T>(this.commonRoot, newZippers, this.nodeAdapter);
    }

    public NodeMultiZipper<T> withReplacedZipperForNode(T currentNode, T newNode) {
        int index = FpKit.findIndex(this.zippers, zipper -> zipper.getCurNode() == currentNode);
        Assert.assertTrue(index >= 0, "No current zipper found for provided node", new Object[0]);
        NodeZipper<T> newZipper = this.zippers.get(index).withNewNode(newNode);
        ArrayList<NodeZipper<T>> newZippers = new ArrayList<NodeZipper<T>>(this.zippers);
        newZippers.set(index, newZipper);
        return new NodeMultiZipper<T>(this.commonRoot, newZippers, this.nodeAdapter);
    }

    private List<NodeZipper<T>> getDeepestZippers(List<NodeZipper<T>> zippers) {
        Map<Integer, List<NodeZipper>> grouped = FpKit.groupingBy(zippers, astZipper -> astZipper.getBreadcrumbs().size());
        Integer maxLevel = Collections.max(grouped.keySet());
        return grouped.get(maxLevel);
    }

    private NodeZipper<T> moveUp(T parent, List<NodeZipper<T>> sameParent) {
        Assert.assertNotEmpty(sameParent, "expected at least one zipper", new Object[0]);
        Map<String, List<T>> childrenMap = this.nodeAdapter.getNamedChildren(parent);
        LinkedHashMap<String, Integer> indexCorrection = new LinkedHashMap<String, Integer>();
        sameParent.sort((zipper1, zipper2) -> {
            NodeZipper.ModificationType modificationType2;
            int index2;
            int index1 = zipper1.getBreadcrumbs().get(0).getLocation().getIndex();
            if (index1 != (index2 = zipper2.getBreadcrumbs().get(0).getLocation().getIndex())) {
                return Integer.compare(index1, index2);
            }
            NodeZipper.ModificationType modificationType1 = zipper1.getModificationType();
            if (modificationType1 == (modificationType2 = zipper2.getModificationType())) {
                return 0;
            }
            if (modificationType1 == NodeZipper.ModificationType.REPLACE) {
                return -1;
            }
            return modificationType1 == NodeZipper.ModificationType.INSERT_BEFORE ? -1 : 1;
        });
        for (NodeZipper<T> zipper : sameParent) {
            NodeLocation location = zipper.getBreadcrumbs().get(0).getLocation();
            Integer ixDiff = indexCorrection.getOrDefault(location.getName(), 0);
            int ix = location.getIndex() + ixDiff;
            String name = location.getName();
            switch (zipper.getModificationType()) {
                case REPLACE: {
                    childrenMap.get(name).set(ix, zipper.getCurNode());
                    break;
                }
                case DELETE: {
                    childrenMap.get(name).remove(ix);
                    indexCorrection.put(name, ixDiff - 1);
                    break;
                }
                case INSERT_BEFORE: {
                    childrenMap.get(name).add(ix, zipper.getCurNode());
                    indexCorrection.put(name, ixDiff + 1);
                    break;
                }
                case INSERT_AFTER: {
                    childrenMap.get(name).add(ix + 1, zipper.getCurNode());
                    indexCorrection.put(name, ixDiff + 1);
                }
            }
        }
        T newNode = this.nodeAdapter.withNewChildren(parent, childrenMap);
        List<Breadcrumb<T>> newBreadcrumbs = sameParent.get(0).getBreadcrumbs().subList(1, sameParent.get(0).getBreadcrumbs().size());
        return new NodeZipper<T>(newNode, newBreadcrumbs, this.nodeAdapter);
    }

    private Map<T, List<NodeZipper<T>>> zipperWithSameParent(List<NodeZipper<T>> zippers) {
        return FpKit.groupingBy(zippers, NodeZipper::getParent);
    }
}

