/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl.errors;

import graphql.language.EnumValueDefinition;
import graphql.language.FieldDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.TypeDefinition;
import graphql.schema.idl.errors.BaseError;

public class NonUniqueArgumentError
extends BaseError {
    public NonUniqueArgumentError(TypeDefinition typeDefinition, FieldDefinition fieldDefinition, String argumentName) {
        super(typeDefinition, String.format("The type '%s' with field '%s' %s has declared an argument with a non unique name '%s'", typeDefinition.getName(), fieldDefinition.getName(), NonUniqueArgumentError.lineCol(typeDefinition), argumentName));
    }

    public NonUniqueArgumentError(TypeDefinition typeDefinition, InputValueDefinition inputValueDefinition, String argumentName) {
        super(typeDefinition, String.format("The type '%s' with input value '%s' %s has declared an argument with a non unique name '%s'", typeDefinition.getName(), inputValueDefinition.getName(), NonUniqueArgumentError.lineCol(typeDefinition), argumentName));
    }

    public NonUniqueArgumentError(TypeDefinition typeDefinition, EnumValueDefinition enumValueDefinition, String argumentName) {
        super(typeDefinition, String.format("The '%s' type with enum value '%s' %s has declared an argument with a non unique name '%s'", typeDefinition.getName(), enumValueDefinition.getName(), NonUniqueArgumentError.lineCol(typeDefinition), argumentName));
    }
}

