/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Internal;
import graphql.introspection.Introspection;
import graphql.schema.CodeRegistryVisitor;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeCollectingVisitor;
import graphql.schema.GraphQLTypeResolvingVisitor;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.TypeTraverser;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Internal
public class SchemaUtil {
    private static final TypeTraverser TRAVERSER = new TypeTraverser();

    Map<String, GraphQLType> allTypes(GraphQLSchema schema, Set<GraphQLType> additionalTypes) {
        ArrayList<GraphQLType> roots = new ArrayList<GraphQLType>();
        roots.add(schema.getQueryType());
        if (schema.isSupportingMutations()) {
            roots.add(schema.getMutationType());
        }
        if (schema.isSupportingSubscriptions()) {
            roots.add(schema.getSubscriptionType());
        }
        if (additionalTypes != null) {
            roots.addAll(additionalTypes);
        }
        if (schema.getDirectives() != null) {
            roots.addAll(schema.getDirectives());
        }
        roots.add(Introspection.__Schema);
        GraphQLTypeCollectingVisitor visitor = new GraphQLTypeCollectingVisitor();
        TRAVERSER.depthFirst((GraphQLTypeVisitor)visitor, roots);
        return visitor.getResult();
    }

    Map<String, List<GraphQLObjectType>> groupImplementations(GraphQLSchema schema) {
        LinkedHashMap<String, List<GraphQLObjectType>> result = new LinkedHashMap<String, List<GraphQLObjectType>>();
        for (GraphQLType type : schema.getAllTypesAsList()) {
            if (!(type instanceof GraphQLObjectType)) continue;
            for (GraphQLOutputType interfaceType : ((GraphQLObjectType)type).getInterfaces()) {
                List myGroup = result.computeIfAbsent(interfaceType.getName(), k -> new ArrayList());
                myGroup.add((GraphQLObjectType)type);
            }
        }
        return result;
    }

    @Deprecated
    public List<GraphQLObjectType> findImplementations(GraphQLSchema schema, GraphQLInterfaceType interfaceType) {
        ArrayList<GraphQLObjectType> result = new ArrayList<GraphQLObjectType>();
        for (GraphQLType type : schema.getAllTypesAsList()) {
            GraphQLObjectType objectType;
            if (!(type instanceof GraphQLObjectType) || !(objectType = (GraphQLObjectType)type).getInterfaces().contains(interfaceType)) continue;
            result.add(objectType);
        }
        return result;
    }

    void replaceTypeReferences(GraphQLSchema schema) {
        Map<String, GraphQLType> typeMap = schema.getTypeMap();
        ArrayList<GraphQLType> roots = new ArrayList<GraphQLType>(typeMap.values());
        roots.addAll(schema.getDirectives());
        TRAVERSER.depthFirst((GraphQLTypeVisitor)new GraphQLTypeResolvingVisitor(typeMap), roots);
    }

    void extractCodeFromTypes(GraphQLCodeRegistry.Builder codeRegistry, GraphQLSchema schema) {
        Introspection.addCodeForIntrospectionTypes(codeRegistry);
        TRAVERSER.depthFirst((GraphQLTypeVisitor)new CodeRegistryVisitor(codeRegistry), schema.getAllTypesAsList());
    }
}

