/*
 * Decompiled with CFR 0.152.
 */
package graphql.util;

import graphql.Internal;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

@Internal
public class FpKit {
    public static <T> Map<String, T> getByName(List<T> namedObjects, Function<T, String> nameFn, BinaryOperator<T> mergeFunc) {
        return namedObjects.stream().collect(Collectors.toMap(nameFn, Function.identity(), mergeFunc, LinkedHashMap::new));
    }

    public static <T, NewKey> Map<NewKey, List<T>> groupingBy(List<T> list, Function<T, NewKey> function) {
        return list.stream().collect(Collectors.groupingBy(function, LinkedHashMap::new, Collectors.mapping(Function.identity(), Collectors.toList())));
    }

    public static <T> Map<String, T> getByName(List<T> namedObjects, Function<T, String> nameFn) {
        return FpKit.getByName(namedObjects, nameFn, FpKit.mergeFirst());
    }

    public static <T> BinaryOperator<T> mergeFirst() {
        return (o1, o2) -> o1;
    }

    public static <T> Collection<T> toCollection(Object iterableResult) {
        if (iterableResult.getClass().isArray()) {
            List collect = IntStream.range(0, Array.getLength(iterableResult)).mapToObj(i -> Array.get(iterableResult, i)).collect(Collectors.toList());
            return collect;
        }
        if (iterableResult instanceof Collection) {
            return (Collection)iterableResult;
        }
        Iterable iterable = (Iterable)iterableResult;
        Iterator iterator = iterable.iterator();
        ArrayList list = new ArrayList();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static <T> List<T> concat(List<T> l, T t) {
        return FpKit.concat(l, Collections.singletonList(t));
    }

    public static <T> List<T> concat(List<T> l1, List<T> l2) {
        ArrayList<T> l = new ArrayList<T>(l1);
        l.addAll(l2);
        l.trimToSize();
        return l;
    }

    public static <T> List<T> valuesToList(Map<?, T> map) {
        return new ArrayList<T>(map.values());
    }

    public static <T, U> List<U> map(List<T> list, Function<T, U> function) {
        return list.stream().map(function).collect(Collectors.toList());
    }

    public static <K, V, U> List<U> mapEntries(Map<K, V> map, BiFunction<K, V, U> function) {
        return map.entrySet().stream().map(entry -> function.apply(entry.getKey(), entry.getValue())).collect(Collectors.toList());
    }

    public static <T> List<List<T>> transposeMatrix(List<? extends List<T>> matrix) {
        int rowCount = matrix.size();
        int colCount = matrix.get(0).size();
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                T val2 = matrix.get(i).get(j);
                if (result.size() <= j) {
                    result.add(j, new ArrayList());
                }
                ((List)result.get(j)).add(i, val2);
            }
        }
        return result;
    }

    public static <T> CompletableFuture<List<T>> flatList(CompletableFuture<List<List<T>>> cf) {
        return cf.thenApply(FpKit::flatList);
    }

    public static <T> List<T> flatList(List<List<T>> listLists) {
        return listLists.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static <T> Optional<T> findOne(List<T> list, Predicate<T> filter) {
        return list.stream().filter(filter).findFirst();
    }

    public static <T> T findOneOrNull(List<T> list, Predicate<T> filter) {
        return FpKit.findOne(list, filter).orElse(null);
    }

    public static <T> int findIndex(List<T> list, Predicate<T> filter) {
        for (int i = 0; i < list.size(); ++i) {
            if (!filter.test(list.get(i))) continue;
            return i;
        }
        return -1;
    }
}

