/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.validation;

import graphql.Internal;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.validation.NoUnbrokenInputCycles;
import graphql.schema.validation.ObjectsImplementInterfaces;
import graphql.schema.validation.SchemaValidationError;
import graphql.schema.validation.SchemaValidationErrorCollector;
import graphql.schema.validation.SchemaValidationRule;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@Internal
public class SchemaValidator {
    private final Set<GraphQLOutputType> processed = new LinkedHashSet<GraphQLOutputType>();
    private List<SchemaValidationRule> rules = new ArrayList<SchemaValidationRule>();

    public SchemaValidator() {
        this.rules.add(new NoUnbrokenInputCycles());
        this.rules.add(new ObjectsImplementInterfaces());
    }

    SchemaValidator(List<SchemaValidationRule> rules) {
        this.rules = rules;
    }

    public List<SchemaValidationRule> getRules() {
        return this.rules;
    }

    public Set<SchemaValidationError> validateSchema(GraphQLSchema schema) {
        SchemaValidationErrorCollector validationErrorCollector = new SchemaValidationErrorCollector();
        this.checkTypes(schema, validationErrorCollector);
        this.traverse(schema.getQueryType(), this.rules, validationErrorCollector);
        if (schema.isSupportingMutations()) {
            this.traverse(schema.getMutationType(), this.rules, validationErrorCollector);
        }
        if (schema.isSupportingSubscriptions()) {
            this.traverse(schema.getSubscriptionType(), this.rules, validationErrorCollector);
        }
        return validationErrorCollector.getErrors();
    }

    private void checkTypes(GraphQLSchema schema, SchemaValidationErrorCollector validationErrorCollector) {
        List<GraphQLType> types = schema.getAllTypesAsList();
        types.forEach(type -> {
            for (SchemaValidationRule rule : this.rules) {
                rule.check((GraphQLType)type, validationErrorCollector);
            }
        });
    }

    private void traverse(GraphQLOutputType root, List<SchemaValidationRule> rules, SchemaValidationErrorCollector validationErrorCollector) {
        if (this.processed.contains(root)) {
            return;
        }
        this.processed.add(root);
        if (root instanceof GraphQLFieldsContainer) {
            for (GraphQLFieldDefinition fieldDefinition : ((GraphQLFieldsContainer)root).getFieldDefinitions()) {
                for (SchemaValidationRule rule : rules) {
                    rule.check(fieldDefinition, validationErrorCollector);
                }
                this.traverse(fieldDefinition.getType(), rules, validationErrorCollector);
            }
        }
    }
}

