/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.GraphqlErrorHelper;
import graphql.language.SourceLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InvalidSyntaxError
implements GraphQLError {
    private final String message;
    private final String sourcePreview;
    private final String offendingToken;
    private final List<SourceLocation> locations = new ArrayList<SourceLocation>();

    public InvalidSyntaxError(SourceLocation sourceLocation, String msg) {
        this(Collections.singletonList(sourceLocation), msg);
    }

    public InvalidSyntaxError(List<SourceLocation> sourceLocations, String msg) {
        this(sourceLocations, msg, null, null);
    }

    public InvalidSyntaxError(List<SourceLocation> sourceLocations, String msg, String sourcePreview, String offendingToken) {
        this.message = msg;
        this.sourcePreview = sourcePreview;
        this.offendingToken = offendingToken;
        if (sourceLocations != null) {
            this.locations.addAll(sourceLocations);
        }
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public List<SourceLocation> getLocations() {
        return this.locations;
    }

    public String getSourcePreview() {
        return this.sourcePreview;
    }

    public String getOffendingToken() {
        return this.offendingToken;
    }

    @Override
    public ErrorType getErrorType() {
        return ErrorType.InvalidSyntax;
    }

    public String toString() {
        return "InvalidSyntaxError{ message=" + this.message + " ,offendingToken=" + this.offendingToken + " ,locations=" + this.locations + " ,sourcePreview=" + this.sourcePreview + '}';
    }

    public boolean equals(Object o) {
        return GraphqlErrorHelper.equals(this, o);
    }

    public int hashCode() {
        return GraphqlErrorHelper.hashCode(this);
    }
}

