/*
 * Decompiled with CFR 0.152.
 */
package manifold.shade.org.dataloader.stats;

import java.util.concurrent.atomic.AtomicLong;
import manifold.shade.org.dataloader.stats.Statistics;
import manifold.shade.org.dataloader.stats.StatisticsCollector;

public class SimpleStatisticsCollector
implements StatisticsCollector {
    private final AtomicLong loadCount = new AtomicLong();
    private final AtomicLong batchInvokeCount = new AtomicLong();
    private final AtomicLong batchLoadCount = new AtomicLong();
    private final AtomicLong cacheHitCount = new AtomicLong();
    private final AtomicLong batchLoadExceptionCount = new AtomicLong();
    private final AtomicLong loadErrorCount = new AtomicLong();

    @Override
    public long incrementLoadCount() {
        return this.loadCount.incrementAndGet();
    }

    @Override
    public long incrementBatchLoadCountBy(long delta) {
        this.batchInvokeCount.incrementAndGet();
        return this.batchLoadCount.addAndGet(delta);
    }

    @Override
    public long incrementCacheHitCount() {
        return this.cacheHitCount.incrementAndGet();
    }

    @Override
    public long incrementLoadErrorCount() {
        return this.loadErrorCount.incrementAndGet();
    }

    @Override
    public long incrementBatchLoadExceptionCount() {
        return this.batchLoadExceptionCount.incrementAndGet();
    }

    @Override
    public Statistics getStatistics() {
        return new Statistics(this.loadCount.get(), this.loadErrorCount.get(), this.batchInvokeCount.get(), this.batchLoadCount.get(), this.batchLoadExceptionCount.get(), this.cacheHitCount.get());
    }

    public String toString() {
        return this.getStatistics().toString();
    }
}

