/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext.rt.extensions.manifold.rt.api.Array;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import manifold.ext.rt.api.Extension;
import manifold.ext.rt.api.IndexedConsumer;
import manifold.ext.rt.api.Self;
import manifold.ext.rt.api.This;

@Extension
public class ManArrayExt {
    public static List<@Self(value=true) Object> toList(@This Object array) {
        if (array.getClass().getComponentType().isPrimitive()) {
            int len = Array.getLength(array);
            ArrayList<Object> list = new ArrayList<Object>(len);
            for (int i = 0; i < len; ++i) {
                list.add(Array.get(array, i));
            }
            return list;
        }
        return Arrays.asList((Object[])array);
    }

    public static boolean isEmpty(@This Object array) {
        return Array.getLength(array) == 0;
    }

    public static boolean isNullOrEmpty(@This Object array) {
        return array == null || ManArrayExt.isEmpty(array);
    }

    @Self
    public static Object copy(@This Object array) {
        return ManArrayExt.copy(array, -1);
    }

    @Self
    public static Object copy(@This Object array, int newLength) {
        int length = Array.getLength(array);
        Object dest = Array.newInstance(array.getClass().getComponentType(), newLength < 0 ? length : newLength);
        System.arraycopy(array, 0, dest, 0, length);
        return dest;
    }

    @Self
    public static Object copyTo(@This Object array, @Self Object to) {
        System.arraycopy(array, 0, to, 0, Array.getLength(array));
        return to;
    }

    @Self
    public static Object copyRange(@This Object array, int from, int to) {
        int length = Array.getLength(array);
        to = to < 0 ? length : to;
        Object dest = Array.newInstance(array.getClass().getComponentType(), to - from);
        System.arraycopy(array, from, dest, 0, to - from);
        return dest;
    }

    @Self
    public static Object copyRangeTo(@This Object array, int from, int to, @Self Object target, int targetIndex) {
        to = to < 0 ? Array.getLength(array) : to;
        System.arraycopy(array, from, target, targetIndex, to - from);
        return target;
    }

    public static Stream<@Self(value=true) Object> stream(@This Object array) {
        ManArrayExt.primitiveCheck(array);
        return Arrays.stream((Object[])array, 0, Array.getLength(array));
    }

    public static void forEach(@This Object array, IndexedConsumer<? super @Self(value=true) Object> action) {
        ManArrayExt.primitiveCheck(array);
        Objects.requireNonNull(action);
        Object[] objects = (Object[])array;
        for (int i = 0; i < objects.length; ++i) {
            Object e = objects[i];
            action.accept(i, e);
        }
    }

    public static Spliterator<@Self(value=true) Object> spliterator(@This Object array) {
        ManArrayExt.primitiveCheck(array);
        return Spliterators.spliterator((Object[])array, 1040);
    }

    private static void primitiveCheck(Object array) {
        Class<?> componentType = array.getClass().getComponentType();
        if (componentType.isPrimitive()) {
            throw new IllegalArgumentException(array + " has a primitive component type: " + array.getClass().getComponentType().getSimpleName());
        }
    }

    public static int binarySearch(@This Object array, @Self(value=true) Object key) {
        return ManArrayExt.binarySearch(array, 0, Array.getLength(array), key);
    }

    public static int binarySearch(@This Object array, int from, int to, @Self(value=true) Object key) {
        Class<?> componentType = array.getClass().getComponentType();
        if (componentType.isPrimitive()) {
            switch (componentType.getTypeName()) {
                case "byte": {
                    return Arrays.binarySearch((byte[])array, from, to, ((Number)key).byteValue());
                }
                case "short": {
                    return Arrays.binarySearch((short[])array, from, to, ((Number)key).shortValue());
                }
                case "int": {
                    return Arrays.binarySearch((int[])array, from, to, ((Number)key).intValue());
                }
                case "long": {
                    return Arrays.binarySearch((long[])array, from, to, ((Number)key).longValue());
                }
                case "float": {
                    return Arrays.binarySearch((float[])array, from, to, ((Number)key).floatValue());
                }
                case "double": {
                    return Arrays.binarySearch((double[])array, from, to, ((Number)key).doubleValue());
                }
                case "char": {
                    return Arrays.binarySearch((char[])array, from, to, ((Character)key).charValue());
                }
            }
            throw new UnsupportedOperationException("Binary search unsupported for: " + componentType);
        }
        return Arrays.binarySearch((Object[])array, from, to, key);
    }

    public static int binarySearch(@This Object array, @Self(value=true) Object key, Comparator<? super @Self(value=true) Object> comparator) {
        return Arrays.binarySearch((Object[])array, key, comparator);
    }

    public static int binarySearch(@This Object array, int from, int to, @Self(value=true) Object key, Comparator<? super @Self(value=true) Object> comparator) {
        return Arrays.binarySearch((Object[])array, from, to, key, comparator);
    }

    public static int hashCode(@This Object array) {
        Class<?> componentType = array.getClass().getComponentType();
        if (componentType.isPrimitive()) {
            switch (componentType.getTypeName()) {
                case "byte": {
                    return Arrays.hashCode((byte[])array);
                }
                case "short": {
                    return Arrays.hashCode((short[])array);
                }
                case "int": {
                    return Arrays.hashCode((int[])array);
                }
                case "long": {
                    return Arrays.hashCode((long[])array);
                }
                case "float": {
                    return Arrays.hashCode((float[])array);
                }
                case "double": {
                    return Arrays.hashCode((double[])array);
                }
                case "char": {
                    return Arrays.hashCode((char[])array);
                }
                case "boolean": {
                    return Arrays.hashCode((boolean[])array);
                }
            }
            throw new IllegalStateException();
        }
        return Arrays.deepHashCode((Object[])array);
    }

    public static boolean equals(@This Object array, @Self Object that) {
        Class<?> componentType = array.getClass().getComponentType();
        if (componentType.isPrimitive()) {
            switch (componentType.getTypeName()) {
                case "byte": {
                    return Arrays.equals((byte[])array, (byte[])that);
                }
                case "short": {
                    return Arrays.equals((short[])array, (short[])that);
                }
                case "int": {
                    return Arrays.equals((int[])array, (int[])that);
                }
                case "long": {
                    return Arrays.equals((long[])array, (long[])that);
                }
                case "float": {
                    return Arrays.equals((float[])array, (float[])that);
                }
                case "double": {
                    return Arrays.equals((double[])array, (double[])that);
                }
                case "char": {
                    return Arrays.equals((char[])array, (char[])that);
                }
                case "boolean": {
                    return Arrays.equals((boolean[])array, (boolean[])that);
                }
            }
            throw new IllegalStateException();
        }
        return Arrays.deepEquals((Object[])array, (Object[])that);
    }
}

