/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.highjump;

import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import manifold.api.highjump.Options;
import manifold.util.ReflectUtil;

class ExpressionClass {
    private static final LongAdder COUNT = new LongAdder();
    final String _fqn;
    final Options _options;
    Class<?> _class;

    public ExpressionClass(Options options, Map<String, ExpressionClass> fqnToExprClass) {
        this._options = options;
        this._fqn = "manifold.highjump.pkg.HjClass_" + ExpressionClass.incCount();
        fqnToExprClass.put(this._fqn, this);
    }

    Options getOptions() {
        return this._options;
    }

    Object evaluate() {
        ReflectUtil.ConstructorRef ctor = ReflectUtil.constructor(this.getExprClass(), new Class[0]);
        if (ctor == null) {
            throw new RuntimeException("Missing no-argument constructor: " + this.getExprClass().getTypeName());
        }
        return ReflectUtil.method(ctor.newInstance(new Object[0]), "evaluate", new Class[0]).invoke(new Object[0]);
    }

    Class<?> getExprClass() {
        if (this._class == null) {
            try {
                this._class = this._options.contextLoader == null ? Class.forName(this._fqn) : Class.forName(this._fqn, true, this._options.contextLoader);
            }
            catch (ClassNotFoundException e) {
                ClassLoader threadContextClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    this._class = Class.forName(this._fqn, true, threadContextClassLoader);
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this._class;
    }

    private static long incCount() {
        COUNT.increment();
        return COUNT.longValue();
    }
}

