/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.GraphQLError;
import graphql.Internal;
import graphql.language.Argument;
import graphql.language.AstPrinter;
import graphql.language.Directive;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumValueDefinition;
import graphql.language.FieldDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputObjectTypeExtensionDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.schema.idl.SchemaTypeChecker;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeInfo;
import graphql.schema.idl.errors.InvalidDeprecationDirectiveError;
import graphql.schema.idl.errors.MissingTypeError;
import graphql.schema.idl.errors.NonUniqueArgumentError;
import graphql.schema.idl.errors.NonUniqueDirectiveError;
import graphql.schema.idl.errors.NonUniqueNameError;
import graphql.schema.idl.errors.TypeExtensionDirectiveRedefinitionError;
import graphql.schema.idl.errors.TypeExtensionEnumValueRedefinitionError;
import graphql.schema.idl.errors.TypeExtensionFieldRedefinitionError;
import graphql.schema.idl.errors.TypeExtensionMissingBaseTypeError;
import graphql.util.FpKit;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@Internal
class SchemaTypeExtensionsChecker {
    SchemaTypeExtensionsChecker() {
    }

    void checkTypeExtensions(List<GraphQLError> errors, TypeDefinitionRegistry typeRegistry) {
        this.checkObjectTypeExtensions(errors, typeRegistry);
        this.checkInterfaceTypeExtensions(errors, typeRegistry);
        this.checkUnionTypeExtensions(errors, typeRegistry);
        this.checkEnumTypeExtensions(errors, typeRegistry);
        this.checkScalarTypeExtensions(errors, typeRegistry);
        this.checkInputObjectTypeExtensions(errors, typeRegistry);
    }

    private void checkObjectTypeExtensions(List<GraphQLError> errors, TypeDefinitionRegistry typeRegistry) {
        typeRegistry.objectTypeExtensions().forEach((name, extensions) -> {
            this.checkTypeExtensionHasCorrespondingType(errors, typeRegistry, (String)name, (List<? extends TypeDefinition>)extensions, (Class<? extends TypeDefinition>)ObjectTypeDefinition.class);
            this.checkTypeExtensionDirectiveRedefinition(errors, typeRegistry, (String)name, (List<? extends TypeDefinition>)extensions, (Class<? extends TypeDefinition>)ObjectTypeDefinition.class);
            extensions.forEach(extension -> {
                List<FieldDefinition> fieldDefinitions = extension.getFieldDefinitions();
                SchemaTypeChecker.checkNamedUniqueness(errors, extension.getFieldDefinitions(), FieldDefinition::getName, (namedField, fieldDef) -> new NonUniqueNameError((TypeDefinition)extension, (FieldDefinition)fieldDef));
                extension.getFieldDefinitions().forEach(fld -> SchemaTypeChecker.checkNamedUniqueness(errors, fld.getInputValueDefinitions(), InputValueDefinition::getName, (namedField, inputValueDefinition) -> new NonUniqueArgumentError((TypeDefinition)extension, (FieldDefinition)fld, (String)name)));
                extension.getFieldDefinitions().forEach(fld -> SchemaTypeChecker.checkNamedUniqueness(errors, fld.getDirectives(), Directive::getName, (directiveName, directive) -> new NonUniqueDirectiveError((TypeDefinition)extension, (FieldDefinition)fld, (String)directiveName)));
                fieldDefinitions.forEach(fld -> fld.getDirectives().forEach(directive -> {
                    SchemaTypeChecker.checkDeprecatedDirective(errors, directive, () -> new InvalidDeprecationDirectiveError((TypeDefinition)extension, (FieldDefinition)fld));
                    SchemaTypeChecker.checkNamedUniqueness(errors, directive.getArguments(), Argument::getName, (argumentName, argument) -> new NonUniqueArgumentError((TypeDefinition)extension, (FieldDefinition)fld, (String)argumentName));
                }));
                this.forEachBut((Object)extension, (List)extensions, otherTypeExt -> this.checkForFieldRedefinition(errors, (TypeDefinition)otherTypeExt, otherTypeExt.getFieldDefinitions(), fieldDefinitions));
                Optional<ObjectTypeDefinition> baseTypeOpt = typeRegistry.getType(extension.getName(), ObjectTypeDefinition.class);
                baseTypeOpt.ifPresent(baseTypeDef -> this.checkForFieldRedefinition(errors, (TypeDefinition)extension, fieldDefinitions, baseTypeDef.getFieldDefinitions()));
            });
        });
    }

    private void checkInterfaceTypeExtensions(List<GraphQLError> errors, TypeDefinitionRegistry typeRegistry) {
        typeRegistry.interfaceTypeExtensions().forEach((name, extensions) -> {
            this.checkTypeExtensionHasCorrespondingType(errors, typeRegistry, (String)name, (List<? extends TypeDefinition>)extensions, (Class<? extends TypeDefinition>)InterfaceTypeDefinition.class);
            this.checkTypeExtensionDirectiveRedefinition(errors, typeRegistry, (String)name, (List<? extends TypeDefinition>)extensions, (Class<? extends TypeDefinition>)InterfaceTypeDefinition.class);
            extensions.forEach(extension -> {
                List<FieldDefinition> fieldDefinitions = extension.getFieldDefinitions();
                SchemaTypeChecker.checkNamedUniqueness(errors, extension.getFieldDefinitions(), FieldDefinition::getName, (namedField, fieldDef) -> new NonUniqueNameError((TypeDefinition)extension, (FieldDefinition)fieldDef));
                extension.getFieldDefinitions().forEach(fld -> SchemaTypeChecker.checkNamedUniqueness(errors, fld.getInputValueDefinitions(), InputValueDefinition::getName, (namedField, inputValueDefinition) -> new NonUniqueArgumentError((TypeDefinition)extension, (FieldDefinition)fld, (String)name)));
                extension.getFieldDefinitions().forEach(fld -> SchemaTypeChecker.checkNamedUniqueness(errors, fld.getDirectives(), Directive::getName, (directiveName, directive) -> new NonUniqueDirectiveError((TypeDefinition)extension, (FieldDefinition)fld, (String)directiveName)));
                fieldDefinitions.forEach(fld -> fld.getDirectives().forEach(directive -> {
                    SchemaTypeChecker.checkDeprecatedDirective(errors, directive, () -> new InvalidDeprecationDirectiveError((TypeDefinition)extension, (FieldDefinition)fld));
                    SchemaTypeChecker.checkNamedUniqueness(errors, directive.getArguments(), Argument::getName, (argumentName, argument) -> new NonUniqueArgumentError((TypeDefinition)extension, (FieldDefinition)fld, (String)argumentName));
                }));
                this.forEachBut((Object)extension, (List)extensions, otherTypeExt -> this.checkForFieldRedefinition(errors, (TypeDefinition)otherTypeExt, otherTypeExt.getFieldDefinitions(), fieldDefinitions));
                Optional<InterfaceTypeDefinition> baseTypeOpt = typeRegistry.getType(extension.getName(), InterfaceTypeDefinition.class);
                baseTypeOpt.ifPresent(baseTypeDef -> this.checkForFieldRedefinition(errors, (TypeDefinition)extension, fieldDefinitions, baseTypeDef.getFieldDefinitions()));
            });
        });
    }

    private void checkUnionTypeExtensions(List<GraphQLError> errors, TypeDefinitionRegistry typeRegistry) {
        typeRegistry.unionTypeExtensions().forEach((name, extensions) -> {
            this.checkTypeExtensionHasCorrespondingType(errors, typeRegistry, (String)name, (List<? extends TypeDefinition>)extensions, (Class<? extends TypeDefinition>)UnionTypeDefinition.class);
            this.checkTypeExtensionDirectiveRedefinition(errors, typeRegistry, (String)name, (List<? extends TypeDefinition>)extensions, (Class<? extends TypeDefinition>)UnionTypeDefinition.class);
            extensions.forEach(extension -> {
                List<TypeName> memberTypes = extension.getMemberTypes().stream().map(t -> TypeInfo.typeInfo(t).getTypeName()).collect(Collectors.toList());
                SchemaTypeChecker.checkNamedUniqueness(errors, memberTypes, TypeName::getName, (namedMember, memberType) -> new NonUniqueNameError((UnionTypeDefinition)extension, (String)namedMember));
                memberTypes.forEach(memberType -> {
                    Optional<ObjectTypeDefinition> unionTypeDefinition = typeRegistry.getType((Type)memberType, ObjectTypeDefinition.class);
                    if (!unionTypeDefinition.isPresent()) {
                        errors.add(new MissingTypeError("union member", (TypeDefinition)extension, (TypeName)memberType));
                    }
                });
            });
        });
    }

    private void checkEnumTypeExtensions(List<GraphQLError> errors, TypeDefinitionRegistry typeRegistry) {
        typeRegistry.enumTypeExtensions().forEach((name, extensions) -> {
            this.checkTypeExtensionHasCorrespondingType(errors, typeRegistry, (String)name, (List<? extends TypeDefinition>)extensions, (Class<? extends TypeDefinition>)EnumTypeDefinition.class);
            this.checkTypeExtensionDirectiveRedefinition(errors, typeRegistry, (String)name, (List<? extends TypeDefinition>)extensions, (Class<? extends TypeDefinition>)EnumTypeDefinition.class);
            extensions.forEach(extension -> {
                List<EnumValueDefinition> enumValueDefinitions = extension.getEnumValueDefinitions();
                SchemaTypeChecker.checkNamedUniqueness(errors, enumValueDefinitions, EnumValueDefinition::getName, (namedField, enumValue) -> new NonUniqueNameError((TypeDefinition)extension, (EnumValueDefinition)enumValue));
                this.forEachBut((Object)extension, (List)extensions, otherTypeExt -> this.checkForEnumValueRedefinition(errors, (TypeDefinition)otherTypeExt, otherTypeExt.getEnumValueDefinitions(), enumValueDefinitions));
                Optional<EnumTypeDefinition> baseTypeOpt = typeRegistry.getType(extension.getName(), EnumTypeDefinition.class);
                baseTypeOpt.ifPresent(baseTypeDef -> this.checkForEnumValueRedefinition(errors, (TypeDefinition)extension, enumValueDefinitions, baseTypeDef.getEnumValueDefinitions()));
            });
        });
    }

    private void checkScalarTypeExtensions(List<GraphQLError> errors, TypeDefinitionRegistry typeRegistry) {
        typeRegistry.scalarTypeExtensions().forEach((name, extensions) -> {
            this.checkTypeExtensionHasCorrespondingType(errors, typeRegistry, (String)name, (List<? extends TypeDefinition>)extensions, (Class<? extends TypeDefinition>)ScalarTypeDefinition.class);
            this.checkTypeExtensionDirectiveRedefinition(errors, typeRegistry, (String)name, (List<? extends TypeDefinition>)extensions, (Class<? extends TypeDefinition>)ScalarTypeDefinition.class);
        });
    }

    private void checkInputObjectTypeExtensions(List<GraphQLError> errors, TypeDefinitionRegistry typeRegistry) {
        typeRegistry.inputObjectTypeExtensions().forEach((name, extensions) -> {
            this.checkTypeExtensionHasCorrespondingType(errors, typeRegistry, (String)name, (List<? extends TypeDefinition>)extensions, (Class<? extends TypeDefinition>)InputObjectTypeDefinition.class);
            this.checkTypeExtensionDirectiveRedefinition(errors, typeRegistry, (String)name, (List<? extends TypeDefinition>)extensions, (Class<? extends TypeDefinition>)InputObjectTypeDefinition.class);
            extensions.forEach(extension -> {
                List<InputValueDefinition> inputValueDefinitions = extension.getInputValueDefinitions();
                SchemaTypeChecker.checkNamedUniqueness(errors, inputValueDefinitions, InputValueDefinition::getName, (namedField, fieldDef) -> new NonUniqueNameError((InputObjectTypeDefinition)extension, (InputValueDefinition)fieldDef));
                inputValueDefinitions.forEach(fld -> SchemaTypeChecker.checkNamedUniqueness(errors, fld.getDirectives(), Directive::getName, (directiveName, directive) -> new NonUniqueDirectiveError((TypeDefinition)extension, (InputValueDefinition)fld, (String)directiveName)));
                inputValueDefinitions.forEach(fld -> fld.getDirectives().forEach(directive -> {
                    SchemaTypeChecker.checkDeprecatedDirective(errors, directive, () -> new InvalidDeprecationDirectiveError((TypeDefinition)extension, (InputValueDefinition)fld));
                    SchemaTypeChecker.checkNamedUniqueness(errors, directive.getArguments(), Argument::getName, (argumentName, argument) -> new NonUniqueArgumentError((TypeDefinition)extension, (InputValueDefinition)fld, (String)argumentName));
                }));
                this.forEachBut((Object)extension, (List)extensions, otherTypeExt -> this.checkForInputValueRedefinition(errors, (InputObjectTypeExtensionDefinition)otherTypeExt, otherTypeExt.getInputValueDefinitions(), inputValueDefinitions));
                Optional<InputObjectTypeDefinition> baseTypeOpt = typeRegistry.getType(extension.getName(), InputObjectTypeDefinition.class);
                baseTypeOpt.ifPresent(baseTypeDef -> this.checkForInputValueRedefinition(errors, (InputObjectTypeExtensionDefinition)extension, inputValueDefinitions, baseTypeDef.getInputValueDefinitions()));
            });
        });
    }

    private void checkTypeExtensionHasCorrespondingType(List<GraphQLError> errors, TypeDefinitionRegistry typeRegistry, String name, List<? extends TypeDefinition> extTypeList, Class<? extends TypeDefinition> targetClass) {
        TypeDefinition extensionDefinition = extTypeList.get(0);
        Optional<? extends TypeDefinition> typeDefinition = typeRegistry.getType(TypeName.newTypeName().name(name).build(), targetClass);
        if (!typeDefinition.isPresent()) {
            errors.add(new TypeExtensionMissingBaseTypeError(extensionDefinition));
        }
    }

    private void checkTypeExtensionDirectiveRedefinition(List<GraphQLError> errors, TypeDefinitionRegistry typeRegistry, String name, List<? extends TypeDefinition> extensions, Class<? extends TypeDefinition> targetClass) {
        Optional<? extends TypeDefinition> typeDefinition = typeRegistry.getType(TypeName.newTypeName().name(name).build(), targetClass);
        if (typeDefinition.isPresent() && typeDefinition.get().getClass().equals(targetClass)) {
            List<Directive> directives = typeDefinition.get().getDirectives();
            Map<String, Directive> directiveMap = FpKit.getByName(directives, Directive::getName, FpKit.mergeFirst());
            extensions.forEach(typeExt -> {
                List<Directive> extDirectives = typeExt.getDirectives();
                extDirectives.forEach(directive -> {
                    if (directiveMap.containsKey(directive.getName())) {
                        errors.add(new TypeExtensionDirectiveRedefinitionError((TypeDefinition)typeDefinition.get(), (Directive)directive));
                    }
                });
            });
        }
    }

    private void checkForFieldRedefinition(List<GraphQLError> errors, TypeDefinition typeDefinition, List<FieldDefinition> fieldDefinitions, List<FieldDefinition> referenceFieldDefinitions) {
        Map<String, FieldDefinition> referenceMap = FpKit.getByName(referenceFieldDefinitions, FieldDefinition::getName, FpKit.mergeFirst());
        fieldDefinitions.forEach(fld -> {
            FieldDefinition reference = (FieldDefinition)referenceMap.get(fld.getName());
            if (referenceMap.containsKey(fld.getName()) && !this.isSameType(fld.getType(), reference.getType())) {
                errors.add(new TypeExtensionFieldRedefinitionError(typeDefinition, (FieldDefinition)fld));
            }
        });
    }

    private void checkForInputValueRedefinition(List<GraphQLError> errors, InputObjectTypeExtensionDefinition typeDefinition, List<InputValueDefinition> inputValueDefinitions, List<InputValueDefinition> referenceInputValues) {
        Map<String, InputValueDefinition> referenceMap = FpKit.getByName(referenceInputValues, InputValueDefinition::getName, FpKit.mergeFirst());
        inputValueDefinitions.forEach(fld -> {
            InputValueDefinition reference = (InputValueDefinition)referenceMap.get(fld.getName());
            if (referenceMap.containsKey(fld.getName()) && !this.isSameType(fld.getType(), reference.getType())) {
                errors.add(new TypeExtensionFieldRedefinitionError((TypeDefinition)typeDefinition, (InputValueDefinition)fld));
            }
        });
    }

    private void checkForEnumValueRedefinition(List<GraphQLError> errors, TypeDefinition typeDefinition, List<EnumValueDefinition> enumValueDefinitions, List<EnumValueDefinition> referenceEnumValueDefinitions) {
        Map<String, EnumValueDefinition> referenceMap = FpKit.getByName(referenceEnumValueDefinitions, EnumValueDefinition::getName, FpKit.mergeFirst());
        enumValueDefinitions.forEach(fld -> {
            if (referenceMap.containsKey(fld.getName())) {
                errors.add(new TypeExtensionEnumValueRedefinitionError(typeDefinition, (EnumValueDefinition)fld));
            }
        });
    }

    private <T> void forEachBut(T butThisOne, List<T> list, Consumer<T> consumer) {
        for (T t : list) {
            if (t == butThisOne) continue;
            consumer.accept(t);
        }
    }

    private boolean isSameType(Type type1, Type type2) {
        String s1 = AstPrinter.printAst(type1);
        String s2 = AstPrinter.printAst(type2);
        return s1.equals(s2);
    }
}

