/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Assert;
import graphql.Internal;
import graphql.Scalars;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.Comment;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.DirectiveDefinition;
import graphql.language.DirectiveLocation;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.InputValueDefinition;
import graphql.language.IntValue;
import graphql.language.Node;
import graphql.language.NullValue;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.language.Value;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphqlTypeComparatorRegistry;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.util.FpKit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@Internal
public class SchemaGeneratorHelper {
    static final String NO_LONGER_SUPPORTED = "No longer supported";
    static final DirectiveDefinition DEPRECATED_DIRECTIVE_DEFINITION;

    public Object buildValue(Value value, GraphQLType requiredType) {
        Object result = null;
        if (GraphQLTypeUtil.isNonNull(requiredType)) {
            requiredType = GraphQLTypeUtil.unwrapOne(requiredType);
        }
        if (value == null) {
            return null;
        }
        if (requiredType instanceof GraphQLScalarType) {
            result = this.parseLiteral(value, (GraphQLScalarType)requiredType);
        } else if (requiredType instanceof GraphQLEnumType && value instanceof EnumValue) {
            result = ((EnumValue)value).getName();
        } else if (requiredType instanceof GraphQLEnumType && value instanceof StringValue) {
            result = ((StringValue)value).getValue();
        } else if (value instanceof ArrayValue && GraphQLTypeUtil.isList(requiredType)) {
            result = this.buildArrayValue(requiredType, (ArrayValue)value);
        } else if (value instanceof ObjectValue && requiredType instanceof GraphQLInputObjectType) {
            result = this.buildObjectValue((ObjectValue)value, (GraphQLInputObjectType)requiredType);
        } else if (!(value instanceof NullValue)) {
            Assert.assertShouldNeverHappen("cannot build value of type %s from object class %s with instance %s", requiredType.getName(), value.getClass().getSimpleName(), String.valueOf(value));
        }
        return result;
    }

    private Object parseLiteral(Value value, GraphQLScalarType requiredType) {
        if (value instanceof NullValue) {
            return null;
        }
        return requiredType.getCoercing().parseLiteral(value);
    }

    public Object buildArrayValue(GraphQLType requiredType, ArrayValue arrayValue) {
        GraphQLType wrappedType = GraphQLTypeUtil.unwrapOne(requiredType);
        List result = arrayValue.getValues().stream().map(item -> this.buildValue((Value)item, wrappedType)).collect(Collectors.toList());
        return result;
    }

    public Object buildObjectValue(ObjectValue defaultValue, GraphQLInputObjectType objectType) {
        LinkedHashMap map = new LinkedHashMap();
        defaultValue.getObjectFields().forEach(of -> map.put(of.getName(), this.buildValue(of.getValue(), objectType.getField(of.getName()).getType())));
        return map;
    }

    public String buildDescription(Node<?> node, Description description) {
        if (description != null) {
            return description.getContent();
        }
        List<Comment> comments = node.getComments();
        ArrayList<String> lines = new ArrayList<String>();
        for (Comment comment : comments) {
            String commentLine = comment.getContent();
            if (commentLine.trim().isEmpty()) {
                lines.clear();
                continue;
            }
            lines.add(commentLine);
        }
        if (lines.size() == 0) {
            return null;
        }
        return lines.stream().collect(Collectors.joining("\n"));
    }

    public String buildDeprecationReason(List<Directive> directives) {
        Optional<Directive> directive = (directives = directives == null ? Collections.emptyList() : directives).stream().filter(d -> "deprecated".equals(d.getName())).findFirst();
        if (directive.isPresent()) {
            Map<String, String> args = directive.get().getArguments().stream().collect(Collectors.toMap(Argument::getName, arg -> ((StringValue)arg.getValue()).getValue()));
            if (args.isEmpty()) {
                return NO_LONGER_SUPPORTED;
            }
            return args.get("reason");
        }
        return null;
    }

    public void addDeprecatedDirectiveDefinition(TypeDefinitionRegistry typeRegistry) {
        typeRegistry.add(DEPRECATED_DIRECTIVE_DEFINITION);
    }

    public GraphQLInputType buildDirectiveInputType(Value value) {
        if (value instanceof NullValue) {
            return Scalars.GraphQLString;
        }
        if (value instanceof FloatValue) {
            return Scalars.GraphQLFloat;
        }
        if (value instanceof StringValue) {
            return Scalars.GraphQLString;
        }
        if (value instanceof IntValue) {
            return Scalars.GraphQLInt;
        }
        if (value instanceof BooleanValue) {
            return Scalars.GraphQLBoolean;
        }
        if (value instanceof ArrayValue) {
            ArrayValue arrayValue = (ArrayValue)value;
            return GraphQLList.list(this.buildDirectiveInputType(this.getArrayValueWrappedType(arrayValue)));
        }
        return (GraphQLInputType)Assert.assertShouldNeverHappen("Directive values of type '%s' are not supported yet", value.getClass().getSimpleName());
    }

    private Value getArrayValueWrappedType(ArrayValue value) {
        if (value.getValues().isEmpty()) {
            return NullValue.Null;
        }
        List nonNullValueList = value.getValues().stream().filter(v -> !(v instanceof NullValue)).collect(Collectors.toList());
        if (nonNullValueList.isEmpty()) {
            return NullValue.Null;
        }
        Set distinctTypes = nonNullValueList.stream().map(Object::getClass).distinct().collect(Collectors.toSet());
        Assert.assertTrue(distinctTypes.size() == 1, "Arrays containing multiple types of values are not supported yet. Detected the following types [%s]", nonNullValueList.stream().map(Object::getClass).map(Class::getSimpleName).distinct().sorted().collect(Collectors.joining(",")));
        return (Value)nonNullValueList.get(0);
    }

    public GraphQLDirective buildDirective(Directive directive, Set<GraphQLDirective> directiveDefinitions, Introspection.DirectiveLocation directiveLocation, GraphqlTypeComparatorRegistry comparatorRegistry) {
        Optional<GraphQLDirective> directiveDefinition = directiveDefinitions.stream().filter(dd -> dd.getName().equals(directive.getName())).findFirst();
        GraphQLDirective.Builder builder = GraphQLDirective.newDirective().name(directive.getName()).description(this.buildDescription(directive, null)).comparatorRegistry(comparatorRegistry).validLocations(directiveLocation);
        List<GraphQLArgument> arguments = directive.getArguments().stream().map(arg -> this.buildDirectiveArgument((Argument)arg, directiveDefinition)).collect(Collectors.toList());
        if (directiveDefinition.isPresent()) {
            arguments = this.transferMissingArguments(arguments, directiveDefinition.get());
        }
        arguments.forEach(builder::argument);
        return builder.build();
    }

    private GraphQLArgument buildDirectiveArgument(Argument arg, Optional<GraphQLDirective> directiveDefinition) {
        GraphQLInputType inputType;
        Optional<GraphQLArgument> directiveDefArgument = directiveDefinition.map(dd -> dd.getArgument(arg.getName()));
        GraphQLArgument.Builder builder = GraphQLArgument.newArgument();
        builder.name(arg.getName());
        Object defaultValue = null;
        if (directiveDefArgument.isPresent()) {
            inputType = directiveDefArgument.get().getType();
            defaultValue = directiveDefArgument.get().getDefaultValue();
        } else {
            inputType = this.buildDirectiveInputType(arg.getValue());
        }
        builder.type(inputType);
        builder.defaultValue(defaultValue);
        Object value = this.buildValue(arg.getValue(), inputType);
        builder.value(value == null ? defaultValue : value);
        return builder.build();
    }

    private List<GraphQLArgument> transferMissingArguments(List<GraphQLArgument> arguments, GraphQLDirective directiveDefinition) {
        Map<String, GraphQLArgument> declaredArgs = FpKit.getByName(arguments, GraphQLArgument::getName, FpKit.mergeFirst());
        ArrayList<GraphQLArgument> argumentsOut = new ArrayList<GraphQLArgument>(arguments);
        for (GraphQLArgument directiveDefArg : directiveDefinition.getArguments()) {
            if (declaredArgs.containsKey(directiveDefArg.getName())) continue;
            GraphQLArgument missingArg = GraphQLArgument.newArgument().name(directiveDefArg.getName()).description(directiveDefArg.getDescription()).definition(directiveDefArg.getDefinition()).type(directiveDefArg.getType()).defaultValue(directiveDefArg.getDefaultValue()).value(directiveDefArg.getDefaultValue()).build();
            argumentsOut.add(missingArg);
        }
        return argumentsOut;
    }

    public GraphQLDirective buildDirectiveFromDefinition(DirectiveDefinition directiveDefinition, Function<Type, GraphQLInputType> inputTypeFactory) {
        GraphQLDirective.Builder builder = GraphQLDirective.newDirective().name(directiveDefinition.getName()).description(this.buildDescription(directiveDefinition, directiveDefinition.getDescription()));
        List<Introspection.DirectiveLocation> locations = this.buildLocations(directiveDefinition);
        locations.forEach(xva$0 -> builder.validLocations((Introspection.DirectiveLocation)((Object)xva$0)));
        List<GraphQLArgument> arguments = directiveDefinition.getInputValueDefinitions().stream().map(arg -> this.buildDirectiveArgumentFromDefinition((InputValueDefinition)arg, inputTypeFactory)).collect(Collectors.toList());
        arguments.forEach(builder::argument);
        return builder.build();
    }

    private GraphQLArgument buildDirectiveArgumentFromDefinition(InputValueDefinition arg, Function<Type, GraphQLInputType> inputTypeFactory) {
        GraphQLArgument.Builder builder = GraphQLArgument.newArgument().name(arg.getName()).definition(arg);
        GraphQLInputType inputType = inputTypeFactory.apply(arg.getType());
        builder.type(inputType);
        builder.value(this.buildValue(arg.getDefaultValue(), inputType));
        builder.defaultValue(this.buildValue(arg.getDefaultValue(), inputType));
        return builder.build();
    }

    private List<Introspection.DirectiveLocation> buildLocations(DirectiveDefinition directiveDefinition) {
        return directiveDefinition.getDirectiveLocations().stream().map(dl -> Introspection.DirectiveLocation.valueOf(dl.getName().toUpperCase())).collect(Collectors.toList());
    }

    static {
        DirectiveDefinition.Builder builder = DirectiveDefinition.newDirectiveDefinition().name("deprecated");
        builder.directiveLocation(DirectiveLocation.newDirectiveLocation().name(Introspection.DirectiveLocation.FIELD_DEFINITION.name()).build());
        builder.directiveLocation(DirectiveLocation.newDirectiveLocation().name(Introspection.DirectiveLocation.ENUM_VALUE.name()).build());
        builder.inputValueDefinition(InputValueDefinition.newInputValueDefinition().name("reason").type(TypeName.newTypeName().name("String").build()).defaultValue(StringValue.newStringValue().value(NO_LONGER_SUPPORTED).build()).build());
        DEPRECATED_DIRECTIVE_DEFINITION = builder.build();
    }
}

