/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.nextgen.result;

import graphql.Assert;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.execution.MergedField;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.nextgen.FetchedValueAnalysis;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Internal
public abstract class ExecutionResultNode {
    private final FetchedValueAnalysis fetchedValueAnalysis;
    private final NonNullableFieldWasNullException nonNullableFieldWasNullException;
    private final List<ExecutionResultNode> children;
    private final List<GraphQLError> errors;

    protected ExecutionResultNode(FetchedValueAnalysis fetchedValueAnalysis, NonNullableFieldWasNullException nonNullableFieldWasNullException, List<ExecutionResultNode> children, List<GraphQLError> errors) {
        this.fetchedValueAnalysis = fetchedValueAnalysis;
        this.nonNullableFieldWasNullException = nonNullableFieldWasNullException;
        this.children = Assert.assertNotNull(children);
        children.forEach(Assert::assertNotNull);
        this.errors = new ArrayList<GraphQLError>(errors);
    }

    public List<GraphQLError> getErrors() {
        return new ArrayList<GraphQLError>(this.errors);
    }

    public FetchedValueAnalysis getFetchedValueAnalysis() {
        return this.fetchedValueAnalysis;
    }

    public MergedField getMergedField() {
        return this.fetchedValueAnalysis.getExecutionStepInfo().getField();
    }

    public NonNullableFieldWasNullException getNonNullableFieldWasNullException() {
        return this.nonNullableFieldWasNullException;
    }

    public List<ExecutionResultNode> getChildren() {
        return new ArrayList<ExecutionResultNode>(this.children);
    }

    public Optional<NonNullableFieldWasNullException> getChildNonNullableException() {
        return this.children.stream().filter(executionResultNode -> executionResultNode.getNonNullableFieldWasNullException() != null).map(ExecutionResultNode::getNonNullableFieldWasNullException).findFirst();
    }

    public abstract ExecutionResultNode withNewChildren(List<ExecutionResultNode> var1);

    public abstract ExecutionResultNode withNewFetchedValueAnalysis(FetchedValueAnalysis var1);

    public abstract ExecutionResultNode withNewErrors(List<GraphQLError> var1);

    public String toString() {
        return this.getClass().getSimpleName() + "{fva=" + this.fetchedValueAnalysis + ", children=" + this.children + ", errors=" + this.errors + ", nonNullableEx=" + this.nonNullableFieldWasNullException + '}';
    }
}

