/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.PublicApi;
import graphql.execution.ExecutionPath;
import graphql.execution.MergedField;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeUtil;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;

@PublicApi
public class ExecutionStepInfo {
    private final GraphQLOutputType type;
    private final ExecutionPath path;
    private final ExecutionStepInfo parent;
    private final MergedField field;
    private final GraphQLFieldDefinition fieldDefinition;
    private final GraphQLObjectType fieldContainer;
    private final Map<String, Object> arguments;

    private ExecutionStepInfo(GraphQLOutputType type, GraphQLFieldDefinition fieldDefinition, MergedField field, ExecutionPath path, ExecutionStepInfo parent, Map<String, Object> arguments, GraphQLObjectType fieldsContainer) {
        this.fieldDefinition = fieldDefinition;
        this.field = field;
        this.path = path;
        this.parent = parent;
        this.type = Assert.assertNotNull(type, "you must provide a graphql type", new Object[0]);
        this.arguments = arguments;
        this.fieldContainer = fieldsContainer;
    }

    public GraphQLObjectType getFieldContainer() {
        return this.fieldContainer;
    }

    public GraphQLOutputType getType() {
        return this.type;
    }

    public GraphQLOutputType getUnwrappedNonNullType() {
        return (GraphQLOutputType)GraphQLTypeUtil.unwrapNonNull(this.type);
    }

    public GraphQLFieldDefinition getFieldDefinition() {
        return this.fieldDefinition;
    }

    public MergedField getField() {
        return this.field;
    }

    public ExecutionPath getPath() {
        return this.path;
    }

    public boolean isNonNullType() {
        return GraphQLTypeUtil.isNonNull(this.type);
    }

    public boolean isListType() {
        return GraphQLTypeUtil.isList(this.type);
    }

    public Map<String, Object> getArguments() {
        return Collections.unmodifiableMap(this.arguments);
    }

    public <T> T getArgument(String name) {
        return (T)this.arguments.get(name);
    }

    public ExecutionStepInfo getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public ExecutionStepInfo changeTypeWithPreservedNonNull(GraphQLOutputType newType) {
        Assert.assertTrue(!GraphQLTypeUtil.isNonNull(newType), "newType can't be non null", new Object[0]);
        if (this.isNonNullType()) {
            return new ExecutionStepInfo(GraphQLNonNull.nonNull(newType), this.fieldDefinition, this.field, this.path, this.parent, this.arguments, this.fieldContainer);
        }
        return new ExecutionStepInfo(newType, this.fieldDefinition, this.field, this.path, this.parent, this.arguments, this.fieldContainer);
    }

    public String simplePrint() {
        return GraphQLTypeUtil.simplePrint(this.type);
    }

    public String toString() {
        return "ExecutionStepInfo{ path=" + this.path + ", type=" + this.type + ", parent=" + this.parent + ", fieldDefinition=" + this.fieldDefinition + '}';
    }

    public ExecutionStepInfo transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public String getResultKey() {
        return this.field.getResultKey();
    }

    public static Builder newExecutionStepInfo() {
        return new Builder();
    }

    public static Builder newExecutionStepInfo(ExecutionStepInfo existing) {
        return new Builder(existing);
    }

    public static class Builder {
        GraphQLOutputType type;
        ExecutionStepInfo parentInfo;
        GraphQLFieldDefinition fieldDefinition;
        GraphQLObjectType fieldContainer;
        MergedField field;
        ExecutionPath path;
        Map<String, Object> arguments;

        private Builder() {
            this.arguments = Collections.emptyMap();
        }

        private Builder(ExecutionStepInfo existing) {
            this.type = existing.type;
            this.parentInfo = existing.parent;
            this.fieldDefinition = existing.fieldDefinition;
            this.fieldContainer = existing.fieldContainer;
            this.field = existing.field;
            this.path = existing.path;
            this.arguments = existing.getArguments();
        }

        public Builder type(GraphQLOutputType type) {
            this.type = type;
            return this;
        }

        public Builder parentInfo(ExecutionStepInfo executionStepInfo) {
            this.parentInfo = executionStepInfo;
            return this;
        }

        public Builder fieldDefinition(GraphQLFieldDefinition fieldDefinition) {
            this.fieldDefinition = fieldDefinition;
            return this;
        }

        public Builder field(MergedField field) {
            this.field = field;
            return this;
        }

        public Builder path(ExecutionPath executionPath) {
            this.path = executionPath;
            return this;
        }

        public Builder arguments(Map<String, Object> arguments) {
            this.arguments = arguments == null ? Collections.emptyMap() : arguments;
            return this;
        }

        public Builder fieldContainer(GraphQLObjectType fieldContainer) {
            this.fieldContainer = fieldContainer;
            return this;
        }

        public ExecutionStepInfo build() {
            return new ExecutionStepInfo(this.type, this.fieldDefinition, this.field, this.path, this.parentInfo, this.arguments, this.fieldContainer);
        }
    }
}

