/*
 * Decompiled with CFR 0.152.
 */
package manifold.json.rt.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import manifold.json.rt.api.DataBindings;
import manifold.json.rt.parser.Token;
import manifold.json.rt.parser.TokenType;
import manifold.json.rt.parser.Tokenizer;
import manifold.rt.api.Bindings;
import manifold.rt.api.util.Pair;

final class SimpleParserImpl {
    private final Tokenizer _tokenizer;
    private Token _token;
    private final List<String> _errors;
    private boolean _useBig;
    private boolean _withTokens;

    SimpleParserImpl(Tokenizer tokenizer, boolean useBig) {
        this._tokenizer = tokenizer;
        this._useBig = useBig;
        this._errors = new ArrayList<String>();
        this.advance();
    }

    Object parse() {
        return this.parse(false);
    }

    Object parse(boolean withTokens) {
        this._withTokens = withTokens;
        Object val2 = null;
        if (this._token.isValueType()) {
            val2 = this.parseValue();
        } else {
            this.addError();
        }
        return val2;
    }

    private void advance() {
        this._token = this._tokenizer.next();
    }

    private Object parseArray() {
        ArrayList<Object> arr = new ArrayList<Object>();
        this.advance();
        if (this._token.isValueType()) {
            arr.add(this.parseValue());
            while (this._token.getType() == TokenType.COMMA) {
                this.advance();
                arr.add(this.parseValue());
            }
        }
        this.checkAndSkip(TokenType.RSQUARE, "]");
        return arr;
    }

    private Object parseObject() {
        DataBindings map = new DataBindings(new LinkedHashMap<String, Object>());
        this.advance();
        if (this._token.getType() == TokenType.STRING) {
            this.parseMember(map);
            while (this._token.getType() == TokenType.COMMA) {
                this.advance();
                this.parseMember(map);
            }
        }
        this.checkAndSkip(TokenType.RCURLY, "}");
        return map;
    }

    private void parseMember(Bindings map) {
        Token keyToken = this._token;
        String key = this._token.getString();
        this.check(TokenType.STRING, "a string");
        this.check(TokenType.COLON, ":");
        Token valueToken = this._token;
        Object val2 = this.parseValue();
        map.put(key, this._withTokens ? new Pair<Token[], Object>(new Token[]{keyToken, valueToken}, val2) : val2);
    }

    private Object parseValue() {
        Object val2;
        switch (this._token.getType()) {
            case LCURLY: {
                val2 = this.parseObject();
                break;
            }
            case LSQUARE: {
                val2 = this.parseArray();
                break;
            }
            case INTEGER: {
                if (this._useBig) {
                    val2 = new BigInteger(this._token.getString());
                } else {
                    try {
                        val2 = Integer.parseInt(this._token.getString());
                    }
                    catch (NumberFormatException e0) {
                        try {
                            val2 = Long.parseLong(this._token.getString());
                        }
                        catch (NumberFormatException e1) {
                            val2 = 0;
                        }
                    }
                }
                this.advance();
                break;
            }
            case DOUBLE: {
                val2 = this._useBig ? new BigDecimal(this._token.getString()) : Double.valueOf(Double.parseDouble(this._token.getString()));
                this.advance();
                break;
            }
            case STRING: {
                val2 = this._token.getString();
                this.advance();
                break;
            }
            case TRUE: {
                val2 = true;
                this.advance();
                break;
            }
            case FALSE: {
                val2 = false;
                this.advance();
                break;
            }
            case NULL: {
                val2 = null;
                this.advance();
                break;
            }
            default: {
                val2 = null;
                this.addError();
            }
        }
        return val2;
    }

    private void addError() {
        this._errors.add("[" + this._token.getLineNumber() + ":" + this._token.getColumn() + "] Unexpected token '" + this._token.getString() + "'");
        this.advance();
    }

    private void check(TokenType type, String s) {
        if (this._token.getType() != type) {
            this._errors.add("[" + this._token.getLineNumber() + ":" + this._token.getColumn() + "] expecting '" + s + "', found '" + this._token.getString() + "'");
        }
        this.advance();
    }

    private void checkAndSkip(TokenType type, String s) {
        if (this._token.getType() != type) {
            this._errors.add("[" + this._token.getLineNumber() + ":" + this._token.getColumn() + "] expecting '" + s + "', found '" + this._token.getString() + "'");
            while (this._token.getType() != TokenType.EOF && this._token.getType() != type) {
                this.advance();
            }
        }
        this.advance();
    }

    List<String> getErrors() {
        return this._errors;
    }
}

