/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import manifold.api.fs.IFileUtil;
import manifold.util.ManExceptionUtil;

public class RenameSourceFilesForJava9Build {
    private static void doIt(int javaNum, int textNum) throws URISyntaxException, IOException {
        URI uri = RenameSourceFilesForJava9Build.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        Path target_classes_ = Paths.get(uri);
        Path manifold_ = target_classes_.getParent().getParent();
        Path src_ = manifold_.resolve("src").resolve("main").resolve("java");
        Files.walk(src_, new FileVisitOption[0]).forEach(pathJavaFile -> {
            String fileName;
            if (Files.isRegularFile(pathJavaFile, new LinkOption[0]) && (fileName = pathJavaFile.getFileName().toString()).endsWith(".java" + javaNum)) {
                String baseJavaFile = IFileUtil.getBaseName(fileName);
                if (baseJavaFile.endsWith("_" + javaNum)) {
                    String baseTextFile = baseJavaFile.substring(0, baseJavaFile.length() - 1) + textNum;
                    Path pathTextFile = pathJavaFile.getParent().resolve(baseTextFile + ".java");
                    if (Files.isRegularFile(pathTextFile, new LinkOption[0])) {
                        try {
                            Files.move(pathTextFile, pathJavaFile.getParent().resolve(baseTextFile + ".java" + textNum), new CopyOption[0]);
                        }
                        catch (IOException e) {
                            throw ManExceptionUtil.unchecked(e);
                        }
                    }
                    try {
                        Files.move(pathJavaFile, pathJavaFile.getParent().resolve(baseJavaFile + ".java"), new CopyOption[0]);
                    }
                    catch (IOException e) {
                        throw ManExceptionUtil.unchecked(e);
                    }
                }
                System.err.println("Found file without '_" + javaNum + "' base suffix: " + fileName);
            }
        });
    }

    public static class _9_will_become_java_files {
        public static void main(String[] args) throws IOException, URISyntaxException {
            RenameSourceFilesForJava9Build.doIt(9, 8);
        }
    }

    public static class _8_will_become_java_files {
        public static void main(String[] args) throws IOException, URISyntaxException {
            RenameSourceFilesForJava9Build.doIt(8, 9);
        }
    }
}

