/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext.props;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.AttrContextEnv;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Pair;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import manifold.api.type.ICompilerComponent;
import manifold.api.util.JavacDiagnostic;
import manifold.ext.ExtensionTransformer;
import manifold.ext.props.ClassReaderCompleter;
import manifold.ext.props.PropIssueMsg;
import manifold.ext.props.PropertyInference;
import manifold.ext.props.Util;
import manifold.ext.props.rt.api.Abstract;
import manifold.ext.props.rt.api.Final;
import manifold.ext.props.rt.api.PropOption;
import manifold.ext.props.rt.api.auto;
import manifold.ext.props.rt.api.get;
import manifold.ext.props.rt.api.override;
import manifold.ext.props.rt.api.propgen;
import manifold.ext.props.rt.api.set;
import manifold.ext.props.rt.api.tags.enter_finish;
import manifold.ext.props.rt.api.tags.enter_start;
import manifold.ext.props.rt.api.val;
import manifold.ext.props.rt.api.var;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.javac.ILetExpr;
import manifold.internal.javac.IssueReporter;
import manifold.internal.javac.JavacPlugin;
import manifold.internal.javac.ManAttr;
import manifold.internal.javac.ParentMap;
import manifold.internal.javac.TypeProcessor;
import manifold.rt.api.util.ManStringUtil;
import manifold.rt.api.util.Stack;
import manifold.util.ReflectUtil;

public class PropertyProcessor
implements ICompilerComponent,
TaskListener {
    private BasicJavacTask _javacTask;
    private Context _context;
    private Stack<Pair<JCTree.JCClassDecl, ArrayList<JCTree>>> _propertyStatements;
    private Map<Symbol.ClassSymbol, Set<Symbol.VarSymbol>> _propMap;
    private Map<Symbol.ClassSymbol, Set<Symbol.VarSymbol>> _backingMap;
    private Map<Symbol.ClassSymbol, Set<Symbol.VarSymbol>> _nonbackingMap;
    private PropertyInference _propInference;
    private Set<Symbol.ClassSymbol> _inferLater;
    private TaskEvent _taskEvent;
    private ParentMap _parents;

    @Override
    public void init(BasicJavacTask javacTask, TypeProcessor typeProcessor) {
        this._javacTask = javacTask;
        this._context = this._javacTask.getContext();
        this._propertyStatements = new Stack();
        this._propMap = new HashMap<Symbol.ClassSymbol, Set<Symbol.VarSymbol>>();
        this._backingMap = new HashMap<Symbol.ClassSymbol, Set<Symbol.VarSymbol>>();
        this._nonbackingMap = new HashMap<Symbol.ClassSymbol, Set<Symbol.VarSymbol>>();
        this._inferLater = new HashSet<Symbol.ClassSymbol>();
        this._parents = new ParentMap(() -> this.getCompilationUnit());
        if (JavacPlugin.instance() == null) {
            return;
        }
        typeProcessor.addTaskListener(this);
    }

    BasicJavacTask getJavacTask() {
        return this._javacTask;
    }

    Context getContext() {
        return this._context;
    }

    Tree getParent(Tree child) {
        return this._parents.getParent(child);
    }

    public Types getTypes() {
        return Types.instance(this.getContext());
    }

    public Names getNames() {
        return Names.instance(this.getContext());
    }

    public TreeMaker getTreeMaker() {
        return TreeMaker.instance(this.getContext());
    }

    public Symtab getSymtab() {
        return Symtab.instance(this.getContext());
    }

    @Override
    public void tailorCompiler() {
        this._context = this._javacTask.getContext();
        this._propInference = new PropertyInference(field -> this.addToBackingFields((Symbol.VarSymbol)field), () -> this.getContext());
        ClassReaderCompleter.replaceCompleter(this);
    }

    private CompilationUnitTree getCompilationUnit() {
        CompilationUnitTree compUnit;
        if (this._taskEvent != null && (compUnit = this._taskEvent.getCompilationUnit()) != null) {
            return compUnit;
        }
        return JavacPlugin.instance() != null ? JavacPlugin.instance().getTypeProcessor().getCompilationUnit() : null;
    }

    void inferPropertiesFromClassReader(Symbol.ClassSymbol classSym) {
        this._propInference.inferProperties(classSym);
        for (Symbol elem : classSym.getEnclosedElements()) {
            if (!(elem instanceof Symbol.ClassSymbol)) continue;
            this.inferPropertiesFromClassReader((Symbol.ClassSymbol)elem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void started(TaskEvent e) {
        if (e.getKind() != TaskEvent.Kind.ENTER && e.getKind() != TaskEvent.Kind.ANALYZE && e.getKind() != TaskEvent.Kind.GENERATE) {
            return;
        }
        this._taskEvent = e;
        try {
            this.ensureInitialized(this._taskEvent);
            for (Tree tree : e.getCompilationUnit().getTypeDecls()) {
                if (!(tree instanceof JCTree.JCClassDecl)) continue;
                JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)tree;
                if (e.getKind() == TaskEvent.Kind.ENTER) {
                    classDecl.accept(new Enter_Start());
                    continue;
                }
                if (e.getKind() == TaskEvent.Kind.ANALYZE) {
                    classDecl.accept(new Analyze_Start());
                    continue;
                }
                if (e.getKind() != TaskEvent.Kind.GENERATE) continue;
                new Generate_Start().handleClass(e.getTypeElement());
            }
        }
        finally {
            this._taskEvent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finished(TaskEvent e) {
        if (e.getKind() != TaskEvent.Kind.ENTER && e.getKind() != TaskEvent.Kind.ANALYZE && e.getKind() != TaskEvent.Kind.GENERATE) {
            return;
        }
        this._taskEvent = e;
        try {
            this.ensureInitialized(this._taskEvent);
            for (Tree tree : e.getCompilationUnit().getTypeDecls()) {
                if (!(tree instanceof JCTree.JCClassDecl)) continue;
                JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)tree;
                if (e.getKind() == TaskEvent.Kind.ENTER) {
                    classDecl.accept(new Enter_Finish());
                    continue;
                }
                if (e.getKind() == TaskEvent.Kind.ANALYZE) {
                    classDecl.accept(new Analyze_Finish());
                    continue;
                }
                if (e.getKind() != TaskEvent.Kind.GENERATE) continue;
                new Generate_Finish().handleClass(e.getTypeElement());
            }
        }
        finally {
            this._taskEvent = null;
        }
    }

    private Symbol.MethodSymbol resolveGetMethod(Type type, Symbol field) {
        Types types = this.getTypes();
        if (type instanceof Type.TypeVar) {
            type = types.erasure(type);
        }
        if (!(type.tsym instanceof Symbol.ClassSymbol)) {
            return null;
        }
        Type fieldType = types.memberType(type, field);
        Symbol.MethodSymbol method = ManAttr.getMethodSymbol(types, type, fieldType, this.getGetterName(field, true), (Symbol.ClassSymbol)type.tsym, 0);
        if (method == null) {
            method = ManAttr.getMethodSymbol(types, type, fieldType, this.getGetterName(field, false), (Symbol.ClassSymbol)type.tsym, 0);
        }
        return method;
    }

    private Symbol.MethodSymbol resolveSetMethod(Type type, Symbol field, Types types) {
        if (type instanceof Type.TypeVar) {
            type = types.erasure(type);
        }
        if (!(type.tsym instanceof Symbol.ClassSymbol)) {
            return null;
        }
        Type fieldType = types.memberType(type, field);
        Symbol.MethodSymbol setter = ManAttr.getMethodSymbol(types, type, fieldType, this.getSetterName(field.name), (Symbol.ClassSymbol)type.tsym, 1);
        if (setter == null && this.isIsName(field.name.toString()) && this.resolveGetMethod(type, field) != null) {
            Names names = Names.instance(this.getContext());
            Name name = names.fromString(ManStringUtil.uncapitalize(field.name.toString().substring(2)));
            setter = ManAttr.getMethodSymbol(types, type, fieldType, this.getSetterName(name), (Symbol.ClassSymbol)type.tsym, 1);
        }
        return setter;
    }

    private boolean isIsName(String name) {
        return name.length() > 2 && name.startsWith("is") && Character.isUpperCase(name.charAt(2));
    }

    void addToBackingFields(Symbol.VarSymbol propField) {
        this._backingMap.computeIfAbsent(propField.enclClass(), key -> new HashSet()).add(propField);
    }

    private void reportWarning(JCTree location, String message) {
        this.report(Diagnostic.Kind.WARNING, location, message);
    }

    private void reportError(JCTree location, String message) {
        this.report(Diagnostic.Kind.ERROR, location, message);
    }

    private void report(Diagnostic.Kind kind, JCTree location, String message) {
        this.report(this._taskEvent.getSourceFile(), location, kind, message);
    }

    public void report(JavaFileObject sourcefile, JCTree tree, Diagnostic.Kind kind, String msg) {
        IssueReporter<JavaFileObject> reporter = new IssueReporter<JavaFileObject>(this._javacTask::getContext);
        JavaFileObject file = sourcefile != null ? sourcefile : Util.getFile(tree, child -> this.getParent((Tree)child));
        reporter.report(new JavacDiagnostic(file, kind, tree.getStartPosition(), 0L, 0L, msg));
    }

    private String getGetterName(Symbol field, boolean isOk) {
        String name = field.name.toString();
        if (isOk && field.type == Symtab.instance((Context)this._context).booleanType) {
            if (this.startsWithIs(name)) {
                return name;
            }
            return "is" + ManStringUtil.capitalize(name);
        }
        return "get" + ManStringUtil.capitalize(name);
    }

    private String getGetterName(JCTree.JCVariableDecl tree, boolean isOk) {
        String name = tree.name.toString();
        if (isOk && tree.vartype.toString().equals("boolean")) {
            if (this.startsWithIs(name)) {
                return name;
            }
            return "is" + ManStringUtil.capitalize(name);
        }
        return "get" + ManStringUtil.capitalize(name);
    }

    private boolean startsWithIs(String name) {
        return name.length() > 2 && name.startsWith("is") && Character.isUpperCase(name.charAt(2));
    }

    private String getSetterName(Name name) {
        return "set" + ManStringUtil.capitalize(name.toString());
    }

    private void addAnnotation(Symbol.VarSymbol fieldSym, Class<? extends Annotation> annoClass) {
        Symbol.ClassSymbol annoSym = IDynamicJdk.instance().getTypeElement(this._context, this.getCompilationUnit(), annoClass.getTypeName());
        Attribute.Compound anno = new Attribute.Compound(annoSym.type, List.nil());
        fieldSym.appendAttributes(List.of(anno));
    }

    private void ensureInitialized(TaskEvent e) {
        JavacPlugin javacPlugin = JavacPlugin.instance();
        if (javacPlugin != null) {
            javacPlugin.initialize(e);
        }
    }

    class Generate_Finish {
        Generate_Finish() {
        }

        public void handleClass(TypeElement typeSym) {
            Set nonbackingFields;
            if (!(typeSym instanceof Symbol.ClassSymbol)) {
                return;
            }
            Symbol.ClassSymbol classSym = (Symbol.ClassSymbol)typeSym;
            Set backingFields = (Set)PropertyProcessor.this._propMap.get(classSym);
            if (backingFields != null) {
                for (Symbol.VarSymbol varSym : backingFields) {
                    Attribute.Compound propgenAnno = Util.getAnnotationMirror(varSym, propgen.class);
                    if (propgenAnno == null) continue;
                    varSym.flags_field = varSym.flags_field & 0xFFFFFFFFFFFFFFFDL | Util.getFlags(propgenAnno);
                }
                PropertyProcessor.this._propMap.remove(classSym);
            }
            if ((nonbackingFields = (Set)PropertyProcessor.this._nonbackingMap.get(classSym)) != null) {
                for (Symbol.VarSymbol varSym : nonbackingFields) {
                    Type t = varSym.type;
                    Symbol.VarSymbol sym = new Symbol.VarSymbol(varSym.flags_field, varSym.name, t, classSym);
                    sym.appendAttributes((List<Attribute.Compound>)varSym.getAnnotationMirrors());
                    ReflectUtil.method(ReflectUtil.field(classSym, "members_field").get(), "enter", Symbol.class).invoke(sym);
                }
            }
            PropertyProcessor.this._nonbackingMap.remove(classSym);
        }
    }

    class Generate_Start {
        Generate_Start() {
        }

        private void handleClass(TypeElement typeSym) {
            if (!(typeSym instanceof Symbol.ClassSymbol)) {
                return;
            }
            Symbol.ClassSymbol classSym = (Symbol.ClassSymbol)typeSym;
            IDynamicJdk.instance().getMembers(classSym, (Filter<Symbol>)((Filter)e -> e instanceof Symbol.VarSymbol), false).forEach(varSym -> this.handleField(classSym, (Symbol.VarSymbol)varSym));
        }

        private void handleField(Symbol.ClassSymbol classSym, Symbol.VarSymbol fieldSym) {
            long modifiers = fieldSym.flags_field;
            if (!Util.isPropertyField(fieldSym)) {
                return;
            }
            Set backingSymbols = (Set)PropertyProcessor.this._backingMap.get(classSym);
            if (backingSymbols.contains(fieldSym)) {
                int declaredAccess;
                int access = 2;
                Attribute.Compound auto2 = Util.getAnnotationMirror(fieldSym, auto.class);
                if (auto2 != null && (declaredAccess = Util.getDeclaredAccess(auto2)) >= 0) {
                    access = declaredAccess;
                }
                fieldSym.flags_field = fieldSym.flags_field & 0xFFFFFFFFFFFFFFF8L | (long)access;
                if (fieldSym.getRawAttributes().stream().noneMatch(c -> c.getAnnotationType().toString().contains(propgen.class.getSimpleName()))) {
                    Names names = Names.instance(PropertyProcessor.this._context);
                    Symtab symtab = Symtab.instance(PropertyProcessor.this._context);
                    Symbol.ClassSymbol propgenSym = IDynamicJdk.instance().getTypeElement(PropertyProcessor.this._context, PropertyProcessor.this.getCompilationUnit(), propgen.class.getTypeName());
                    Symbol.MethodSymbol nameMeth = (Symbol.MethodSymbol)IDynamicJdk.instance().getMembersByName(propgenSym, names.fromString("name")).iterator().next();
                    Symbol.MethodSymbol flagsMeth = (Symbol.MethodSymbol)IDynamicJdk.instance().getMembersByName(propgenSym, names.fromString("flags")).iterator().next();
                    Attribute.Compound propGenAnno = new Attribute.Compound(propgenSym.type, List.of(new Pair<Symbol.MethodSymbol, Attribute.Constant>(nameMeth, new Attribute.Constant(symtab.stringType, fieldSym.name.toString())), new Pair<Symbol.MethodSymbol, Attribute.Constant>(flagsMeth, new Attribute.Constant(symtab.longType, modifiers))));
                    fieldSym.appendAttributes(List.of(propGenAnno));
                    Set props = PropertyProcessor.this._propMap.computeIfAbsent(classSym, e -> new HashSet());
                    props.add(fieldSym);
                }
            } else {
                ReflectUtil.method(ReflectUtil.method(classSym, "members", new Class[0]).invoke(new Object[0]), "remove", Symbol.class).invoke(fieldSym);
                Set nonbacking = PropertyProcessor.this._nonbackingMap.computeIfAbsent(classSym, e -> new HashSet());
                nonbacking.add(fieldSym);
            }
        }
    }

    class Analyze_Finish
    extends TreeTranslator {
        private final Stack<JCTree.JCVariableDecl> _propDefs = new Stack();
        private final Stack<JCTree.JCMethodDecl> _methodDefs = new Stack();
        private final Stack<Pair<JCTree.JCClassDecl, Set<Symbol.VarSymbol>>> _backingSymbols = new Stack();
        private int tempVarIndex;

        Analyze_Finish() {
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl classDecl) {
            this._backingSymbols.push(new Pair(classDecl, new HashSet()));
            try {
                super.visitClassDef(classDecl);
                PropertyProcessor.this._backingMap.computeIfAbsent(classDecl.sym, e -> new HashSet()).addAll((Collection)this._backingSymbols.peek().snd);
            }
            finally {
                this._backingSymbols.pop();
            }
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            boolean isProp = Util.isPropertyField(tree.sym);
            if (isProp) {
                this._propDefs.push(tree);
            }
            try {
                super.visitVarDef(tree);
            }
            finally {
                if (isProp) {
                    this._propDefs.pop();
                }
            }
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
            this._methodDefs.push(tree);
            try {
                super.visitMethodDef(tree);
            }
            finally {
                this._methodDefs.pop();
            }
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess tree) {
            super.visitSelect(tree);
            JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)this._backingSymbols.peek().fst;
            if (!Util.isPropertyField(tree.sym) || this.keepRefToField(tree, tree.sym, classDecl)) {
                return;
            }
            Tree parent = PropertyProcessor.this.getParent(tree);
            if (parent instanceof JCTree.JCAssign && ((JCTree.JCAssign)parent).lhs == tree) {
                return;
            }
            if (parent instanceof JCTree.JCAssignOp && ((JCTree.JCAssignOp)parent).lhs == tree) {
                return;
            }
            if (parent instanceof JCTree.JCUnary) {
                switch (((JCTree.JCUnary)parent).getTag()) {
                    case POSTDEC: 
                    case POSTINC: 
                    case PREDEC: 
                    case PREINC: {
                        return;
                    }
                }
            }
            this.result = this.repalceWithGetter(tree);
        }

        public JCTree.JCExpression repalceWithGetter(JCTree.JCFieldAccess tree) {
            Symbol.MethodSymbol getMethod;
            Symbol.MethodSymbol methodSymbol = getMethod = Util.isReadableProperty(tree.sym) ? PropertyProcessor.this.resolveGetMethod(tree.selected.type, tree.sym) : null;
            if (getMethod != null) {
                JCTree.JCMethodDecl methodDecl;
                JCTree.JCMethodDecl jCMethodDecl = methodDecl = this._methodDefs.isEmpty() ? null : this._methodDefs.peek();
                if (methodDecl != null && methodDecl.sym == getMethod) {
                    ((Set)this._backingSymbols.peek().snd).add((Symbol.VarSymbol)tree.sym);
                    return tree;
                }
                if (!this.verifyAccess(tree, tree.sym, getMethod, "Read")) {
                    return tree;
                }
                TreeMaker make = PropertyProcessor.this.getTreeMaker();
                JCTree.JCExpression receiver = tree.selected;
                JCTree.JCMethodInvocation methodCall = make.Apply(List.nil(), make.Select(receiver, getMethod), List.nil());
                methodCall = this.configMethod(tree, getMethod, methodCall);
                return methodCall;
            }
            PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_CANNOT_ACCESS_WRITEONLY_PROPERTY.get(tree.sym.flatName()));
            return tree;
        }

        @Override
        public void visitIdent(JCTree.JCIdent tree) {
            super.visitIdent(tree);
            JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)this._backingSymbols.peek().fst;
            if (!Util.isPropertyField(tree.sym) || this.keepRefToField(tree, tree.sym, classDecl)) {
                return;
            }
            Tree parent = PropertyProcessor.this.getParent(tree);
            if (parent instanceof JCTree.JCAssign && ((JCTree.JCAssign)parent).lhs == tree) {
                return;
            }
            if (parent instanceof JCTree.JCAssignOp && ((JCTree.JCAssignOp)parent).lhs == tree) {
                return;
            }
            if (parent instanceof JCTree.JCUnary) {
                switch (((JCTree.JCUnary)parent).getTag()) {
                    case POSTDEC: 
                    case POSTINC: 
                    case PREDEC: 
                    case PREINC: {
                        return;
                    }
                }
            }
            this.result = this.replaceWithGetter(tree);
        }

        private JCTree.JCExpression replaceWithGetter(JCTree.JCIdent tree) {
            Symbol.MethodSymbol getMethod;
            Symbol.MethodSymbol methodSymbol = getMethod = Util.isReadableProperty(tree.sym) ? PropertyProcessor.this.resolveGetMethod(((JCTree.JCClassDecl)this._backingSymbols.peek().fst).type, tree.sym) : null;
            if (getMethod != null) {
                JCTree.JCMethodDecl methodDecl;
                JCTree.JCMethodDecl jCMethodDecl = methodDecl = this._methodDefs.isEmpty() ? null : this._methodDefs.peek();
                if (methodDecl != null && (methodDecl.sym == getMethod || this.overrides(methodDecl.sym, getMethod))) {
                    ((Set)this._backingSymbols.peek().snd).add((Symbol.VarSymbol)tree.sym);
                    if (!this._methodDefs.isEmpty() && this._methodDefs.peek().sym.isDefault()) {
                        PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_PROPERTY_IS_ABSTRACT.get(tree.sym.flatName()));
                    }
                    return tree;
                }
                if (!this.verifyAccess(tree, tree.sym, getMethod, "Read")) {
                    return tree;
                }
                TreeMaker make = PropertyProcessor.this.getTreeMaker();
                JCTree.JCExpression receiver = tree.sym.isStatic() ? make.Type(tree.sym.owner.type) : make.This(((JCTree.JCClassDecl)this._backingSymbols.peek().fst).type).setPos(tree.pos);
                JCTree.JCMethodInvocation methodCall = make.Apply(List.nil(), make.Select(receiver, getMethod).setPos(tree.pos), List.nil());
                methodCall = this.configMethod(tree, getMethod, methodCall);
                return methodCall;
            }
            PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_CANNOT_ACCESS_WRITEONLY_PROPERTY.get(tree.sym.flatName()));
            return tree;
        }

        @Override
        public void visitAssign(JCTree.JCAssign tree) {
            Symbol.MethodSymbol setMethod;
            JCTree.JCExpression lhsSelected;
            Symbol lhsSym;
            Type lhsSelectedType;
            JCTree.JCExpression lhs;
            super.visitAssign(tree);
            TreeMaker make = PropertyProcessor.this.getTreeMaker();
            if (tree.lhs instanceof JCTree.JCFieldAccess) {
                JCTree.JCFieldAccess fieldAccess;
                lhs = fieldAccess = (JCTree.JCFieldAccess)tree.lhs;
                lhsSelectedType = fieldAccess.selected.type;
                lhsSym = fieldAccess.sym;
                lhsSelected = fieldAccess.selected;
            } else if (tree.lhs instanceof JCTree.JCIdent && ((JCTree.JCIdent)tree.lhs).sym.owner instanceof Symbol.ClassSymbol) {
                JCTree.JCIdent ident = (JCTree.JCIdent)tree.lhs;
                lhs = ident;
                lhsSelectedType = ((JCTree.JCClassDecl)this._backingSymbols.peek().fst).type;
                lhsSym = ident.sym;
                lhsSelected = lhsSym.isStatic() ? make.Type(lhsSym.owner.type) : make.This(lhsSelectedType).setPos(tree.pos);
            } else {
                return;
            }
            JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)this._backingSymbols.peek().fst;
            if (!Util.isPropertyField(lhsSym) || this.keepRefToField(lhs, lhsSym, classDecl)) {
                return;
            }
            JCTree.JCMethodDecl methodDecl = this._methodDefs.isEmpty() ? null : this._methodDefs.peek();
            Symbol.MethodSymbol methodSymbol = setMethod = Util.isWritableProperty(lhsSym) ? PropertyProcessor.this.resolveSetMethod(lhsSelectedType, lhsSym, Types.instance(PropertyProcessor.this._context)) : null;
            if (setMethod != null) {
                if (methodDecl != null && (methodDecl.sym == setMethod || tree.lhs instanceof JCTree.JCIdent && this.overrides(methodDecl.sym, setMethod))) {
                    ((Set)this._backingSymbols.peek().snd).add((Symbol.VarSymbol)lhsSym);
                    return;
                }
                if (!this.verifyAccess(tree, lhsSym, setMethod, "Write")) {
                    return;
                }
                JCTree.JCExpression rhs = tree.rhs;
                List<Object> tempVars = List.nil();
                if (!(PropertyProcessor.this.getParent(tree) instanceof JCTree.JCExpressionStatement)) {
                    ++this.tempVarIndex;
                    JCTree[] rhsTemp = ExtensionTransformer.tempify(false, tree, make, rhs, PropertyProcessor.this._context, ExtensionTransformer.getEnclosingSymbol(tree, PropertyProcessor.this._context, child -> PropertyProcessor.this.getParent((Tree)child)), "setPropRhsTempVar" + this.tempVarIndex, this.tempVarIndex);
                    if (rhsTemp != null) {
                        tempVars = tempVars.append(rhsTemp[0]);
                        rhs = (JCTree.JCExpression)rhsTemp[1];
                    }
                }
                JCTree.JCMethodInvocation setCall = make.Apply(List.nil(), make.Select(lhsSelected, setMethod).setPos(tree.pos), List.of(rhs));
                setCall = this.configMethod(lhs, setMethod, setCall);
                if (!(PropertyProcessor.this.getParent(tree) instanceof JCTree.JCExpressionStatement)) {
                    tempVars = tempVars.append(make.Exec(setCall).setPos(tree.pos));
                    this.result = ILetExpr.makeLetExpr(make, tempVars, rhs, rhs.type, tree.pos);
                } else {
                    this.result = setCall;
                }
            } else {
                this.handleErrantAssignment(tree, lhsSym, lhsSelected, methodDecl);
            }
        }

        public void handleErrantAssignment(JCTree tree, Symbol lhsSym, JCTree.JCExpression lhsSelected, JCTree.JCMethodDecl methodDecl) {
            if (!this._propDefs.isEmpty() && this._propDefs.peek().sym == lhsSym) {
                ((Set)this._backingSymbols.peek().snd).add((Symbol.VarSymbol)lhsSym);
            } else if (methodDecl.sym.isConstructor() && lhsSelected.toString().equals("this") && lhsSym.owner == ((JCTree.JCClassDecl)this._backingSymbols.peek().fst).sym) {
                ((Set)this._backingSymbols.peek().snd).add((Symbol.VarSymbol)lhsSym);
            } else {
                PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_CANNOT_ASSIGN_READONLY_PROPERTY.get(lhsSym.flatName()));
            }
        }

        @Override
        public void visitUnary(JCTree.JCUnary tree) {
            super.visitUnary(tree);
            switch (tree.getTag()) {
                case POSTDEC: 
                case POSTINC: 
                case PREDEC: 
                case PREINC: {
                    this.genUnaryIncDec(tree);
                }
            }
        }

        private void genUnaryIncDec(JCTree.JCUnary tree) {
            Symbol.MethodSymbol setMethod;
            JCTree.JCExpression lhsSelected;
            Symbol lhsSym;
            Type lhsSelectedType;
            JCTree.JCExpression lhs;
            TreeMaker make = PropertyProcessor.this.getTreeMaker();
            if (tree.arg instanceof JCTree.JCFieldAccess) {
                JCTree.JCFieldAccess fieldAccess;
                lhs = fieldAccess = (JCTree.JCFieldAccess)tree.arg;
                lhsSelectedType = fieldAccess.selected.type;
                lhsSym = fieldAccess.sym;
                lhsSelected = fieldAccess.selected;
            } else if (tree.arg instanceof JCTree.JCIdent && ((JCTree.JCIdent)tree.arg).sym.owner instanceof Symbol.ClassSymbol) {
                JCTree.JCIdent ident = (JCTree.JCIdent)tree.arg;
                lhs = ident;
                lhsSelectedType = ((JCTree.JCClassDecl)this._backingSymbols.peek().fst).type;
                lhsSym = ident.sym;
                lhsSelected = lhsSym.isStatic() ? make.Type(lhsSym.owner.type) : make.This(lhsSelectedType).setPos(tree.pos);
            } else {
                return;
            }
            JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)this._backingSymbols.peek().fst;
            if (!Util.isPropertyField(lhsSym) || this.keepRefToField(lhs, lhsSym, classDecl)) {
                return;
            }
            JCTree.JCMethodDecl methodDecl = this._methodDefs.isEmpty() ? null : this._methodDefs.peek();
            Symbol.MethodSymbol methodSymbol = setMethod = Util.isWritableProperty(lhsSym) ? PropertyProcessor.this.resolveSetMethod(lhsSelectedType, lhsSym, Types.instance(PropertyProcessor.this._context)) : null;
            if (setMethod != null) {
                if (methodDecl != null && (methodDecl.sym == setMethod || tree.arg instanceof JCTree.JCIdent && this.overrides(methodDecl.sym, setMethod))) {
                    ((Set)this._backingSymbols.peek().snd).add((Symbol.VarSymbol)lhsSym);
                    return;
                }
                if (!this.verifyAccess(tree, lhsSym, setMethod, "Write")) {
                    return;
                }
                List<Object> tempVars = List.nil();
                ++this.tempVarIndex;
                JCTree[] argTemp = ExtensionTransformer.tempify(false, tree, make, lhsSelected, PropertyProcessor.this._context, ExtensionTransformer.getEnclosingSymbol(tree, PropertyProcessor.this._context, child -> PropertyProcessor.this.getParent((Tree)child)), "setPropArgTempVar" + this.tempVarIndex, this.tempVarIndex);
                if (argTemp != null) {
                    tempVars = tempVars.append(argTemp[0]);
                    lhsSelected = (JCTree.JCExpression)argTemp[1];
                    Type t = tree.arg.type;
                    lhs = make.Select(lhsSelected, lhsSym);
                    tree.arg = lhs;
                    tree.arg.pos = tree.pos;
                    tree.arg.type = t;
                }
                JCTree.JCExpression arg = tree.arg instanceof JCTree.JCIdent ? this.replaceWithGetter((JCTree.JCIdent)tree.arg) : this.repalceWithGetter((JCTree.JCFieldAccess)tree.arg);
                arg.setPos(tree.pos);
                ++this.tempVarIndex;
                argTemp = ExtensionTransformer.tempify(false, tree, make, arg, PropertyProcessor.this._context, ExtensionTransformer.getEnclosingSymbol(tree, PropertyProcessor.this._context, child -> PropertyProcessor.this.getParent((Tree)child)), "setPropArgTempVar" + this.tempVarIndex, this.tempVarIndex);
                if (argTemp != null) {
                    tempVars = tempVars.append(argTemp[0]);
                    arg = (JCTree.JCExpression)argTemp[1];
                }
                JCTree.JCExpression rhs = this.makeUnaryIncDecCall(tree, make, arg);
                ++this.tempVarIndex;
                argTemp = ExtensionTransformer.tempify(false, tree, make, rhs, PropertyProcessor.this._context, ExtensionTransformer.getEnclosingSymbol(tree, PropertyProcessor.this._context, child -> PropertyProcessor.this.getParent((Tree)child)), "setPropArgTempVar" + this.tempVarIndex, this.tempVarIndex);
                tempVars = tempVars.append(argTemp[0]);
                rhs = (JCTree.JCExpression)argTemp[1];
                JCTree.JCMethodInvocation setCall = make.Apply(List.nil(), make.Select(lhsSelected, setMethod).setPos(tree.pos), List.of(rhs));
                setCall = (JCTree.JCMethodInvocation)this.configMethod(lhs, setMethod, setCall).setPos(tree.pos);
                tempVars = tempVars.append(make.Exec(setCall).setPos(tree.pos));
                this.result = ILetExpr.makeLetExpr(make, tempVars, tree.getTag().isPostUnaryOp() ? arg : rhs, arg.type, tree.pos);
            } else {
                this.handleErrantAssignment(tree, lhsSym, lhsSelected, methodDecl);
            }
        }

        private boolean verifyAccess(JCTree.JCExpression ref, Symbol propSym, Symbol.MethodSymbol accessorMethod, String accessKind) {
            JCTree.JCClassDecl classDecl;
            if (!Util.sameAccess(accessorMethod, propSym) && !this.isAccessible(accessorMethod, classDecl = (JCTree.JCClassDecl)this._backingSymbols.peek().fst)) {
                PropertyProcessor.this.reportError(ref, PropIssueMsg.MSG_PROPERTY_NOT_ACCESSIBLE.get(accessKind, propSym.flatName(), PropOption.fromModifier(Util.getAccess(accessorMethod)).name().toLowerCase()));
                return false;
            }
            return true;
        }

        private boolean isAccessible(Symbol.MethodSymbol member, JCTree.JCClassDecl siteClass) {
            if (Modifier.isPublic((int)member.flags_field)) {
                return true;
            }
            Symbol.ClassSymbol siteClassSym = siteClass.sym;
            Symbol.ClassSymbol memberClassSym = member.enclClass();
            if (memberClassSym == siteClassSym || siteClassSym.outermostClass() == memberClassSym.outermostClass()) {
                return true;
            }
            if (Modifier.isProtected((int)member.flags_field)) {
                return siteClassSym.isSubClass(memberClassSym, Types.instance(PropertyProcessor.this.getContext()));
            }
            if (!Modifier.isPrivate((int)member.flags_field)) {
                return memberClassSym.packge().equals(siteClassSym.packge());
            }
            return false;
        }

        private boolean overrides(Symbol.MethodSymbol enclosingMethod, Symbol.MethodSymbol getMethod) {
            return enclosingMethod.name.equals(getMethod.name) && enclosingMethod.overrides(getMethod, getMethod.enclClass(), Types.instance(PropertyProcessor.this._context), false);
        }

        private boolean keepRefToField(JCTree.JCExpression tree, Symbol sym, JCTree.JCClassDecl classDecl) {
            if (ExtensionTransformer.isJailbreakReceiver(tree)) {
                return true;
            }
            Attribute.Compound auto2 = Util.getAnnotationMirror(sym, auto.class);
            if (auto2 == null) {
                return false;
            }
            int declaredAccess = Util.getDeclaredAccess(auto2);
            switch (declaredAccess) {
                case 2: {
                    return classDecl.sym.outermostClass() == sym.outermostClass();
                }
                case 0: {
                    return classDecl.sym.packge() == sym.packge();
                }
                case 4: {
                    return classDecl.sym.isSubClass(sym.enclClass(), Types.instance(PropertyProcessor.this._context));
                }
                case 1: {
                    return true;
                }
                case -1: {
                    if (tree instanceof JCTree.JCIdent && !this._methodDefs.isEmpty() && this._methodDefs.peek().sym.enclClass().isAnonymous()) {
                        PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_NASTY_INFERRED_PROPERTY_REF.get(sym.name));
                    }
                    return false;
                }
            }
            throw new IllegalStateException("Unknown or invalid access privilege: " + declaredAccess);
        }

        private JCTree.JCExpression makeUnaryIncDecCall(JCTree.JCUnary tree, TreeMaker make, JCTree.JCExpression operand) {
            Type unboxedType = PropertyProcessor.this.getTypes().unboxedType(operand.type);
            if (unboxedType != null && !unboxedType.hasTag(TypeTag.NONE)) {
                operand = ExtensionTransformer.unbox(PropertyProcessor.this.getTypes(), PropertyProcessor.this.getTreeMaker(), Names.instance(PropertyProcessor.this.getContext()), PropertyProcessor.this.getContext(), PropertyProcessor.this.getCompilationUnit(), operand, unboxedType);
            }
            JCTree.JCExpression one = make.Literal(1);
            one.pos = tree.pos;
            one = make.TypeCast(operand.type, one);
            one.pos = tree.pos;
            JCTree.JCBinary binary = make.Binary(tree.getTag() == JCTree.Tag.PREINC || tree.getTag() == JCTree.Tag.POSTINC ? JCTree.Tag.PLUS : JCTree.Tag.MINUS, operand, one);
            binary.pos = tree.pos;
            binary.type = operand.type;
            AttrContextEnv env = new AttrContextEnv((JCTree)tree, new AttrContext());
            env.toplevel = (JCTree.JCCompilationUnit)PropertyProcessor.this.getCompilationUnit();
            env.enclClass = ExtensionTransformer.getEnclosingClass(tree, child -> PropertyProcessor.this.getParent((Tree)child));
            binary.operator = ExtensionTransformer.resolveMethod(PropertyProcessor.this.getContext(), PropertyProcessor.this.getCompilationUnit(), tree.pos(), Names.instance(PropertyProcessor.this.getContext()).fromString(binary.getTag() == JCTree.Tag.PLUS ? "+" : "-"), PropertyProcessor.this.getSymtab().predefClass.type, List.of(binary.lhs.type, binary.rhs.type));
            return binary;
        }

        private JCTree.JCMethodInvocation configMethod(JCTree.JCExpression tree, Symbol.MethodSymbol methodSym, JCTree.JCMethodInvocation methodTree) {
            methodTree.setPos(tree.pos);
            methodTree.type = methodSym.getReturnType();
            methodTree.type = tree.type;
            return methodTree;
        }
    }

    class Analyze_Start
    extends TreeTranslator {
        private final Set<Symbol.ClassSymbol> _visited = new HashSet<Symbol.ClassSymbol>();

        Analyze_Start() {
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl classDecl) {
            super.visitClassDef(classDecl);
            this.inferProperties();
        }

        private void inferProperties() {
            if (PropertyProcessor.this._inferLater.isEmpty()) {
                return;
            }
            for (Symbol.ClassSymbol classSym : new HashSet(PropertyProcessor.this._inferLater)) {
                this.inferProperties(classSym);
            }
        }

        private void inferProperties(Symbol.TypeSymbol tsym) {
            if (!(tsym instanceof Symbol.ClassSymbol)) {
                return;
            }
            Symbol.ClassSymbol classSym = (Symbol.ClassSymbol)tsym;
            if (this._visited.contains(classSym)) {
                return;
            }
            this._visited.add(classSym);
            Type superclass = classSym.getSuperclass();
            if (superclass instanceof Type.ClassType) {
                this.inferProperties(superclass.tsym);
            }
            classSym.getInterfaces().forEach(iface -> this.inferProperties(iface.tsym));
            PropertyProcessor.this._propInference.inferProperties(classSym);
            PropertyProcessor.this._inferLater.remove(classSym);
        }
    }

    class Enter_Finish
    extends TreeTranslator {
        private final Stack<JCTree.JCClassDecl> _classes = new Stack();

        Enter_Finish() {
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl classDecl) {
            this._classes.push(classDecl);
            try {
                super.visitClassDef(classDecl);
                if (classDecl.sym != null) {
                    PropertyProcessor.this._inferLater.add(classDecl.sym);
                }
            }
            finally {
                this._classes.pop();
            }
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            super.visitVarDef(tree);
            if (!Util.isPropertyField(tree.sym)) {
                return;
            }
            if (Util.getAnnotationMirror(tree.sym, enter_finish.class) != null) {
                return;
            }
            PropertyProcessor.this.addAnnotation(tree.sym, enter_finish.class);
            this.verifyPropertyMethodsAgree(tree);
            this.verifyPropertyOverride(tree);
            JCTree.JCClassDecl cls = this._classes.peek();
            if (Util.isInterface(cls)) {
                Symbol.VarSymbol assignTransformLhsTemp66 = tree.sym;
                assignTransformLhsTemp66.flags_field = assignTransformLhsTemp66.flags_field & 0xFFFFFFFFFFFFFFEFL;
            }
        }

        private void verifyPropertyOverride(JCTree.JCVariableDecl tree) {
            Names names = Names.instance(PropertyProcessor.this._context);
            boolean readableProperty = Util.isReadableProperty(tree.sym);
            boolean writableProperty = Util.isWritableProperty(tree.sym);
            JCTree.JCAnnotation override2 = Util.getAnnotation(tree, override.class);
            if (override2 != null) {
                if (tree.sym.isStatic()) {
                    PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_DOES_NOT_OVERRIDE_ANYTHING.get(tree.name));
                } else if (readableProperty) {
                    Symbol.MethodSymbol superReadable = this.getSuperReadable(tree, names);
                    if (superReadable == null) {
                        if (!writableProperty) {
                            PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_DOES_NOT_OVERRIDE_ANYTHING.get(tree.name));
                        } else {
                            Symbol.MethodSymbol superWritable = this.getSuperWritable(tree, names);
                            if (superWritable == null) {
                                PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_DOES_NOT_OVERRIDE_ANYTHING.get(tree.name));
                            } else if (superWritable.isStatic()) {
                                PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_CANNOT_OVERRIDE_STATIC.get(tree.name, superWritable.name));
                            }
                        }
                    } else if (superReadable.isStatic()) {
                        PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_CANNOT_OVERRIDE_STATIC.get(tree.name, superReadable.name));
                    } else {
                        Type getterReturnType;
                        Types types = Types.instance(PropertyProcessor.this.getContext());
                        if (!types.isCastable(getterReturnType = types.memberType(tree.sym.enclClass().type, superReadable).getReturnType(), tree.sym.type)) {
                            PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_PROPERTY_CLASH_RETURN.get(tree.name, tree.sym.enclClass().className(), superReadable.enclClass().className()));
                        }
                    }
                } else if (writableProperty) {
                    Symbol.MethodSymbol superWritable = this.getSuperWritable(tree, names);
                    if (superWritable == null) {
                        PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_DOES_NOT_OVERRIDE_ANYTHING.get(tree.name));
                    } else if (superWritable.isStatic()) {
                        PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_CANNOT_OVERRIDE_STATIC.get(tree.name, superWritable.name));
                    }
                }
            } else if (!tree.sym.isStatic()) {
                Symbol.MethodSymbol superWritable;
                Symbol.MethodSymbol superReadable;
                if (readableProperty && (superReadable = this.getSuperReadable(tree, names)) != null) {
                    if (superReadable.isStatic()) {
                        PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_CANNOT_OVERRIDE_STATIC.get(tree.name, superReadable.name));
                    } else {
                        PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_MISSING_OVERRIDE.get(tree.name));
                    }
                    return;
                }
                if (writableProperty && (superWritable = this.getSuperWritable(tree, names)) != null) {
                    if (superWritable.isStatic()) {
                        PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_CANNOT_OVERRIDE_STATIC.get(tree.name, superWritable.name));
                    } else {
                        PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_MISSING_OVERRIDE.get(tree.name));
                    }
                }
            }
        }

        private Symbol.MethodSymbol getSuperWritable(JCTree.JCVariableDecl tree, Names names) {
            Name setterName = names.fromString(PropertyProcessor.this.getSetterName(tree.sym.name));
            Types types = Types.instance(PropertyProcessor.this._javacTask.getContext());
            return this.checkAncestry((Symbol.TypeSymbol)tree.sym.owner, superSym -> {
                for (Symbol member : IDynamicJdk.instance().getMembersByName((Symbol.ClassSymbol)superSym, setterName)) {
                    Type setterParamType;
                    if (!(member instanceof Symbol.MethodSymbol) || superSym.isInterface() && member.isStatic() || ((Symbol.MethodSymbol)member).params().size() != 1 || !types.isSameType(tree.sym.type, setterParamType = ((Type.MethodType)types.memberType((Type)tree.sym.enclClass().type, (Symbol)member)).argtypes.get(0))) continue;
                    return (Symbol.MethodSymbol)member;
                }
                return null;
            });
        }

        private Symbol.MethodSymbol getSuperReadable(JCTree.JCVariableDecl tree, Names names) {
            Name getterName = names.fromString(PropertyProcessor.this.getGetterName(tree.sym, true));
            return this.checkAncestry((Symbol.TypeSymbol)tree.sym.owner, superSym -> {
                for (Symbol member : IDynamicJdk.instance().getMembersByName((Symbol.ClassSymbol)superSym, getterName)) {
                    if (!(member instanceof Symbol.MethodSymbol) || superSym.isInterface() && member.isStatic() || !((Symbol.MethodSymbol)member).params().isEmpty()) continue;
                    return (Symbol.MethodSymbol)member;
                }
                return null;
            });
        }

        private Symbol.MethodSymbol checkAncestry(Symbol.TypeSymbol ts, Function<Symbol, Symbol.MethodSymbol> check) {
            if (!(ts instanceof Symbol.ClassSymbol)) {
                return null;
            }
            Symbol.ClassSymbol sym = (Symbol.ClassSymbol)ts;
            Type superclass = sym.getSuperclass();
            if (superclass != null && superclass.tsym != null) {
                Symbol.MethodSymbol method = check.apply(superclass.tsym);
                if (method != null) {
                    return method;
                }
                method = this.checkAncestry(superclass.tsym, check);
                if (method != null) {
                    return method;
                }
            }
            for (Type iface : sym.getInterfaces()) {
                Symbol.MethodSymbol method = check.apply(iface.tsym);
                if (method != null) {
                    return method;
                }
                method = this.checkAncestry(iface.tsym, check);
                if (method == null) continue;
                return method;
            }
            return null;
        }

        private void verifyPropertyMethodsAgree(JCTree.JCVariableDecl varDecl) {
            JCTree.JCAnnotation var2 = Util.getAnnotation(varDecl, var.class);
            JCTree.JCAnnotation val2 = Util.getAnnotation(varDecl, val.class);
            JCTree.JCAnnotation get2 = Util.getAnnotation(varDecl, get.class);
            JCTree.JCAnnotation set2 = Util.getAnnotation(varDecl, set.class);
            if (var2 == null && val2 == null && get2 == null && set2 == null) {
                throw new IllegalStateException();
            }
            this.verifyGetter(varDecl, var2, val2, get2);
            this.verifySetter(varDecl, var2, set2);
        }

        private void verifyGetter(JCTree.JCVariableDecl varDecl, JCTree.JCAnnotation var2, JCTree.JCAnnotation val2, JCTree.JCAnnotation get2) {
            Symbol.MethodSymbol getMethod = PropertyProcessor.this.resolveGetMethod(varDecl.sym.owner.type, varDecl.sym);
            if (var2 != null || val2 != null || get2 != null) {
                int accessModifier;
                JCTree.JCClassDecl classDecl = this._classes.peek();
                getMethod = this.checkStatic(classDecl, varDecl, varDecl.sym, getMethod);
                if (getMethod == null) {
                    return;
                }
                List<JCTree.JCExpression> args = get2 == null ? (val2 == null ? var2.args : val2.args) : get2.args;
                boolean getAbstract = Util.isAbstract(classDecl, varDecl) || Util.hasOption(args, PropOption.Abstract);
                boolean getFinal = Util.getAnnotation(varDecl, Final.class) != null || Util.hasOption(args, PropOption.Final);
                PropOption getAccess = Util.getAccess(classDecl, args);
                if (getAbstract != Modifier.isAbstract((int)getMethod.flags()) && classDecl.getKind() != Tree.Kind.INTERFACE) {
                    PropertyProcessor.this.reportError(varDecl, PropIssueMsg.MSG_PROPERTY_METHOD_CONFLICT.get(varDecl.sym.flatName(), getMethod.flatName(), "Abstract"));
                }
                if (getFinal != Modifier.isFinal((int)getMethod.flags())) {
                    PropertyProcessor.this.reportError(varDecl, PropIssueMsg.MSG_PROPERTY_METHOD_CONFLICT.get(varDecl.sym.flatName(), getMethod.flatName(), "Final"));
                }
                int n = accessModifier = getAccess == null ? Util.getAccess(classDecl, (int)varDecl.getModifiers().flags) : getAccess.getModifier();
                if ((getMethod.flags() & (long)accessModifier) != (long)accessModifier) {
                    PropertyProcessor.this.reportError(varDecl, PropIssueMsg.MSG_PROPERTY_METHOD_CONFLICT.get(varDecl.sym.flatName(), getMethod.flatName(), PropOption.fromModifier(accessModifier).name()));
                }
            } else if (getMethod != null) {
                if (getMethod.owner == varDecl.sym.owner) {
                    PropertyProcessor.this.reportError(varDecl, PropIssueMsg.MSG_GETTER_DEFINED_FOR_WRITEONLY.get(getMethod.flatName(), varDecl.sym.flatName()));
                } else {
                    PropertyProcessor.this.reportError(varDecl, PropIssueMsg.MSG_WRITEONLY_CANNOT_OVERRIDE_READABLE.get(getMethod.flatName(), varDecl.sym.flatName()));
                }
            }
        }

        private void verifySetter(JCTree.JCVariableDecl varDecl, JCTree.JCAnnotation var2, JCTree.JCAnnotation set2) {
            JCTree.JCClassDecl classDecl = this._classes.peek();
            Symbol.MethodSymbol setMethod = PropertyProcessor.this.resolveSetMethod(varDecl.sym.owner.type, varDecl.sym, Types.instance(PropertyProcessor.this._context));
            if (var2 != null || set2 != null) {
                int accessModifier;
                boolean setGenerated;
                if (setMethod != null) {
                    setMethod = this.checkStatic(classDecl, varDecl, varDecl.sym, setMethod);
                }
                if (setMethod == null) {
                    return;
                }
                List<JCTree.JCExpression> args = set2 == null ? var2.args : set2.args;
                boolean setAbstract = Util.isAbstract(classDecl, varDecl) || Util.hasOption(args, PropOption.Abstract);
                boolean setFinal = Util.getAnnotation(varDecl, Final.class) != null || Util.hasOption(args, PropOption.Final);
                PropOption setAccess = Util.getAccess(classDecl, args);
                boolean bl = setGenerated = Util.getAnnotation(varDecl, propgen.class) != null;
                if (setAbstract != Modifier.isAbstract((int)setMethod.flags()) && classDecl.getKind() != Tree.Kind.INTERFACE) {
                    PropertyProcessor.this.reportError(varDecl, PropIssueMsg.MSG_PROPERTY_METHOD_CONFLICT.get(varDecl.sym.flatName(), setMethod.flatName(), "Abstract"));
                }
                if (setFinal && Util.isInterface(classDecl)) {
                    PropertyProcessor.this.reportError(varDecl, PropIssueMsg.MSG_FINAL_NOT_ALLOWED_ON_ABSTRACT.get(new Object[0]));
                }
                if (setFinal != Modifier.isFinal((int)setMethod.flags())) {
                    if (setGenerated) {
                        throw new IllegalStateException("generated method should match property");
                    }
                    PropertyProcessor.this.reportError(varDecl, PropIssueMsg.MSG_PROPERTY_METHOD_CONFLICT.get(varDecl.sym.flatName(), setMethod.flatName(), "Final"));
                }
                int n = accessModifier = setAccess == null ? Util.getAccess(classDecl, (int)varDecl.getModifiers().flags) : setAccess.getModifier();
                if ((setMethod.flags() & (long)accessModifier) != (long)accessModifier) {
                    if (setGenerated) {
                        throw new IllegalStateException("generated method should match property");
                    }
                    PropertyProcessor.this.reportError(varDecl, PropIssueMsg.MSG_PROPERTY_METHOD_CONFLICT.get(varDecl.sym.flatName(), setMethod.flatName(), PropOption.fromModifier(accessModifier).name()));
                }
            } else if (setMethod != null) {
                if (setMethod.owner == varDecl.sym.owner) {
                    PropertyProcessor.this.reportError(varDecl, PropIssueMsg.MSG_SETTER_DEFINED_FOR_READONLY.get(setMethod.flatName(), varDecl.sym.flatName()));
                } else {
                    PropertyProcessor.this.reportError(varDecl, PropIssueMsg.MSG_READONLY_CANNOT_OVERRIDE_WRITABLE.get(setMethod.flatName(), varDecl.sym.flatName()));
                }
            }
        }

        private Symbol.MethodSymbol checkStatic(JCTree.JCClassDecl classDecl, JCTree.JCVariableDecl propDecl, Symbol field, Symbol.MethodSymbol method) {
            boolean isMethodStatic;
            if (method == null) {
                return null;
            }
            boolean isInterface = Util.isInterface(classDecl);
            boolean isPropStatic = isInterface ? ((int)propDecl.getModifiers().flags & 8) != 0 : ((int)field.flags_field & 8) != 0;
            boolean bl = isMethodStatic = ((int)method.flags_field & 8) != 0;
            if (isPropStatic != isMethodStatic) {
                if (isMethodStatic) {
                    PropertyProcessor.this.reportError(propDecl, PropIssueMsg.MSG_STATIC_MISMATCH.get(method.name, field.name));
                } else {
                    PropertyProcessor.this.reportError(propDecl, PropIssueMsg.MSG_NONSTATIC_MISMATCH.get(method.name, field.name));
                }
                method = null;
            }
            return method;
        }
    }

    private class Enter_Start
    extends TreeTranslator {
        private Enter_Start() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitClassDef(JCTree.JCClassDecl classDecl) {
            PropertyProcessor.this._propertyStatements.push(new Pair(classDecl, new ArrayList()));
            try {
                super.visitClassDef(classDecl);
                ArrayList addedDefs = (ArrayList)((Pair)((PropertyProcessor)PropertyProcessor.this)._propertyStatements.peek()).snd;
                if (!addedDefs.isEmpty()) {
                    ArrayList<JCTree> newDefs = new ArrayList<JCTree>(classDecl.defs);
                    newDefs.addAll(addedDefs);
                    classDecl.defs = List.from(newDefs);
                }
            }
            finally {
                PropertyProcessor.this._propertyStatements.pop();
            }
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            super.visitVarDef(tree);
            int modifiers = (int)tree.getModifiers().flags;
            JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)((Pair)((PropertyProcessor)PropertyProcessor.this)._propertyStatements.peek()).fst;
            if (classDecl.defs.contains(tree)) {
                List<JCTree.JCExpression> args;
                JCTree.JCExpression abstractType;
                boolean isFinal;
                if (Util.getAnnotation(tree, enter_start.class) != null) {
                    return;
                }
                JCTree.JCAnnotation var2 = Util.getAnnotation(tree, var.class);
                JCTree.JCAnnotation val2 = Util.getAnnotation(tree, val.class);
                JCTree.JCAnnotation get2 = Util.getAnnotation(tree, get.class);
                JCTree.JCAnnotation set2 = Util.getAnnotation(tree, set.class);
                if (var2 == null && val2 == null && get2 == null && set2 == null) {
                    return;
                }
                TreeMaker make = TreeMaker.instance(PropertyProcessor.this._context);
                JCTree.JCExpression enter_start2 = this.memberAccess(make, enter_start.class.getName());
                this.addAnnotations(tree, List.of(make.Annotation(enter_start2, List.nil())));
                if ((modifiers & 7) == 0) {
                    JCTree.JCModifiers assignTransformLhsTemp11 = tree.getModifiers();
                    assignTransformLhsTemp11.flags = assignTransformLhsTemp11.flags | 1L;
                }
                boolean isAbstract = Util.getAnnotation(tree, Abstract.class) != null;
                boolean bl = isFinal = Util.getAnnotation(tree, Final.class) != null;
                if ((modifiers & 0x400) != 0) {
                    JCTree.JCModifiers assignTransformLhsTemp22 = tree.getModifiers();
                    assignTransformLhsTemp22.flags = assignTransformLhsTemp22.flags & 0xFFFFFFFFFFFFFBFFL;
                    if (!isAbstract) {
                        abstractType = this.memberAccess(make, Abstract.class.getName());
                        this.addAnnotations(tree, List.of(make.Annotation(abstractType, List.nil())));
                        isAbstract = true;
                    }
                }
                if ((modifiers & 0x10) != 0) {
                    JCTree.JCModifiers assignTransformLhsTemp33 = tree.getModifiers();
                    assignTransformLhsTemp33.flags = assignTransformLhsTemp33.flags & 0xFFFFFFFFFFFFFFEFL;
                    if (!isFinal) {
                        abstractType = this.memberAccess(make, Final.class.getName());
                        this.addAnnotations(tree, List.of(make.Annotation(abstractType, List.nil())));
                        isFinal = true;
                    }
                }
                if ((val2 != null || get2 != null && set2 == null && var2 == null) && !isAbstract && !Util.isInterface(classDecl)) {
                    List<JCTree.JCExpression> args2;
                    List<JCTree.JCExpression> list = args2 = get2 == null ? val2.args : get2.args;
                    if (!Util.hasOption(args2, PropOption.Abstract)) {
                        JCTree.JCModifiers assignTransformLhsTemp44 = tree.getModifiers();
                        assignTransformLhsTemp44.flags = assignTransformLhsTemp44.flags | 0x10L;
                    }
                }
                if (isAbstract && !Util.isInterface(classDecl) && !Modifier.isAbstract((int)classDecl.getModifiers().flags)) {
                    PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_ABSTRACT_PROPERTY_IN_NONABSTRACT_CLASS.get(new Object[0]));
                    return;
                }
                if (isFinal && isAbstract) {
                    PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_FINAL_NOT_ALLOWED_ON_ABSTRACT.get(new Object[0]));
                    return;
                }
                if (isFinal && Util.isStatic(tree)) {
                    PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_FINAL_NOT_ALLOWED_ON_STATIC.get(new Object[0]));
                    return;
                }
                JCTree.JCMethodDecl generatedGetter = null;
                JCTree.JCMethodDecl generatedSetter = null;
                boolean shouldMakeProperty = !Modifier.isPrivate((int)tree.getModifiers().flags);
                Pair pair = (Pair)PropertyProcessor.this._propertyStatements.peek();
                if (var2 != null || val2 != null || get2 != null) {
                    args = get2 == null ? (val2 == null ? var2.args : val2.args) : get2.args;
                    boolean getAbstract = Util.isAbstract(classDecl, tree) || Util.hasOption(args, PropOption.Abstract);
                    boolean getFinal = isFinal || Util.hasOption(args, PropOption.Final);
                    PropOption getAccess = Util.getAccess(classDecl, args);
                    if (!Util.isInterface(classDecl) && this.isWeakerAccess(getAccess, Util.getAccess(modifiers))) {
                        PropertyProcessor.this.reportError(get2 != null ? get2 : var2, PropIssueMsg.MSG_ACCESSOR_WEAKER.get("get", PropOption.fromModifier(Util.getAccess(modifiers)).name().toLowerCase()));
                    }
                    if (getFinal && getAbstract) {
                        PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_FINAL_NOT_ALLOWED_ON_ABSTRACT.get(new Object[0]));
                    } else if (getFinal && Util.isStatic(tree)) {
                        PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_FINAL_NOT_ALLOWED_ON_STATIC.get(new Object[0]));
                    } else if (getAbstract && !Util.isInterface(classDecl) && !Modifier.isAbstract((int)classDecl.getModifiers().flags)) {
                        PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_ABSTRACT_PROPERTY_IN_NONABSTRACT_CLASS.get(new Object[0]));
                    } else {
                        JCTree.JCAnnotation anno = get2 == null ? (val2 == null ? var2 : val2) : get2;
                        generatedGetter = this.makeGetter(classDecl, tree, getAbstract, getFinal, getAccess, anno);
                        if (generatedGetter == null) {
                            shouldMakeProperty = true;
                            JCTree.JCModifiers assignTransformLhsTemp55 = tree.getModifiers();
                            assignTransformLhsTemp55.flags = assignTransformLhsTemp55.flags & 0xFFFFFFFFFFFFFFEFL;
                        }
                    }
                }
                if (var2 != null || set2 != null) {
                    args = set2 == null ? var2.args : set2.args;
                    boolean setAbstract = Util.isAbstract(classDecl, tree) || Util.isInterface(classDecl) || Util.hasOption(args, PropOption.Abstract);
                    boolean setFinal = isFinal || Util.hasOption(args, PropOption.Final);
                    PropOption setAccess = Util.getAccess(classDecl, args);
                    if (tree.init != null && setAbstract) {
                        PropertyProcessor.this.reportError(tree.init, PropIssueMsg.MSG_WRITABLE_ABSTRACT_PROPERTY_CANNOT_HAVE_INITIALIZER.get(tree.name));
                    }
                    if (!Util.isInterface(classDecl) && this.isWeakerAccess(setAccess, Util.getAccess(modifiers))) {
                        PropertyProcessor.this.reportError(set2 != null ? set2 : var2, PropIssueMsg.MSG_ACCESSOR_WEAKER.get("set", PropOption.fromModifier(Util.getAccess(modifiers)).name().toLowerCase()));
                    }
                    if (setFinal && setAbstract) {
                        PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_FINAL_NOT_ALLOWED_ON_ABSTRACT.get(new Object[0]));
                    } else if (setFinal && Util.isStatic(tree)) {
                        PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_FINAL_NOT_ALLOWED_ON_STATIC.get(new Object[0]));
                    } else if (setAbstract && !Util.isInterface(classDecl) && !Modifier.isAbstract((int)classDecl.getModifiers().flags)) {
                        PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_ABSTRACT_PROPERTY_IN_NONABSTRACT_CLASS.get(new Object[0]));
                    } else {
                        generatedSetter = this.makeSetter(classDecl, tree, setAbstract, setFinal, setAccess, set2 != null ? set2 : var2);
                        if (generatedSetter == null) {
                            shouldMakeProperty = true;
                        }
                    }
                }
                if (shouldMakeProperty) {
                    if ((generatedGetter != null || generatedSetter != null) && Util.isInterface(classDecl) && Util.isStatic(tree)) {
                        PropertyProcessor.this.reportError(tree, PropIssueMsg.MSG_INTERFACE_FIELD_BACKED_PROPERTY_NOT_SUPPORTED.get(new Object[0]));
                    } else {
                        if (generatedGetter != null) {
                            ((ArrayList)pair.snd).add(generatedGetter);
                        }
                        if (generatedSetter != null) {
                            ((ArrayList)pair.snd).add(generatedSetter);
                        }
                    }
                } else {
                    ArrayList annos = new ArrayList(tree.getModifiers().getAnnotations());
                    annos.remove(var2);
                    annos.remove(val2);
                    annos.remove(get2);
                    annos.remove(set2);
                    tree.getModifiers().annotations = List.from(annos);
                }
            }
        }

        private JCTree.JCMethodDecl makeGetter(JCTree.JCClassDecl classDecl, JCTree.JCVariableDecl propField, boolean propAbstract, boolean propFinal, PropOption propAccess, JCTree.JCAnnotation anno) {
            JCTree.JCMethodDecl getter;
            JCTree.JCMethodDecl existingGetter;
            Context context = PropertyProcessor.this._context;
            TreeMaker make = TreeMaker.instance(context);
            long flags = propField.getModifiers().flags;
            JCTree.JCAnnotation propgenAnno = this.makePropGenAnnotation(propField);
            List<JCTree.JCAnnotation> annos = List.of(propgenAnno);
            JCTree.JCModifiers access = this.getGetterSetterModifiers(make, Util.isInterface(classDecl), propAbstract, propFinal, Util.isStatic(propField), propAccess, (int)flags, annos, propField.pos);
            Name name = PropertyProcessor.this.getNames().fromString(PropertyProcessor.this.getGetterName(propField, true));
            JCTree.JCExpression resType = (JCTree.JCExpression)propField.vartype.clone();
            JCTree.JCBlock block = null;
            if (!propAbstract) {
                JCTree.JCReturn ret = Util.isInterface(classDecl) ? make.Return(propField.init) : make.Return(make.Ident(propField.name).setPos(propField.pos));
                block = (JCTree.JCBlock)make.Block(0L, List.of(ret)).setPos(propField.pos);
            }
            if ((existingGetter = this.findExistingAccessor(propField, classDecl, getter = (JCTree.JCMethodDecl)make.MethodDef(access, name, resType, List.nil(), List.nil(), List.nil(), block, null).setPos(propField.pos))) != null) {
                this.addAnnotations(existingGetter, List.of(propgenAnno));
                this.addAnnotations(existingGetter, this.getAnnotations(anno, "annos"));
                return null;
            }
            if (Util.isInterface(classDecl) && Util.isStatic(propField) && propField.init == null) {
                PropertyProcessor.this.reportError(propField, PropIssueMsg.MSG_MISSING_INTERFACE_STATIC_PROPERTY_ACCESSOR.get(classDecl.name, name + "() : " + propField.vartype.toString(), propField.name));
            } else {
                this.addAnnotations(getter, this.getAnnotations(anno, "annos"));
            }
            return getter;
        }

        private JCTree.JCMethodDecl makeSetter(JCTree.JCClassDecl classDecl, JCTree.JCVariableDecl propField, boolean propAbstract, boolean propFinal, PropOption propAccess, JCTree.JCAnnotation anno) {
            TreeMaker make = PropertyProcessor.this.getTreeMaker();
            long flags = propField.getModifiers().flags;
            JCTree.JCAnnotation propgenAnno = this.makePropGenAnnotation(propField);
            List<JCTree.JCAnnotation> annos = List.of(propgenAnno);
            JCTree.JCModifiers access = this.getGetterSetterModifiers(make, Util.isInterface(classDecl), propAbstract, propFinal, Util.isStatic(propField), propAccess, (int)flags, annos, propField.pos);
            Names names = PropertyProcessor.this.getNames();
            Name name = names.fromString(PropertyProcessor.this.getSetterName(propField.name));
            JCTree.JCVariableDecl param = (JCTree.JCVariableDecl)make.VarDef(make.Modifiers(0x200000010L), names.fromString("$value"), (JCTree.JCExpression)propField.vartype.clone(), null).setPos(propField.pos);
            JCTree.JCExpression resType = make.Type(PropertyProcessor.this.getSymtab().voidType).setPos(propField.pos);
            JCTree.JCExpressionStatement assign = (JCTree.JCExpressionStatement)make.Exec(make.Assign(make.Ident(propField.name).setPos(propField.pos), make.Ident(names.fromString("$value")).setPos(propField.pos)).setPos(propField.pos)).setPos(propField.pos);
            JCTree.JCBlock block = propAbstract ? null : (JCTree.JCBlock)make.Block(0L, List.of(assign)).setPos(propField.pos);
            JCTree.JCMethodDecl setter = (JCTree.JCMethodDecl)make.MethodDef(access, name, resType, List.nil(), List.of(param), List.nil(), block, null).setPos(propField.pos);
            JCTree.JCMethodDecl existingSetter = this.findExistingAccessor(propField, classDecl, setter);
            if (existingSetter != null) {
                this.addAnnotations(existingSetter, List.of(propgenAnno));
                return null;
            }
            if (Util.isInterface(classDecl) && Util.isStatic(propField) && propField.init == null) {
                PropertyProcessor.this.reportError(propField, PropIssueMsg.MSG_MISSING_INTERFACE_STATIC_PROPERTY_ACCESSOR.get(classDecl.name, name + "(" + propField.vartype.toString() + ")", propField.name));
            } else {
                this.addAnnotations(setter, this.getAnnotations(anno, "annos"));
                this.addAnnotations(param, this.getAnnotations(anno, "param"));
            }
            return setter;
        }

        private JCTree.JCMethodDecl findExistingAccessor(JCTree.JCVariableDecl propField, JCTree.JCClassDecl classDecl, JCTree.JCMethodDecl accessor) {
            block0: for (JCTree def : classDecl.defs) {
                if (!(def instanceof JCTree.JCMethodDecl)) continue;
                JCTree.JCMethodDecl tree = (JCTree.JCMethodDecl)def;
                if (accessor.name != tree.name || accessor.params.length() != tree.params.length()) continue;
                List<JCTree.JCVariableDecl> accessorParams = accessor.params;
                List<JCTree.JCVariableDecl> treeParams = tree.params;
                for (int i = 0; i < accessor.params.size(); ++i) {
                    JCTree.JCVariableDecl accessorParam = accessorParams.get(i);
                    JCTree.JCVariableDecl treeParam = treeParams.get(i);
                    if (!this.isSameType(tree, propField.getName(), accessorParam.vartype.toString(), treeParam.vartype.toString())) continue block0;
                }
                return tree;
            }
            return null;
        }

        private boolean isSameType(JCTree.JCMethodDecl tree, Name propName, String expected, String found) {
            if (expected.equals(found)) {
                return true;
            }
            if (this.ghettoErasure(expected).equals(this.ghettoErasure(found))) {
                PropertyProcessor.this.reportWarning(tree, PropIssueMsg.MSG_SETTER_TYPE_CONFLICT.get(found, propName, expected));
                return true;
            }
            return false;
        }

        private String ghettoErasure(String type) {
            int iOpen = type.indexOf(60);
            if (iOpen < 0) {
                return type;
            }
            String erasedType = type.substring(0, iOpen);
            int iClose = type.lastIndexOf(62);
            if (iClose < 0) {
                return erasedType;
            }
            if (iClose < type.length() - 1 && !(erasedType = erasedType + type.substring(iClose + 1)).endsWith("[]")) {
                throw new IllegalStateException("Expecting an array type");
            }
            return erasedType;
        }

        private void addAnnotations(JCTree.JCMethodDecl accessor, List<JCTree.JCAnnotation> propgenAnno) {
            ArrayList<JCTree.JCAnnotation> newAnnos = new ArrayList<JCTree.JCAnnotation>(accessor.getModifiers().annotations);
            newAnnos.addAll(propgenAnno);
            accessor.getModifiers().annotations = List.from(newAnnos);
        }

        private void addAnnotations(JCTree.JCVariableDecl varDecl, List<JCTree.JCAnnotation> propgenAnno) {
            ArrayList<JCTree.JCAnnotation> newAnnos = new ArrayList<JCTree.JCAnnotation>(varDecl.getModifiers().annotations);
            newAnnos.addAll(propgenAnno);
            varDecl.getModifiers().annotations = List.from(newAnnos);
        }

        private List<JCTree.JCAnnotation> getAnnotations(JCTree.JCAnnotation anno, String target) {
            for (JCTree.JCExpression arg : anno.args) {
                if (!(arg instanceof JCTree.JCAssign)) continue;
                JCTree.JCAssign assign = (JCTree.JCAssign)arg;
                if (!assign.lhs.toString().equals(target)) continue;
                if (assign.rhs instanceof JCTree.JCAnnotation) {
                    return List.of((JCTree.JCAnnotation)assign.rhs);
                }
                if (!(assign.rhs instanceof JCTree.JCNewArray)) continue;
                return List.from(((JCTree.JCNewArray)assign.rhs).elems);
            }
            return List.nil();
        }

        private JCTree.JCModifiers getGetterSetterModifiers(TreeMaker make, boolean isInterface, boolean propAbstract, boolean propFinal, boolean propStatic, PropOption propAccess, long flags, List<JCTree.JCAnnotation> annos, int pos) {
            long access;
            int iflags = (int)flags;
            long l = propAccess == null ? (Modifier.isPublic(iflags) ? 1L : (Modifier.isProtected(iflags) ? 4L : (Modifier.isPrivate(iflags) ? 2L : 0L))) : (access = (long)propAccess.getModifier());
            if (isInterface && !propAbstract && !propStatic) {
                access |= 0x80000000000L;
            }
            access |= (long)(propAbstract ? 1024 : 0);
            access |= (long)(propFinal ? 16 : 0);
            return (JCTree.JCModifiers)make.Modifiers(access |= (long)(propStatic ? 8 : 0), annos).setPos(pos);
        }

        private JCTree.JCAnnotation makePropGenAnnotation(JCTree.JCVariableDecl field) {
            TreeMaker make = TreeMaker.instance(PropertyProcessor.this.getContext());
            Names names = Names.instance(PropertyProcessor.this.getContext());
            ArrayList<JCTree.JCAssign> args = new ArrayList<JCTree.JCAssign>();
            args.add(make.Assign(make.Ident(names.fromString("name")), make.Literal(field.name.toString())));
            args.add(make.Assign(make.Ident(names.fromString("flags")), make.Literal(field.getModifiers().flags)));
            this.maybeAddAnnotation(field, args, var.class);
            this.maybeAddAnnotation(field, args, val.class);
            this.maybeAddAnnotation(field, args, get.class);
            this.maybeAddAnnotation(field, args, set.class);
            this.maybeAddAnnotation(field, args, Abstract.class);
            this.maybeAddAnnotation(field, args, Final.class);
            JCTree.JCExpression propgenType = this.memberAccess(make, propgen.class.getName());
            return make.Annotation(propgenType, List.from(args));
        }

        private void maybeAddAnnotation(JCTree.JCVariableDecl field, ArrayList<JCTree.JCAssign> args, Class<? extends Annotation> cls) {
            TreeMaker make = TreeMaker.instance(PropertyProcessor.this.getContext());
            Names names = Names.instance(PropertyProcessor.this.getContext());
            for (JCTree.JCAnnotation anno : field.getModifiers().getAnnotations()) {
                if (!cls.getSimpleName().equals(anno.annotationType.toString()) && !cls.getTypeName().equals(anno.annotationType.toString())) continue;
                args.add(make.Assign(make.Ident(names.fromString(cls.getSimpleName())), anno));
            }
        }

        private JCTree.JCExpression memberAccess(TreeMaker make, String path) {
            return this.memberAccess(make, path.split("\\."));
        }

        private JCTree.JCExpression memberAccess(TreeMaker make, String ... components) {
            Names names = Names.instance(PropertyProcessor.this.getContext());
            JCTree.JCExpression expr = make.Ident(names.fromString(components[0]));
            for (int i = 1; i < components.length; ++i) {
                expr = make.Select(expr, names.fromString(components[i]));
            }
            return expr;
        }

        private boolean isWeakerAccess(PropOption accessorOpt, int propAccess) {
            if (accessorOpt == null) {
                return false;
            }
            int accessorAccess = accessorOpt.getModifier();
            return accessorAccess == 1 && propAccess != 1 || accessorAccess == 4 && (propAccess == 0 || propAccess == 2) || accessorAccess == 0 && propAccess == 2;
        }
    }
}

