/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.util.cache;

import manifold.api.host.AbstractTypeSystemListener;
import manifold.api.host.IManifoldHost;
import manifold.api.host.RefreshRequest;
import manifold.util.concurrent.Cache;

public class TypeSystemAwareCache<K, V>
extends Cache<K, V> {
    private final AbstractTypeSystemListener _cacheClearer = new CacheClearer(this);

    public static <K, V> TypeSystemAwareCache<K, V> make(IManifoldHost host, String name, int size, Cache.Loader<K, V> loader) {
        return new TypeSystemAwareCache<K, V>(host, name, size, loader);
    }

    public TypeSystemAwareCache(IManifoldHost host, String name, int size, Cache.Loader<K, V> loader) {
        super(name, size, loader);
        host.addTypeSystemListenerAsWeakRef(null, this._cacheClearer);
    }

    private static class CacheClearer
    extends AbstractTypeSystemListener {
        TypeSystemAwareCache _cache;

        private CacheClearer(TypeSystemAwareCache cache) {
            this._cache = cache;
        }

        @Override
        public void refreshed() {
            this._cache.clear();
        }

        @Override
        public void refreshedTypes(RefreshRequest request) {
            this._cache.clear();
        }
    }
}

